package com.flybits.commons.library.api.idps

import android.os.Parcel
import android.os.Parcelable
import org.json.JSONObject
import java.util.*

private const val JWTLOGIN_ENDPOINT = "/jwtlogin/sessions"
private const val JWT_PROVIDER = "jwtlogin"

/**
 * The [JwtLoginIDP] class is responsible for accepting and authenticating the clientJwt.
 * Flybits server will return a jwt to be saved in user device and later used for future communication.
 */
class JwtLoginIDP : IDP {

    private val clientJwt: String

    /**
     * Constructor used for JwtLoginIDP.
     *
     * @param jwt The Token is a security token that contains Claims about the Authentication
     *                  of an End-User by an Authorization Server.
     */
    constructor(clientJwt: String) : super(JWT_PROVIDER) {
        this.clientJwt = clientJwt
    }

    /**
     * Constructor used to read the data
     *
     * @param parcel The parcel is for reading the attribute idToken
     *
     */
    constructor(parcel: Parcel) : super(parcel) {
        clientJwt = parcel.readString() ?: ""
    }

    override val authenticationEndPoint: String?
        get() = JWTLOGIN_ENDPOINT

    override fun getRequestType(): HttpMethod {
        return HttpMethod.POST
    }

    override fun getHeaders(): HashMap<String, String> {
        val headers = HashMap<String, String>()
        headers["Authorization"] = "Bearer $clientJwt"
        return headers
    }

    override fun getBody(): JSONObject? = null

    override fun describeContents() = 0

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        super.writeToParcel(parcel, flags)
        parcel.writeString(clientJwt)
    }

    companion object CREATOR : Parcelable.Creator<JwtLoginIDP> {
        override fun createFromParcel(parcel: Parcel): JwtLoginIDP {
            return JwtLoginIDP(parcel)
        }

        override fun newArray(size: Int): Array<JwtLoginIDP?> {
            return arrayOfNulls(size)
        }
    }
}