package com.flybits.commons.library.api.idps

import android.os.Parcel
import android.os.Parcelable
import com.flybits.commons.library.utils.Utilities
import com.flybits.commons.library.utils.Utilities.setValuesToBody
import org.json.JSONException
import org.json.JSONObject

/**
 * The `AnonymousIDP` class is responsible for logging into the Flybits system anonymously
 * without having to enter any additional information. This IDP is the default IDP for the Android
 * SDK. It can be overridden by other IDPs such as [JwtIDP].
 */
class AnonymousIDP : IDP {

    /**
     * Constructor used to register an anonymous account to the Flybits system.
     */
    constructor() : super("anonymous")
    private constructor(`in`: Parcel) : super(`in`)

    override val authenticationEndPoint: String
        get() = "/anonymous"

    override fun getBody(): JSONObject {
        val bodyObject = JSONObject()
        return setValuesToBody("projectId", getProjectID(), bodyObject)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object {
        @JvmField val CREATOR: Parcelable.Creator<AnonymousIDP?> = object : Parcelable.Creator<AnonymousIDP?> {
            override fun createFromParcel(`in`: Parcel): AnonymousIDP {
                return AnonymousIDP(`in`)
            }

            override fun newArray(size: Int): Array<AnonymousIDP?> {
                return arrayOfNulls(size)
            }
        }
    }
}