/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.android.common.revenue;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ProductDetails;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.QueryProductDetailsParams;
import com.flurry.android.common.revenue.BillingClientConnection;
import com.flurry.android.common.revenue.ProductsDetailsCallback;
import com.flurry.sdk.cx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BillingManager {
    public static final String REVENUE_PRICE_FORMAT = "%1$.2f";
    private static boolean a = false;
    private static BillingManager b;
    private BillingClient c;
    private boolean d;

    private static boolean a() {
        if (a) {
            return a;
        }
        try {
            Class.forName("com.android.billingclient.api.BillingClient");
            a = true;
        }
        catch (Throwable throwable) {
            cx.b("BillingManager", "Could not find Google Play Billing library: " + throwable.getMessage());
        }
        return a;
    }

    public static BillingManager getInstance(Context context) {
        if (b == null) {
            b = new BillingManager(context);
        }
        return b;
    }

    private BillingManager(Context context) {
        if (!BillingManager.a()) {
            return;
        }
        PurchasesUpdatedListener purchasesUpdatedListener = (billingResult, list) -> {};
        this.c = BillingClient.newBuilder((Context)context).enablePendingPurchases().setListener(purchasesUpdatedListener).build();
    }

    public void startConnection(@NonNull BillingClientConnection billingClientConnection) {
        if (!BillingManager.a()) {
            return;
        }
        if (this.d) {
            cx.a("BillingManager", "onBillingService already connected");
            billingClientConnection.onConnected();
            return;
        }
        this.c.startConnection((BillingClientStateListener)new FlurryBillingClientStateListener(billingClientConnection));
    }

    private void a(String string, Set<String> object2, ProductsDetailsCallback productsDetailsCallback) {
        if (!BillingManager.a()) {
            return;
        }
        if (this.d) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                string2 = QueryProductDetailsParams.Product.newBuilder().setProductId(string2).setProductType(string).build();
                arrayList.add(string2);
            }
            object2 = QueryProductDetailsParams.newBuilder().setProductList(arrayList).build();
            this.c.queryProductDetailsAsync((QueryProductDetailsParams)object2, (object, list) -> {
                int n2 = object.getResponseCode();
                object = object.getDebugMessage();
                if (n2 == 0) {
                    cx.a("BillingManager", "onProductDetailsResponse: " + n2 + " " + (String)object);
                    if (list != null && !list.isEmpty()) {
                        productsDetailsCallback.onProductsDetails(new ArrayList<Object>(list));
                        return;
                    }
                } else {
                    cx.b("BillingManager", "onProductDetailsResponse: " + n2 + " " + (String)object);
                }
            });
        }
    }

    public static boolean isValidPurchases(List<Object> object) {
        if (!BillingManager.a()) {
            return false;
        }
        if (object == null || object.isEmpty()) {
            cx.b("BillingManager", "Purchase list is empty.");
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (object.next() instanceof Purchase) continue;
            cx.b("BillingManager", "Purchase list contains invalid Purchase object.");
            return false;
        }
        return true;
    }

    @NonNull
    public static List<String> getProducts(Object object) {
        if (BillingManager.a() && object instanceof Purchase) {
            return ((Purchase)object).getProducts();
        }
        return new ArrayList<String>();
    }

    @NonNull
    public static Map<String, String> getPurchaseParams(Object object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!BillingManager.a()) {
            return hashMap;
        }
        if (object instanceof Purchase) {
            String string = ((Purchase)object).getOrderId();
            String string2 = String.valueOf(((Purchase)object).getQuantity());
            ((Purchase)object).getPurchaseToken();
            ((Purchase)object).getSignature();
            hashMap.put("fl.TransactionIdentifier", string);
            hashMap.put("fl.Quantity", string2);
            hashMap.put("fl.StoreId", "2");
        }
        return hashMap;
    }

    public static void getDetailsParams(@NonNull List<Object> object, @NonNull String string, @NonNull Map<String, String> map) {
        if (!BillingManager.a()) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (!(object2 instanceof ProductDetails) || !string.equals((object2 = (ProductDetails)object2).getProductId())) continue;
            Iterator iterator = object2.getProductType();
            map.put("fl.ProductName", object2.getTitle());
            map.put("fl.ProductType", (String)((Object)iterator));
            if ("inapp".equals(iterator)) {
                if ((object2 = object2.getOneTimePurchaseOfferDetails()) == null) continue;
                map.put("fl.Price", String.format(Locale.ENGLISH, REVENUE_PRICE_FORMAT, (double)object2.getPriceAmountMicros() / 1000000.0));
                map.put("fl.Currency", object2.getPriceCurrencyCode());
                continue;
            }
            if (!"subs".equals(iterator) || (object2 = object2.getSubscriptionOfferDetails()) == null) continue;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                iterator = ((ProductDetails.SubscriptionOfferDetails)object2.next()).getPricingPhases().getPricingPhaseList().iterator();
                if (!iterator.hasNext()) continue;
                object = (ProductDetails.PricingPhase)iterator.next();
                map.put("fl.Price", String.format(Locale.ENGLISH, REVENUE_PRICE_FORMAT, (double)object.getPriceAmountMicros() / 1000000.0));
                map.put("fl.Currency", object.getPriceCurrencyCode());
                return;
            }
        }
    }

    public void getProductDetails(Set<String> set, ProductsDetailsCallback productsDetailsCallback) {
        if (!BillingManager.a()) {
            return;
        }
        this.a("inapp", set, productsDetailsCallback);
        this.a("subs", set, productsDetailsCallback);
    }

    public class FlurryBillingClientStateListener
    implements BillingClientStateListener {
        BillingClientConnection a;

        public FlurryBillingClientStateListener(BillingClientConnection billingClientConnection) {
            this.a = billingClientConnection;
        }

        public void onBillingServiceDisconnected() {
            cx.a("BillingManager", "onBillingServiceDisconnected");
            BillingManager.this.d = false;
        }

        public void onBillingSetupFinished(@NonNull BillingResult object) {
            int n2 = object.getResponseCode();
            object = object.getDebugMessage();
            cx.a("BillingManager", "onBillingSetupFinished: " + n2 + " " + (String)object);
            if (n2 == 0) {
                BillingManager.this.d = true;
                this.a.onConnected();
            }
        }
    }

    public static @interface BillingResponseCode {
        public static final int OK = 0;
    }
}

