/*
 * Decompiled with CFR 0.152.
 */
package com.flowerfat.utiltool.Utils;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class PictureUtil {
    public static String bitmapToString(String filePath) {
        Bitmap bm = PictureUtil.getSmallBitmap(filePath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 40, (OutputStream)baos);
        byte[] b = baos.toByteArray();
        return Base64.encodeToString((byte[])b, (int)0);
    }

    public static Bitmap getSmallBitmap(String filePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = PictureUtil.calculateInSampleSize(options, 720, 1080);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    public static Bitmap compress(String imgPath) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int width = newOpts.outWidth;
        int height = newOpts.outHeight;
        float maxSize = 1000.0f;
        int be = 1;
        if (width > height && (float)width > maxSize) {
            be = (int)((float)newOpts.outWidth / maxSize);
        } else if (width < height && (float)height > maxSize) {
            be = (int)((float)newOpts.outHeight / maxSize);
        }
        newOpts.inSampleSize = ++be;
        newOpts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        newOpts.inPurgeable = true;
        newOpts.inInputShareable = true;
        bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)newOpts);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)baos);
        bitmap.recycle();
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        return BitmapFactory.decodeStream((InputStream)isBm, null, null);
    }

    public static void galleryAddPic(Context context, String path) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File f = new File(path);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    public static File getAlbumDir() {
        File dir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), PictureUtil.getAlbumName());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String getAlbumName() {
        return "sheguantong";
    }
}

