/*
 * Decompiled with CFR 0.152.
 */
package com.flowerfat.utiltool.Utils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.flowerfat.utiltool.others.AlarmReceiver;
import java.util.Calendar;

public class AlarmUtil {
    private static final int REQUEST_CODE = 123;
    private static final int INTERVAL = 86400000;
    private Context mContext;

    public AlarmUtil(Context context) {
        this.mContext = context;
    }

    public void OnceSecond(int second) {
        this.OnceSecond(second, 123);
    }

    public void OnceSecond(int second, int requestCode) {
        this.setAlarm(this.offSecond(second), this.getPendingIntent(requestCode));
    }

    private Calendar offSecond(int _second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(13, _second);
        return calendar;
    }

    private PendingIntent getPendingIntent() {
        return this.getPendingIntent(123);
    }

    private PendingIntent getPendingIntent(int requestCode) {
        Intent intent = new Intent(this.mContext, AlarmReceiver.class);
        return PendingIntent.getBroadcast((Context)this.mContext, (int)requestCode, (Intent)intent, (int)0);
    }

    private void setAlarm(Calendar calendar, PendingIntent sender) {
        AlarmManager am = (AlarmManager)this.mContext.getSystemService("alarm");
        am.set(0, calendar.getTimeInMillis(), sender);
    }

    private void repeatAlarm(Calendar calendar, PendingIntent sender, long intervalMillis) {
        AlarmManager am = (AlarmManager)this.mContext.getSystemService("alarm");
        am.setRepeating(0, calendar.getTimeInMillis(), intervalMillis, sender);
    }

    public void Cancel() {
        this.Cancel(123);
    }

    public void Cancel(int requestCode) {
        this.getPendingIntent(requestCode).cancel();
    }

    public void release() {
        this.mContext = null;
    }
}

