/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

enum Operation {
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move");

    private static final Map<String, Operation> OPS;
    private String rfcName;

    private Operation(String rfcName) {
        this.rfcName = rfcName;
    }

    public static Operation fromRfcName(String rfcName) throws InvalidJsonPatchException {
        if (rfcName == null) {
            throw new InvalidJsonPatchException("rfcName cannot be null");
        }
        Operation op = OPS.get(rfcName.toLowerCase());
        if (op == null) {
            throw new InvalidJsonPatchException("unknown / unsupported operation " + rfcName);
        }
        return op;
    }

    public String rfcName() {
        return this.rfcName;
    }

    static {
        OPS = ImmutableMap.of((Object)Operation.ADD.rfcName, (Object)((Object)ADD), (Object)Operation.REMOVE.rfcName, (Object)((Object)REMOVE), (Object)Operation.REPLACE.rfcName, (Object)((Object)REPLACE), (Object)Operation.MOVE.rfcName, (Object)((Object)MOVE));
    }
}

