/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.interceptor;

import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.spi.interceptor.ResponseInterceptor;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.util.List;

public abstract class AbstractClientResponseInterceptor<S>
implements ResponseInterceptor<S> {
    private static final String FAILURE_ANNOTATION = "failure";
    private static final String RESPONSE_CODE_ANNOTATION = "responsecode";
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;
    private List<TraceFilter> traceFilters;

    @Override
    public void process(S response, Optional<RuntimeException> transportError) {
        ClientTracer clientTracer = Brave.getClientTracer((SpanCollector)this.eventDispatchingSpanCollector, this.traceFilters);
        if (transportError.isPresent()) {
            clientTracer.submitAnnotation(FAILURE_ANNOTATION);
        } else {
            Optional<Integer> statusCode = this.getResponseStatusCode(response);
            if (statusCode.isPresent()) {
                clientTracer.submitBinaryAnnotation(RESPONSE_CODE_ANNOTATION, ((Integer)statusCode.get()).intValue());
            }
            if (!this.isResponseSuccess(response)) {
                clientTracer.submitAnnotation(FAILURE_ANNOTATION);
            }
        }
        clientTracer.setClientReceived();
    }

    protected abstract boolean isResponseSuccess(S var1);

    protected abstract Optional<Integer> getResponseStatusCode(S var1);

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }

    public void setTraceFilters(List<TraceFilter> traceFilters) {
        this.traceFilters = traceFilters;
    }
}

