/*
 * Decompiled with CFR 0.152.
 */
package com.fleksy.swipedetector.tool;

import android.graphics.Rect;
import android.graphics.RectF;
import com.fleksy.swipedetector.model.Direction;
import com.fleksy.swipedetector.model.FPoint;
import java.util.List;

public final class Calculator {
    public static float calcStandardDeviation(List<Double> numbers) {
        double sum = 0.0;
        int ignore = 0;
        for (double num : numbers) {
            if (num > 0.0) {
                sum += num;
                continue;
            }
            ++ignore;
        }
        double average = Calculator.calcAverage(sum, numbers.size() - ignore);
        sum = 0.0;
        for (double num : numbers) {
            if (!(num >= 0.0)) continue;
            sum += Math.pow(num - average, 2.0);
        }
        return (float)Math.sqrt(sum / (double)(numbers.size() - ignore));
    }

    public static double calcQuadraticEquation(double a, double b, double c, boolean negative) {
        double root = Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c);
        root = negative ? -root : root;
        double top = -b + root;
        return top / (2.0 * a);
    }

    public static float calcDeltaVelocity(List<Double> numbers) {
        float deltaV = 0.0f;
        for (int i = 0; i < numbers.size() - 1; ++i) {
            deltaV = (float)((double)deltaV + (numbers.get(i + 1) - numbers.get(i)));
        }
        return deltaV;
    }

    public static float calcTotal(List<Double> nums) {
        float total = 0.0f;
        for (int i = 0; i < nums.size(); ++i) {
            total = (float)((double)total + nums.get(i));
        }
        return total;
    }

    public static double calcPointLength(FPoint a, FPoint b) {
        double ln = 0.0;
        float dX = Calculator.calcDeltaF(b.getX(), a.getX());
        float dY = Calculator.calcDeltaF(b.getY(), a.getY());
        ln = Calculator.calcLength(dX, dY);
        return ln;
    }

    public static double getDeltaRad(double c, double p) {
        double d = Calculator.calcDeltaD(c, p);
        return Calculator.deltaRadians(d);
    }

    public static double calcAverage(double total, int count) {
        return total / (double)count;
    }

    public static float calcDeltaF(float a, float b) {
        return a - b;
    }

    public static double calcDeltaD(double a, double b) {
        return a - b;
    }

    public static long calcDeltaL(long a, long b) {
        return a - b;
    }

    public static double calcLength(float deltaX, float deltaY) {
        return Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
    }

    public static double findRads(float x, float y) {
        return Math.atan2(y, x);
    }

    public static double deltaRadians(double r) {
        return Math.abs(Math.atan2(Math.sin(r), Math.cos(r)));
    }

    public static float getDeltaVelocity(List<Double> nums, float ghostSpeedRatio) {
        float d = 0.0f;
        nums.add(0, nums.get(0) * (double)ghostSpeedRatio);
        d = Calculator.calcDeltaVelocity(nums);
        return d;
    }

    public static boolean contains(int x, int y, Rect ... bounds) {
        if (bounds == null) {
            return false;
        }
        for (Rect area : bounds) {
            if (area.left > x || area.top > y || area.right < x || area.bottom < y) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(float x, float y, RectF ... bounds) {
        if (bounds == null) {
            return false;
        }
        for (RectF area : bounds) {
            if (!(area.left <= x) || !(area.top <= y) || !(area.right >= x) || !(area.bottom >= y)) continue;
            return true;
        }
        return false;
    }

    public static Direction getDirection(float deltaX, float deltaY, boolean invertHorizontal) {
        if (Math.abs(deltaX) + Math.abs(deltaY) == 0.0f) {
            return Direction.TAP;
        }
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            if (invertHorizontal) {
                return deltaX < 0.0f ? Direction.LEFT : Direction.RIGHT;
            }
            return deltaX < 0.0f ? Direction.RIGHT : Direction.LEFT;
        }
        return deltaY < 0.0f ? Direction.DOWN : Direction.UP;
    }

    public static FPoint findFurthestPoint(FPoint start, FPoint end, List<FPoint> points) {
        double max = 0.0;
        for (FPoint p : points) {
            double ln = Calculator.calcPointLength(start, p);
            if (!(ln > max)) continue;
            max = ln;
            end = p;
        }
        return end;
    }
}

