/*
 * Decompiled with CFR 0.152.
 */
package com.fleksy.swipedetector;

import android.util.Log;
import com.fleksy.swipedetector.SwipeDetector;
import com.fleksy.swipedetector.model.Direction;
import com.fleksy.swipedetector.model.FPoint;
import com.fleksy.swipedetector.model.Gesture;
import com.fleksy.swipedetector.tool.Calculator;
import java.util.ArrayList;
import java.util.List;

abstract class TouchRefinery
extends SwipeDetector {
    private final Gesture[] touches = new Gesture[10];
    private final int MAX_FINGERS = 10;
    private Object doubleTapObj;
    private long prevTime = 0L;
    private boolean isTapping = false;

    public TouchRefinery(float pixelSize) {
        super(pixelSize);
    }

    protected float getMinimumLengthForDirection(Direction direction) {
        return this.getHeight() / 12.0f;
    }

    protected final void clearTouches() {
        for (int i = 0; i < this.touches.length; ++i) {
            this.touches[i] = null;
        }
    }

    protected final boolean ignoreEvent(int index) {
        return this.isOutOfBounds(index) || this.touches[index] == null;
    }

    private boolean isOutOfBounds(int index) {
        return index < 0 || index >= 10;
    }

    protected final Gesture getLatestTouch() {
        for (int i = 9; i >= 0; --i) {
            if (this.touches[i] == null) continue;
            return this.touches[i];
        }
        return null;
    }

    public final Gesture getTouchAt(int index) {
        if (this.isOutOfBounds(index)) {
            return null;
        }
        return this.touches[index];
    }

    protected final void setTouchAt(int index, Gesture touch) {
        if (this.isOutOfBounds(index)) {
            return;
        }
        this.touches[index] = touch;
    }

    protected final Object getDoubleTapObj() {
        return this.doubleTapObj;
    }

    protected final void setDoubleTapObj(Object obj) {
        this.doubleTapObj = obj;
    }

    protected final Gesture[] getTouches() {
        return this.touches;
    }

    protected final List<Gesture> refinery(Gesture touch, float swipeFactor, boolean invertHorizontal) {
        if (touch.refined()) {
            return this.refineTouch(touch, false);
        }
        Direction direction = Calculator.getDirection(touch.getDeltaX(), touch.getDeltaY(), invertHorizontal);
        touch.setIgnore(this.timeCheck(touch));
        if (this.debugging()) {
            Log.w((String)this.getClass().getSimpleName(), (String)("Swipe Factor : " + swipeFactor));
        }
        if (this.tapChecker(touch, direction, touch.getLength(), swipeFactor)) {
            touch.setDirection(Direction.TAP);
            this.isTapping = true;
            return this.refineTouch(touch, this.onCheckedTap(touch));
        }
        if ((touch = this.check(touch)).isPhantom()) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)("PHANTOM SWIPE " + this.getRawOutput()));
            }
            return this.refineTouch(touch, this.onPhantomSwipe(touch) && !this.isTap(touch.getLength(), direction, 1.0f));
        }
        touch.setDirection(direction);
        if (this.debugging()) {
            Log.w((String)this.getClass().getSimpleName(), (String)("GOOD SWIPE " + this.getRawOutput()));
        }
        this.isTapping = this.onDetectedSwipe(touch);
        touch.refine();
        ArrayList<Gesture> swipe = new ArrayList<Gesture>();
        swipe.add(touch);
        return swipe;
    }

    private boolean timeCheck(Gesture touch) {
        boolean isTap = touch.getPressTime() - this.prevTime < (long)this.getTimeLimit(touch);
        this.prevTime = touch.getReleaseTime();
        return isTap && this.isTapping;
    }

    protected boolean tapChecker(Gesture touch, Direction direction, double length, float multiple) {
        return this.isTap(length, direction, multiple) || direction == Direction.UNDEFINED || this.ignoreSwipe(touch, direction);
    }

    private boolean isTap(double length, Direction action, float multiplier) {
        return action == Direction.UNDEFINED || length <= (double)(this.getMinimumLengthForDirection(action) * multiplier);
    }

    private List<Gesture> refineTouch(Gesture old, boolean phantom) {
        ArrayList<Gesture> freed = new ArrayList<Gesture>();
        Gesture parent = old.leaveParent();
        FPoint start = old.getFirstPoint();
        freed.add(this.makeTap(start, old, parent, phantom));
        if (phantom) {
            FPoint end = Calculator.findFurthestPoint(start, old.getLastPoint(), old.getPoints());
            freed.add(this.makeTap(end, old, parent, true));
        }
        this.decideChildrensFate(parent, old, freed);
        return freed;
    }

    private Gesture makeTap(FPoint origin, Gesture old, Gesture parent, boolean phantom) {
        Gesture touch = new Gesture(old.getTag(), old.getId(), origin.getX(), origin.getY(), origin.getTime(), parent);
        touch.setDirection(Direction.TAP);
        touch.refine();
        touch.setPhantom(phantom);
        touch.setHold(old.isHeld());
        return touch;
    }

    private void decideChildrensFate(Gesture parent, Gesture old, List<Gesture> refined) {
        if (parent != null) {
            parent.adoptChildrenFrom(old);
        } else {
            for (Gesture orphan : old.abandonChildren()) {
                refined.add(orphan);
            }
        }
    }

    protected abstract int getTimeLimit(Gesture var1);

    protected abstract boolean ignoreSwipe(Gesture var1, Direction var2);

    protected abstract boolean onCheckedTap(Gesture var1);

    protected abstract boolean onPhantomSwipe(Gesture var1);

    protected abstract boolean onDetectedSwipe(Gesture var1);

    protected abstract float getMinSwipeLength();
}

