/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.LinuxLibC;
import com.fizzed.jne.OperatingSystem;
import com.fizzed.jne.PlatformInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Options {
    public static final String SYSPROP_DEBUG = "jne.debug";
    public static final String SYSPROP_RESOURCE_PREFIX = "jne.resource.prefix";
    public static final String SYSPROP_EXTRACT_DIR = "jne.extract.dir";
    public static final String SYSPROP_CLEANUP_EXTRACTED = "jne.cleanup.extracted";
    public static final String SYSPROP_X32_EXE_FALLBACK = "jne.x32.exe.fallback";
    private HardwareArchitecture hardwareArchitecture;
    private OperatingSystem operatingSystem = PlatformInfo.detectOperatingSystem();
    private LinuxLibC linuxLibC;
    private String resourcePrefix;
    private File extractDir;
    private boolean x32ExecutableFallback;
    private boolean cleanupExtracted;

    public Options() {
        this.hardwareArchitecture = PlatformInfo.detectHardwareArchitecture();
        this.linuxLibC = PlatformInfo.detectLinuxLibC();
        this.resourcePrefix = System.getProperty(SYSPROP_RESOURCE_PREFIX, "/jne");
        this.extractDir = Options.getSystemPropertyAsFile(SYSPROP_EXTRACT_DIR, null);
        this.x32ExecutableFallback = Options.getSystemPropertyAsBoolean(SYSPROP_X32_EXE_FALLBACK, true);
        this.cleanupExtracted = Options.getSystemPropertyAsBoolean(SYSPROP_CLEANUP_EXTRACTED, true);
    }

    public HardwareArchitecture getHardwareArchitecture() {
        return this.hardwareArchitecture;
    }

    public Options setHardwareArchitecture(HardwareArchitecture hardwareArchitecture) {
        this.hardwareArchitecture = hardwareArchitecture;
        return this;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Options setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public LinuxLibC getLinuxLibC() {
        return this.linuxLibC;
    }

    public Options setLinuxLibC(LinuxLibC linuxLibC) {
        this.linuxLibC = linuxLibC;
        return this;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public Options setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        return this;
    }

    public File getExtractDir() {
        return this.extractDir;
    }

    public Options setExtractDir(File extractDir) {
        this.extractDir = extractDir;
        return this;
    }

    public boolean isX32ExecutableFallback() {
        return this.x32ExecutableFallback;
    }

    public Options setX32ExecutableFallback(boolean x32ExecutableFallback) {
        this.x32ExecutableFallback = x32ExecutableFallback;
        return this;
    }

    public boolean isCleanupExtracted() {
        return this.cleanupExtracted;
    }

    public Options setCleanupExtracted(boolean cleanupExtracted) {
        this.cleanupExtracted = cleanupExtracted;
        return this;
    }

    public String createExecutableName(String name, OperatingSystem os) {
        if (os == OperatingSystem.WINDOWS) {
            return name + ".exe";
        }
        return name;
    }

    public String createLibraryName(String name, OperatingSystem os, Integer majorVersion, Integer minorVersion, Integer revisionVersion) {
        switch (os) {
            case WINDOWS: {
                return name + ".dll";
            }
            case LINUX: 
            case FREEBSD: 
            case OPENBSD: 
            case SOLARIS: {
                String soname = "lib" + name + ".so";
                if (majorVersion != null) {
                    soname = soname + "." + majorVersion;
                    if (minorVersion != null) {
                        soname = soname + "." + minorVersion;
                        if (revisionVersion != null) {
                            soname = soname + "." + revisionVersion;
                        }
                    }
                }
                return soname;
            }
            case MACOS: {
                return "lib" + name + ".dylib";
            }
        }
        return name;
    }

    public List<String> createResourcePaths(OperatingSystem os, HardwareArchitecture arch, LinuxLibC linuxLibC, String name) {
        ArrayList<String> osList = new ArrayList<String>();
        if (os != null && os != OperatingSystem.ANY) {
            String osExtendedName = linuxLibC == LinuxLibC.MUSL ? "_" + linuxLibC.name().toLowerCase() : "";
            osList.add(os.name().toLowerCase() + osExtendedName);
            if (os.getAliases() != null) {
                for (String alias : os.getAliases()) {
                    osList.add(alias + osExtendedName);
                }
            }
        } else {
            osList.add(null);
        }
        ArrayList<String> archList = new ArrayList<String>();
        if (arch != null && arch != HardwareArchitecture.ANY) {
            archList.add(arch.name().toLowerCase());
            if (arch.getAliases() != null) {
                Collections.addAll(archList, arch.getAliases());
            }
        } else {
            archList.add(null);
        }
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (String _os : osList) {
            for (String _arch : archList) {
                StringBuilder s = new StringBuilder();
                s.append(this.getResourcePrefix());
                s.append("/");
                if (_os != null) {
                    s.append(_os);
                    s.append("/");
                    if (_arch != null) {
                        s.append(_arch);
                        s.append("/");
                    }
                }
                s.append(name);
                resourcePaths.add(s.toString());
            }
        }
        return resourcePaths;
    }

    private static File getSystemPropertyAsFile(String key, File defaultValue) {
        String v = System.getProperty(key);
        if (v != null && !v.equals("")) {
            return new File(v);
        }
        return defaultValue;
    }

    private static boolean getSystemPropertyAsBoolean(String key, boolean defaultValue) {
        String v = System.getProperty(key);
        if (v != null) {
            if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("1")) {
                return true;
            }
            if (v.equalsIgnoreCase("false") || v.equalsIgnoreCase("0")) {
                return false;
            }
            throw new IllegalArgumentException("Invalid boolean value for system property [" + key + "]");
        }
        return defaultValue;
    }
}

