/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.google;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.firebase.client.Firebase;
import com.firebase.ui.auth.core.AuthProviderType;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseOAuthToken;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.TokenAuthHandler;
import com.firebase.ui.auth.google.GoogleActions;
import com.firebase.ui.auth.google.GoogleOAuthTask;
import com.firebase.ui.auth.google.GoogleOAuthTaskHandler;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public class GoogleAuthProvider
extends FirebaseAuthProvider
implements GoogleApiClient.OnConnectionFailedListener,
GoogleApiClient.ConnectionCallbacks,
GoogleOAuthTaskHandler {
    private final String TAG = "GoogleAuthProvider";
    private GoogleApiClient mGoogleApiClient;
    private Integer onConnectedAction = 0;

    public GoogleAuthProvider(Context context, AuthProviderType providerType, String providerName, Firebase ref, TokenAuthHandler handler) {
        super(context, providerType, providerName, ref, handler);
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().build();
        this.mGoogleApiClient = new GoogleApiClient.Builder(this.getContext()).enableAutoManage((FragmentActivity)this.getContext(), (GoogleApiClient.OnConnectionFailedListener)this).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)gso).build();
        this.mGoogleApiClient.connect();
    }

    public void onConnected(Bundle bundle) {
        if (this.onConnectedAction == GoogleActions.SIGN_IN) {
            this.login();
        } else if (this.onConnectedAction == GoogleActions.SIGN_OUT) {
            this.logout();
        }
        this.onConnectedAction = 0;
    }

    public void onConnectionSuspended(int i) {
    }

    @Override
    public void logout() {
        if (this.mGoogleApiClient.isConnected()) {
            Auth.GoogleSignInApi.signOut(this.mGoogleApiClient).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(Status status) {
                    GoogleAuthProvider.this.revokeAccess();
                }
            });
        } else {
            this.onConnectedAction = GoogleActions.SIGN_OUT;
        }
    }

    @Override
    public void login() {
        if (this.mGoogleApiClient.isConnected()) {
            Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(this.mGoogleApiClient);
            ((Activity)this.getContext()).startActivityForResult(signInIntent, GoogleActions.SIGN_IN);
        } else {
            this.onConnectedAction = GoogleActions.SIGN_IN;
            if (!this.mGoogleApiClient.isConnecting()) {
                this.mGoogleApiClient.connect();
            }
        }
    }

    private void revokeAccess() {
        Auth.GoogleSignInApi.revokeAccess(this.mGoogleApiClient).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(Status status) {
            }
        });
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == GoogleActions.SIGN_IN && resultCode == -1) {
            GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
            this.handleSignInResult(result);
        }
        if (requestCode == GoogleActions.SIGN_IN && resultCode == 0) {
            Log.d((String)"GoogleAuthProvider", (String)data.getExtras().keySet().toString());
            this.getHandler().onUserError(new FirebaseLoginError(FirebaseResponse.LOGIN_CANCELLED, "User closed login dialog."));
        }
    }

    private void handleSignInResult(GoogleSignInResult result) {
        if (result.isSuccess()) {
            GoogleSignInAccount acct = result.getSignInAccount();
            GoogleOAuthTask googleOAuthTask = new GoogleOAuthTask();
            googleOAuthTask.setContext(this.getContext());
            googleOAuthTask.setHandler(this);
            googleOAuthTask.execute(new String[]{acct.getEmail()});
        } else {
            this.getHandler().onProviderError(new FirebaseLoginError(FirebaseResponse.MISC_PROVIDER_ERROR, result.getStatus().toString()));
        }
    }

    @Override
    public void onOAuthSuccess(String OAuthToken) {
        FirebaseOAuthToken token = new FirebaseOAuthToken(this.getProviderName(), OAuthToken);
        this.onFirebaseTokenReceived(token, this.getHandler());
    }

    @Override
    public void onOAuthFailure(FirebaseLoginError firebaseError) {
        this.getHandler().onProviderError(firebaseError);
    }

    public void cleanUp() {
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.disconnect();
            this.mGoogleApiClient.stopAutoManage((FragmentActivity)this.getContext());
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        FirebaseLoginError error = new FirebaseLoginError(FirebaseResponse.MISC_PROVIDER_ERROR, connectionResult.toString());
        this.getHandler().onProviderError(error);
    }
}

