/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.core;

import android.content.Context;
import com.firebase.client.Firebase;
import com.firebase.ui.R;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;
import java.lang.reflect.InvocationTargetException;

public enum AuthProviderType {
    GOOGLE("google", "google.GoogleAuthProvider", R.id.google_button),
    FACEBOOK("facebook", "facebook.FacebookAuthProvider", R.id.facebook_button),
    TWITTER("twitter", "twitter.TwitterAuthProvider", R.id.twitter_button),
    PASSWORD("password", "password.PasswordAuthProvider", R.id.password_button);

    private static final String AUTH_PACKAGE = "com.firebase.ui.auth.";
    private final String mName;
    private final String mProviderName;
    private final int mButtonId;

    private AuthProviderType(String name, String providerName, int button_id) {
        this.mName = name;
        this.mProviderName = providerName;
        this.mButtonId = button_id;
    }

    public String getName() {
        return this.mName;
    }

    public int getButtonId() {
        return this.mButtonId;
    }

    public FirebaseAuthProvider createProvider(Context context, Firebase ref, TokenAuthHandler handler) {
        try {
            Class<?> clazz = Class.forName(AUTH_PACKAGE + this.mProviderName);
            return (FirebaseAuthProvider)clazz.getConstructor(Context.class, AuthProviderType.class, String.class, Firebase.class, TokenAuthHandler.class).newInstance(new Object[]{context, this, this.getName(), ref, handler});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static AuthProviderType getTypeForProvider(FirebaseAuthProvider provider) {
        for (AuthProviderType type : AuthProviderType.values()) {
            if (provider.getProviderName() != type.getName()) continue;
            return type;
        }
        throw new IllegalArgumentException("The provider you specified is not of a known type");
    }
}

