/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.core;

import android.content.Context;
import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.ui.auth.core.FirebaseLoginDialog;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;

public abstract class FirebaseLoginBaseActivity
extends AppCompatActivity {
    private final String TAG = "FirebaseLoginBaseAct";
    private Firebase.AuthStateListener mAuthStateListener;
    private FirebaseLoginDialog mDialog;
    private TokenAuthHandler mHandler;

    protected abstract void onFirebaseLoggedIn(AuthData var1);

    protected abstract void onFirebaseLoggedOut();

    protected abstract void onFirebaseLoginProviderError(FirebaseLoginError var1);

    protected abstract void onFirebaseLoginUserError(FirebaseLoginError var1);

    protected abstract Firebase getFirebaseRef();

    public void logout() {
        this.mDialog.logout();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mDialog.onActivityResult(requestCode, resultCode, data);
    }

    public void showFirebaseLoginPrompt() {
        this.mDialog.show(this.getFragmentManager(), "");
    }

    public void dismissFirebaseLoginPrompt() {
        this.mDialog.dismiss();
    }

    public void resetFirebaseLoginDialog() {
        this.mDialog.reset();
    }

    public void setEnabledAuthProvider(SocialProvider provider) {
        this.mDialog.setEnabledProvider(provider);
    }

    protected void onStart() {
        super.onStart();
        this.mHandler = new TokenAuthHandler(){

            @Override
            public void onSuccess(AuthData data) {
            }

            @Override
            public void onUserError(FirebaseLoginError err) {
                FirebaseLoginBaseActivity.this.onFirebaseLoginUserError(err);
            }

            @Override
            public void onProviderError(FirebaseLoginError err) {
                FirebaseLoginBaseActivity.this.onFirebaseLoginProviderError(err);
            }
        };
        this.mAuthStateListener = new Firebase.AuthStateListener(){

            public void onAuthStateChanged(AuthData authData) {
                if (authData != null) {
                    FirebaseLoginBaseActivity.this.onFirebaseLoggedIn(authData);
                } else {
                    FirebaseLoginBaseActivity.this.onFirebaseLoggedOut();
                }
            }
        };
        this.mDialog = new FirebaseLoginDialog();
        this.mDialog.setContext((Context)this).setRef(this.getFirebaseRef()).setHandler(this.mHandler);
        this.getFirebaseRef().addAuthStateListener(this.mAuthStateListener);
    }

    protected void onStop() {
        super.onStop();
        this.getFirebaseRef().removeAuthStateListener(this.mAuthStateListener);
        this.mDialog.cleanUp();
    }

    protected void onPause() {
        super.onPause();
        this.mDialog.cleanUp();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mDialog.cleanUp();
    }
}

