/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.core;

import android.util.Log;
import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseOAuthToken;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;
import java.util.HashMap;

public abstract class FirebaseAuthProvider {
    public abstract void logout();

    public abstract String getProviderName();

    public abstract Firebase getFirebaseRef();

    public abstract SocialProvider getProviderType();

    public void login() {
        Log.d((String)"FirebaseAuthProvider", (String)("Login() is not supported for provider type " + this.getProviderName()));
    }

    public void login(String email, String password) {
        Log.d((String)"FirebaseAuthProvider", (String)("Login(String email, String password) is not supported for provider type " + this.getProviderName()));
    }

    public void onFirebaseTokenReceived(FirebaseOAuthToken token, TokenAuthHandler handler) {
        this.authenticateRefWithOAuthFirebasetoken(token, handler);
    }

    private void authenticateRefWithOAuthFirebasetoken(FirebaseOAuthToken token, final TokenAuthHandler handler) {
        Firebase.AuthResultHandler authResultHandler = new Firebase.AuthResultHandler(){

            public void onAuthenticated(AuthData authData) {
                handler.onSuccess(authData);
            }

            public void onAuthenticationError(FirebaseError firebaseError) {
                handler.onProviderError(new FirebaseLoginError(FirebaseResponse.PROVIDER_NOT_ENABLED, "Make sure " + FirebaseAuthProvider.this.getProviderName() + " login is enabled and configured in your Firebase."));
            }
        };
        if (token.mode == 1) {
            this.getFirebaseRef().authWithOAuthToken(token.provider, token.token, authResultHandler);
        } else if (token.mode == 2) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("oauth_token", token.token);
            options.put("oauth_token_secret", token.secret);
            options.put("user_id", token.uid);
            this.getFirebaseRef().authWithOAuthToken(token.provider, options, authResultHandler);
        }
    }
}

