/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard_networking;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.util.Log;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.fintecsystems.xs2awizard_networking.ContextExtensionsKt;
import com.fintecsystems.xs2awizard_networking.NetworkingInstance;
import com.fintecsystems.xs2awizard_networking.R;
import com.fintecsystems.xs2awizard_networking.SingletonHolder;
import com.fintecsystems.xs2awizard_networking.UrlEncodedRequest;
import com.fintecsystems.xs2awizard_networking.encryption.Encryptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u000e\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0006H\u0002J:\u0010#\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0%2\u0014\b\u0002\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001e0%J\u0006\u0010'\u001a\u00020\u001eJ\b\u0010(\u001a\u00020\u0016H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\n\u00a8\u0006*"}, d2={"Lcom/fintecsystems/xs2awizard_networking/NetworkingInstance;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "backendURL", "", "getBackendURL", "()Ljava/lang/String;", "setBackendURL", "(Ljava/lang/String;)V", "isConnected", "", "networkCallback", "com/fintecsystems/xs2awizard_networking/NetworkingInstance$networkCallback$1", "Lcom/fintecsystems/xs2awizard_networking/NetworkingInstance$networkCallback$1;", "offlineRequests", "", "Lcom/android/volley/Request;", "requestQueue", "Lcom/android/volley/RequestQueue;", "rsaEncryptor", "Lcom/fintecsystems/xs2awizard_networking/encryption/Encryptor;", "sessionKey", "getSessionKey", "setSessionKey", "constructBody", "", "message", "defaultOnError", "", "err", "Lcom/android/volley/VolleyError;", "defaultOnSuccess", "res", "encodeAndSendMessage", "onSuccess", "Lkotlin/Function1;", "onError", "finalize", "generatePublicKey", "Companion", "xs2awizard_networking_release"})
public final class NetworkingInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RequestQueue requestQueue;
    @NotNull
    private final Encryptor rsaEncryptor;
    private boolean isConnected;
    @NotNull
    private List<Request<?>> offlineRequests;
    @NotNull
    private final networkCallback.1 networkCallback;
    @Nullable
    private String backendURL;
    @Nullable
    private String sessionKey;

    private NetworkingInstance(Context context) {
        this.context = context;
        RequestQueue requestQueue = Volley.newRequestQueue((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue, (String)"newRequestQueue(context)");
        this.requestQueue = requestQueue;
        this.rsaEncryptor = this.generatePublicKey();
        this.offlineRequests = new ArrayList();
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkingInstance this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onAvailable(@NotNull Network network) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkingInstance.access$setConnected$p(this.this$0, true);
                Iterable iterable = NetworkingInstance.access$getOfflineRequests$p(this.this$0);
                NetworkingInstance networkingInstance = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Request it = (Request)element$iv;
                    boolean bl = false;
                    NetworkingInstance.access$getRequestQueue$p(networkingInstance).add(it);
                }
                NetworkingInstance.access$getOfflineRequests$p(this.this$0).clear();
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkingInstance.access$setConnected$p(this.this$0, false);
            }
        };
        ContextExtensionsKt.registerNetworkCallback(this.context, this.networkCallback);
    }

    @Nullable
    public final String getBackendURL() {
        return this.backendURL;
    }

    public final void setBackendURL(@Nullable String string) {
        this.backendURL = string;
    }

    @Nullable
    public final String getSessionKey() {
        return this.sessionKey;
    }

    public final void setSessionKey(@Nullable String string) {
        this.sessionKey = string;
    }

    private final Encryptor generatePublicKey() {
        String string2 = this.context.getString(R.string.public_key_modulus);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.public_key_modulus)");
        String modulus = string2;
        String string3 = this.context.getString(R.string.public_key_exponent);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.public_key_exponent)");
        String exponent = string3;
        return new Encryptor(modulus, exponent);
    }

    public final void finalize() {
        ContextExtensionsKt.unregisterNetworkCallback(this.context, this.networkCallback);
    }

    public final void encodeAndSendMessage(@NotNull String message, @NotNull Function1<? super String, Unit> onSuccess, @NotNull Function1<? super VolleyError, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        String string2 = this.backendURL;
        if (string2 == null) {
            String string3 = this.context.getString(R.string.backend_url);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.backend_url)");
        }
        UrlEncodedRequest request = new UrlEncodedRequest(1, string2, this.constructBody(message), (Response.Listener<String>)((Response.Listener)arg_0 -> NetworkingInstance.encodeAndSendMessage$lambda-0(onSuccess, arg_0)), arg_0 -> NetworkingInstance.encodeAndSendMessage$lambda-1(onError, arg_0));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(180000, Integer.MAX_VALUE, 1.0f));
        if (this.isConnected) {
            this.requestQueue.add((Request)request);
        } else {
            this.offlineRequests.add((Request<?>)request);
        }
    }

    public static /* synthetic */ void encodeAndSendMessage$default(NetworkingInstance networkingInstance, String string, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = (Function1)new Function1<String, Unit>((Object)networkingInstance){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    NetworkingInstance.access$defaultOnSuccess((NetworkingInstance)this.receiver, p0);
                }
            };
        }
        if ((n & 4) != 0) {
            function12 = (Function1)new Function1<VolleyError, Unit>((Object)networkingInstance){

                public final void invoke(@NotNull VolleyError p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    NetworkingInstance.access$defaultOnError((NetworkingInstance)this.receiver, p0);
                }
            };
        }
        networkingInstance.encodeAndSendMessage(string, (Function1<? super String, Unit>)function1, (Function1<? super VolleyError, Unit>)function12);
    }

    private final Map<String, String> constructBody(String message) {
        Pair[] pairArray = new Pair[2];
        pairArray[0] = new Pair((Object)"data", (Object)this.rsaEncryptor.encodeMessage(message));
        String string2 = this.sessionKey;
        Intrinsics.checkNotNull((Object)string2);
        pairArray[1] = new Pair((Object)"key", (Object)string2);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final void defaultOnSuccess(String res) {
        Log.d((String)"NetworkingInstance", (String)("encodeAndSendMessage: Success! " + res));
    }

    private final void defaultOnError(VolleyError err) {
        Log.d((String)"NetworkingInstance", (String)("encodeAndSendMessage: Error! " + err));
    }

    private static final void encodeAndSendMessage$lambda-0(Function1 $onSuccess, String it) {
        Intrinsics.checkNotNullParameter((Object)$onSuccess, (String)"$onSuccess");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $onSuccess.invoke((Object)it);
    }

    private static final void encodeAndSendMessage$lambda-1(Function1 $onError, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)$onError, (String)"$onError");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $onError.invoke((Object)it);
    }

    public static final /* synthetic */ void access$defaultOnSuccess(NetworkingInstance $this, String res) {
        $this.defaultOnSuccess(res);
    }

    public static final /* synthetic */ void access$defaultOnError(NetworkingInstance $this, VolleyError err) {
        $this.defaultOnError(err);
    }

    public /* synthetic */ NetworkingInstance(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    public static final /* synthetic */ void access$setConnected$p(NetworkingInstance $this, boolean bl) {
        $this.isConnected = bl;
    }

    public static final /* synthetic */ List access$getOfflineRequests$p(NetworkingInstance $this) {
        return $this.offlineRequests;
    }

    public static final /* synthetic */ RequestQueue access$getRequestQueue$p(NetworkingInstance $this) {
        return $this.requestQueue;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/fintecsystems/xs2awizard_networking/NetworkingInstance$Companion;", "Lcom/fintecsystems/xs2awizard_networking/SingletonHolder;", "Lcom/fintecsystems/xs2awizard_networking/NetworkingInstance;", "Landroid/content/Context;", "()V", "xs2awizard_networking_release"})
    public static final class Companion
    extends SingletonHolder<NetworkingInstance, Context> {
        private Companion() {
            super(1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

