/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.components;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.Uri;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.biometric.BiometricPrompt;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.core.util.Consumer;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.savedstate.SavedStateRegistry;
import com.android.volley.VolleyError;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardCallbackListener;
import com.fintecsystems.xs2awizard.components.XS2AWizardError;
import com.fintecsystems.xs2awizard.components.XS2AWizardLanguage;
import com.fintecsystems.xs2awizard.components.XS2AWizardStep;
import com.fintecsystems.xs2awizard.components.XS2AWizardViewModel;
import com.fintecsystems.xs2awizard.components.networking.ConnectionState;
import com.fintecsystems.xs2awizard.form.CheckBoxLineData;
import com.fintecsystems.xs2awizard.form.CredentialFormLineData;
import com.fintecsystems.xs2awizard.form.FormLineData;
import com.fintecsystems.xs2awizard.form.FormResponse;
import com.fintecsystems.xs2awizard.form.RedirectLineData;
import com.fintecsystems.xs2awizard.form.SubmitLineData;
import com.fintecsystems.xs2awizard.form.ValueFormLineData;
import com.fintecsystems.xs2awizard.helper.Crypto;
import com.fintecsystems.xs2awizard.helper.JSONFormatter;
import com.fintecsystems.xs2awizard.helper.MarkupParser;
import com.fintecsystems.xs2awizard.helper.Utils;
import com.fintecsystems.xs2awizard_networking.ContextExtensionsKt;
import com.fintecsystems.xs2awizard_networking.NetworkingInstance;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u00015\b\u0007\u0018\u0000 v2\u00020\u0001:\u0001vB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010<\u001a\u00020=J\b\u0010>\u001a\u00020=H\u0003J\u0006\u0010?\u001a\u00020#J\r\u0010@\u001a\u00020=H\u0000\u00a2\u0006\u0002\bAJ!\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u001d2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010CH\u0000\u00a2\u0006\u0002\bFJ\u0006\u0010G\u001a\u00020=J#\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020\u00192\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001d0KH\u0000\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020=H\u0002J\u0006\u0010N\u001a\u00020#J\u0006\u0010O\u001a\u00020#J\u0012\u0010P\u001a\u00020#2\b\u0010:\u001a\u0004\u0018\u00010\u001dH\u0002J\u0017\u0010Q\u001a\u00020#2\b\u0010R\u001a\u0004\u0018\u00010\u001dH\u0000\u00a2\u0006\u0002\bSJ\u0010\u0010T\u001a\u00020=2\u0006\u0010U\u001a\u00020\u001dH\u0002JS\u0010V\u001a\u00020=2\u0006\u0010W\u001a\u00020\u001d2\b\u0010X\u001a\u0004\u0018\u00010\u001d2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\b\u0010;\u001a\u0004\u0018\u00010\u001d2\u0006\u0010I\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bYJ\r\u0010Z\u001a\u00020=H\u0000\u00a2\u0006\u0002\b[J\u0010\u0010\\\u001a\u00020=2\u0006\u0010R\u001a\u00020\u001dH\u0002J\u0015\u0010]\u001a\u00020=2\u0006\u0010R\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b^J\u0010\u0010_\u001a\u00020=2\u0006\u0010R\u001a\u00020\u001dH\u0002J\u0010\u0010`\u001a\u00020=2\u0006\u0010a\u001a\u00020bH\u0002J\u0015\u0010c\u001a\u00020=2\u0006\u0010d\u001a\u00020#H\u0000\u00a2\u0006\u0002\beJ\u0006\u0010f\u001a\u00020=J\b\u0010g\u001a\u00020#H\u0002J\u0016\u0010h\u001a\u00020=2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0003J\u0010\u0010i\u001a\u00020=2\u0006\u0010:\u001a\u00020\u001dH\u0002J\r\u0010j\u001a\u00020=H\u0000\u00a2\u0006\u0002\bkJ\u0015\u0010j\u001a\u00020=2\u0006\u0010D\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bkJ\u0018\u0010j\u001a\u00020=2\u0006\u0010l\u001a\u00020\u001d2\u0006\u0010m\u001a\u00020#H\u0002J\u001f\u0010j\u001a\u00020=2\u0006\u0010l\u001a\u00020n2\b\b\u0002\u0010m\u001a\u00020#H\u0000\u00a2\u0006\u0002\bkJ)\u0010o\u001a\u00020=2\u0006\u0010D\u001a\u00020\u001d2\u0012\u0010p\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020=0qH\u0000\u00a2\u0006\u0002\brJ\b\u0010s\u001a\u00020=H\u0003J\b\u0010t\u001a\u00020=H\u0003J\u0010\u0010u\u001a\u00020#2\u0006\u0010R\u001a\u00020\u001dH\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\"\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010-0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0012R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00102\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010#0#0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0012R\u0010\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Landroid/app/Application;Landroidx/lifecycle/SavedStateHandle;)V", "callbackListener", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;", "getCallbackListener", "()Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;", "setCallbackListener", "(Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;)V", "connectionState", "Landroidx/lifecycle/MutableLiveData;", "Lcom/fintecsystems/xs2awizard/components/networking/ConnectionState;", "kotlin.jvm.PlatformType", "getConnectionState$xs2awizard_release", "()Landroidx/lifecycle/MutableLiveData;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "currentBiometricPromp", "Landroidx/biometric/BiometricPrompt;", "currentState", "", "currentStep", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardStep;", "currentWebViewUrl", "getCurrentWebViewUrl$xs2awizard_release", "enableAutomaticRetry", "", "enableBackButton", "getEnableBackButton$xs2awizard_release", "()Z", "setEnableBackButton$xs2awizard_release", "(Z)V", "enableScroll", "getEnableScroll$xs2awizard_release", "setEnableScroll$xs2awizard_release", "form", "", "Lcom/fintecsystems/xs2awizard/form/FormLineData;", "getForm$xs2awizard_release", "language", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardLanguage;", "loadingIndicatorLock", "getLoadingIndicatorLock$xs2awizard_release", "networkCallback", "com/fintecsystems/xs2awizard/components/XS2AWizardViewModel$networkCallback$1", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$networkCallback$1;", "onNewIntentListener", "Landroidx/core/util/Consumer;", "Landroid/content/Intent;", "provider", "redirectDeepLink", "abort", "", "autoFillCredentials", "backButtonIsPresent", "closeWebView", "closeWebView$xs2awizard_release", "constructJsonBody", "Lkotlinx/serialization/json/JsonObject;", "action", "values", "constructJsonBody$xs2awizard_release", "goBack", "handleAnnotationClick", "activity", "annotation", "Landroidx/compose/ui/text/AnnotatedString$Range;", "handleAnnotationClick$xs2awizard_release", "initForm", "isBankSearch", "isLogin", "isProviderInStore", "isRedirectDeepLink", "url", "isRedirectDeepLink$xs2awizard_release", "onFormReceived", "jsonString", "onStart", "sessionKey", "backendURL", "onStart$xs2awizard_release", "onStop", "onStop$xs2awizard_release", "openExternalUrl", "openRedirectURL", "openRedirectURL$xs2awizard_release", "openWebView", "parseCallback", "response", "Lcom/fintecsystems/xs2awizard/form/FormResponse;", "redirectionCallback", "success", "redirectionCallback$xs2awizard_release", "restart", "shouldAbortNetworkRequest", "storeCredentials", "storeProvider", "submitForm", "submitForm$xs2awizard_release", "jsonBody", "showIndicator", "Lkotlinx/serialization/json/JsonElement;", "submitFormWithCallback", "onSuccess", "Lkotlin/Function1;", "submitFormWithCallback$xs2awizard_release", "tryToAutoFillCredentials", "tryToStoreCredentials", "urlSupportsAppRedirection", "Companion", "xs2awizard_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nXS2AWizardViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XS2AWizardViewModel.kt\ncom/fintecsystems/xs2awizard/components/XS2AWizardViewModel\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 5 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,730:1\n27#2,4:731\n27#2,4:738\n27#2,4:742\n27#2,4:746\n27#2,3:750\n30#2:757\n27#2,4:759\n1747#3,3:735\n1855#3,2:753\n1855#3,2:755\n288#3,2:763\n1855#3,2:765\n2624#3,3:767\n1855#3,2:770\n123#4:758\n29#5:772\n*S KotlinDebug\n*F\n+ 1 XS2AWizardViewModel.kt\ncom/fintecsystems/xs2awizard/components/XS2AWizardViewModel\n*L\n190#1:731,4\n226#1:738,4\n239#1:742,4\n249#1:746,4\n262#1:750,3\n262#1:757\n404#1:759,4\n205#1:735,3\n263#1:753,2\n278#1:755,2\n470#1:763,2\n504#1:765,2\n528#1:767,3\n556#1:770,2\n391#1:758\n677#1:772\n*E\n"})
public final class XS2AWizardViewModel
extends AndroidViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private XS2AWizardCallbackListener callbackListener;
    @Nullable
    private XS2AWizardLanguage language;
    private boolean enableScroll;
    private boolean enableBackButton;
    private boolean enableAutomaticRetry;
    @Nullable
    private String redirectDeepLink;
    @NotNull
    private final MutableLiveData<List<FormLineData>> form;
    @NotNull
    private final MutableLiveData<Boolean> loadingIndicatorLock;
    @NotNull
    private final MutableLiveData<String> currentWebViewUrl;
    @NotNull
    private final MutableLiveData<ConnectionState> connectionState;
    @NotNull
    private final networkCallback.1 networkCallback;
    @Nullable
    private XS2AWizardStep currentStep;
    @Nullable
    private String provider;
    @NotNull
    private WeakReference<Activity> currentActivity;
    @Nullable
    private BiometricPrompt currentBiometricPromp;
    @Nullable
    private String currentState;
    @NotNull
    private final Consumer<Intent> onNewIntentListener;
    public static final int $stable = 8;
    @NotNull
    private static final String rememberLoginName = "store_credentials";
    @NotNull
    private static final String sharedPreferencesFileName = "xs2a_credentials";
    @NotNull
    private static final String storedProvidersKey = "providers";
    @NotNull
    private static final String masterKeyAlias = "xs2a_credentials_master_key";
    @NotNull
    private static final List<String> supportedAppRedirectionURLs;

    public XS2AWizardViewModel(@NotNull Application application, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        super(application);
        this.enableScroll = true;
        this.enableBackButton = true;
        this.enableAutomaticRetry = true;
        this.form = new MutableLiveData();
        this.loadingIndicatorLock = new MutableLiveData((Object)false);
        this.currentWebViewUrl = new MutableLiveData(null);
        this.connectionState = new MutableLiveData((Object)ConnectionState.UNKNOWN);
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                this.this$0.getConnectionState$xs2awizard_release().postValue((Object)((Object)ConnectionState.CONNECTED));
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                this.this$0.getConnectionState$xs2awizard_release().postValue((Object)((Object)ConnectionState.DISCONNECTED));
            }
        };
        this.currentActivity = new WeakReference<Object>(null);
        this.onNewIntentListener = arg_0 -> XS2AWizardViewModel.onNewIntentListener$lambda$0(this, arg_0);
        Bundle xs2aWizardBundle = (Bundle)savedStateHandle.get("xs2aWizardConfig");
        if (xs2aWizardBundle != null) {
            this.currentWebViewUrl.setValue((Object)xs2aWizardBundle.getString("currentWebViewUrl"));
        }
        savedStateHandle.setSavedStateProvider("xs2aWizardConfig", new SavedStateRegistry.SavedStateProvider(){

            @NotNull
            public final Bundle saveState() {
                Bundle bundle = new Bundle();
                XS2AWizardViewModel xS2AWizardViewModel = this;
                Bundle $this$saveState_u24lambda_u240 = bundle;
                boolean bl = false;
                $this$saveState_u24lambda_u240.putString("currentWebViewUrl", (String)xS2AWizardViewModel.getCurrentWebViewUrl$xs2awizard_release().getValue());
                return bundle;
            }
        });
    }

    @Nullable
    public final XS2AWizardCallbackListener getCallbackListener() {
        return this.callbackListener;
    }

    public final void setCallbackListener(@Nullable XS2AWizardCallbackListener xS2AWizardCallbackListener) {
        this.callbackListener = xS2AWizardCallbackListener;
    }

    public final boolean getEnableScroll$xs2awizard_release() {
        return this.enableScroll;
    }

    public final void setEnableScroll$xs2awizard_release(boolean bl) {
        this.enableScroll = bl;
    }

    public final boolean getEnableBackButton$xs2awizard_release() {
        return this.enableBackButton;
    }

    public final void setEnableBackButton$xs2awizard_release(boolean bl) {
        this.enableBackButton = bl;
    }

    @NotNull
    public final MutableLiveData<List<FormLineData>> getForm$xs2awizard_release() {
        return this.form;
    }

    @NotNull
    public final MutableLiveData<Boolean> getLoadingIndicatorLock$xs2awizard_release() {
        return this.loadingIndicatorLock;
    }

    @NotNull
    public final MutableLiveData<String> getCurrentWebViewUrl$xs2awizard_release() {
        return this.currentWebViewUrl;
    }

    @NotNull
    public final MutableLiveData<ConnectionState> getConnectionState$xs2awizard_release() {
        return this.connectionState;
    }

    private final Context getContext() {
        Context context = this.getApplication().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplication<Application>().applicationContext");
        return context;
    }

    public final void onStart$xs2awizard_release(@NotNull String sessionKey, @Nullable String backendURL, @Nullable XS2AWizardLanguage language, boolean enableScroll, boolean enableBackButton, boolean enableAutomaticRetry, @Nullable String redirectDeepLink, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.language = language;
        this.enableScroll = enableScroll;
        this.enableBackButton = enableBackButton;
        this.enableAutomaticRetry = enableAutomaticRetry;
        this.redirectDeepLink = redirectDeepLink;
        this.currentActivity = new WeakReference<Activity>(activity);
        Object object = NetworkingInstance.Companion.getInstance((Object)this.getContext());
        NetworkingInstance $this$onStart_u24lambda_u241 = (NetworkingInstance)object;
        boolean bl = false;
        $this$onStart_u24lambda_u241.setSessionKey(sessionKey);
        $this$onStart_u24lambda_u241.setBackendURL(backendURL);
        ContextExtensionsKt.registerNetworkCallback((Context)this.getContext(), (ConnectivityManager.NetworkCallback)this.networkCallback);
        ComponentActivity componentActivity = activity instanceof ComponentActivity ? (ComponentActivity)activity : null;
        if (componentActivity != null) {
            componentActivity.addOnNewIntentListener(this.onNewIntentListener);
        }
        this.initForm();
    }

    public final void onStop$xs2awizard_release() {
        this.loadingIndicatorLock.setValue((Object)false);
        this.currentWebViewUrl.setValue(null);
        this.form.setValue((Object)CollectionsKt.emptyList());
        this.language = null;
        this.currentStep = null;
        this.enableScroll = true;
        this.enableBackButton = true;
        this.enableAutomaticRetry = true;
        this.redirectDeepLink = null;
        Object t = this.currentActivity.get();
        ComponentActivity componentActivity = t instanceof ComponentActivity ? (ComponentActivity)t : null;
        if (componentActivity != null) {
            componentActivity.removeOnNewIntentListener(this.onNewIntentListener);
        }
        this.currentActivity = new WeakReference<Object>(null);
        this.connectionState.setValue((Object)ConnectionState.UNKNOWN);
        ContextExtensionsKt.unregisterNetworkCallback((Context)this.getContext(), (ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    /*
     * WARNING - void declaration
     */
    private final void initForm() {
        void $this$initForm_u24lambda_u242;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$initForm_u24lambda_u242.put("version", (JsonElement)JsonElementKt.JsonPrimitive((String)"5.2.0"));
        $this$initForm_u24lambda_u242.put("client", (JsonElement)JsonElementKt.JsonPrimitive((String)this.getContext().getString(R.string.xs2a_client_tag)));
        if (this.redirectDeepLink != null) {
            $this$initForm_u24lambda_u242.put("location", (JsonElement)JsonElementKt.JsonPrimitive((String)this.redirectDeepLink));
        }
        xS2AWizardViewModel.submitForm$xs2awizard_release((JsonElement)builder$iv.build(), true);
    }

    public final boolean backButtonIsPresent() {
        boolean bl;
        block5: {
            List list = (List)this.form.getValue();
            if (list != null) {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CharSequence charSequence;
                        FormLineData it = (FormLineData)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = it instanceof SubmitLineData && !((charSequence = (CharSequence)((SubmitLineData)it).getBackLabel()) == null || charSequence.length() == 0) || it instanceof RedirectLineData && !((charSequence = (CharSequence)((RedirectLineData)it).getBackLabel()) == null || charSequence.length() == 0);
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldAbortNetworkRequest() {
        return !this.enableAutomaticRetry && this.connectionState.getValue() == ConnectionState.DISCONNECTED;
    }

    /*
     * WARNING - void declaration
     */
    public final void goBack() {
        void $this$goBack_u24lambda_u244;
        JsonObjectBuilder builder$iv;
        if (!this.backButtonIsPresent()) {
            return;
        }
        XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
        if (xS2AWizardCallbackListener != null) {
            xS2AWizardCallbackListener.onBack();
        }
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$goBack_u24lambda_u244.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"back"));
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void abort() {
        void $this$abort_u24lambda_u245;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$abort_u24lambda_u245.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"abort"));
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void restart() {
        void $this$restart_u24lambda_u246;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$restart_u24lambda_u246.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"restart"));
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    @NotNull
    public final JsonObject constructJsonBody$xs2awizard_release(@NotNull String action, @Nullable JsonObject values) {
        JsonObjectBuilder builder$iv;
        block4: {
            Object it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            List list;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$constructJsonBody_u24lambda_u249 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            List list2 = list = (List)this.form.getValue();
            if (list2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"value");
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement jsonElement;
                    it = (FormLineData)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ValueFormLineData) || it instanceof CheckBoxLineData && !((jsonElement = ((ValueFormLineData)it).getValue()) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? Intrinsics.areEqual((Object)JsonElementKt.getBooleanOrNull((JsonPrimitive)jsonElement), (Object)true) : false)) continue;
                    String string2 = ((ValueFormLineData)it).getName();
                    JsonElement jsonElement2 = ((ValueFormLineData)it).getValue();
                    if (jsonElement2 == null || (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) == null) {
                        jsonElement2 = (JsonPrimitive)JsonNull.INSTANCE;
                    }
                    $this$constructJsonBody_u24lambda_u249.put(string2, jsonElement2);
                }
            }
            $this$constructJsonBody_u24lambda_u249.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)action));
            Object object = values;
            if (object == null || (object = object.entrySet()) == null) break block4;
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Map.Entry)element$iv;
                boolean bl3 = false;
                JsonElementBuildersKt.put((JsonObjectBuilder)$this$constructJsonBody_u24lambda_u249, (String)((String)it.getKey()), (String)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)it.getValue())).getContent());
            }
        }
        return builder$iv.build();
    }

    public static /* synthetic */ JsonObject constructJsonBody$xs2awizard_release$default(XS2AWizardViewModel xS2AWizardViewModel, String string2, JsonObject jsonObject, int n, Object object) {
        if ((n & 2) != 0) {
            jsonObject = null;
        }
        return xS2AWizardViewModel.constructJsonBody$xs2awizard_release(string2, jsonObject);
    }

    public final void submitForm$xs2awizard_release() {
        this.submitForm$xs2awizard_release("submit");
    }

    public final void submitForm$xs2awizard_release(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.submitForm$xs2awizard_release((JsonElement)XS2AWizardViewModel.constructJsonBody$xs2awizard_release$default(this, action, null, 2, null), true);
    }

    public final void submitForm$xs2awizard_release(@NotNull JsonElement jsonBody, boolean showIndicator) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.submitForm(jsonBody.toString(), showIndicator);
    }

    public static /* synthetic */ void submitForm$xs2awizard_release$default(XS2AWizardViewModel xS2AWizardViewModel, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        xS2AWizardViewModel.submitForm$xs2awizard_release(jsonElement, bl);
    }

    private final void submitForm(String jsonBody, boolean showIndicator) {
        if (this.shouldAbortNetworkRequest()) {
            return;
        }
        if (showIndicator) {
            this.loadingIndicatorLock.setValue((Object)true);
        }
        BiometricPrompt biometricPrompt = this.currentBiometricPromp;
        if (biometricPrompt != null) {
            biometricPrompt.cancelAuthentication();
        }
        if (Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToStoreCredentials();
        }
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(jsonBody, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                XS2AWizardViewModel.access$onFormReceived((XS2AWizardViewModel)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.this$0.getCallbackListener();
                if (xS2AWizardCallbackListener != null) {
                    xS2AWizardCallbackListener.onNetworkError();
                }
                this.this$0.getLoadingIndicatorLock$xs2awizard_release().setValue((Object)false);
            }
        });
    }

    public final void submitFormWithCallback$xs2awizard_release(@NotNull String action, @NotNull Function1<? super String, Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        if (this.shouldAbortNetworkRequest()) {
            return;
        }
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(XS2AWizardViewModel.constructJsonBody$xs2awizard_release$default(this, action, null, 2, null).toString(), onSuccess, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.this$0.getCallbackListener();
                if (xS2AWizardCallbackListener != null) {
                    xS2AWizardCallbackListener.onNetworkError();
                }
                this.this$0.getLoadingIndicatorLock$xs2awizard_release().setValue((Object)false);
            }
        });
    }

    public final void handleAnnotationClick$xs2awizard_release(@NotNull Activity activity, @NotNull AnnotatedString.Range<String> annotation) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        if (Intrinsics.areEqual((Object)annotation.getTag(), (Object)"autosubmit")) {
            JsonObject jsonBody = MarkupParser.INSTANCE.parseAutoSubmitPayloadAsJson((String)annotation.getItem());
            XS2AWizardViewModel.submitForm$xs2awizard_release$default(this, (JsonElement)this.constructJsonBody$xs2awizard_release("autosubmit", jsonBody), false, 2, null);
        } else {
            new CustomTabsIntent.Builder().build().launchUrl((Context)activity, Uri.parse((String)((String)annotation.getItem())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onFormReceived(String jsonString) {
        StringFormat $this$decodeFromString$iv = (StringFormat)JSONFormatter.INSTANCE.getFormatter();
        boolean $i$f$decodeFromString = false;
        $this$decodeFromString$iv.getSerializersModule();
        FormResponse formResponse = (FormResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)FormResponse.Companion.serializer(), jsonString);
        if (Utils.INSTANCE.checkIfLanguageNeedsToBeChanged(formResponse.getLanguage(), this.language)) {
            void $this$onFormReceived_u24lambda_u2410;
            JsonObjectBuilder builder$iv;
            XS2AWizardLanguage xS2AWizardLanguage = this.language;
            if (xS2AWizardLanguage == null) {
                String string2 = Locale.getDefault().getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().language");
                xS2AWizardLanguage = XS2AWizardLanguage.Companion.fromString$default(XS2AWizardLanguage.Companion, string2, null, 2, null);
            }
            XS2AWizardLanguage languageToChangeTo = xS2AWizardLanguage;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
            XS2AWizardViewModel xS2AWizardViewModel = this;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2410, (String)"action", (String)"change-language");
            String string3 = languageToChangeTo.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2410, (String)"language", (String)string3);
            XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
            return;
        }
        this.parseCallback(formResponse);
        this.form.setValue(formResponse.getForm());
        if (Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToAutoFillCredentials();
        }
        this.loadingIndicatorLock.setValue((Object)false);
    }

    private final boolean isProviderInStore(String provider) {
        Set set = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0).getStringSet(storedProvidersKey, null);
        return set != null ? set.contains(provider) : false;
    }

    private final void storeProvider(String provider) {
        SharedPreferences sharedPreferences;
        SharedPreferences $this$storeProvider_u24lambda_u2412 = sharedPreferences = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0);
        boolean bl = false;
        Set it = $this$storeProvider_u24lambda_u2412.getStringSet(storedProvidersKey, null);
        boolean bl2 = false;
        Set providers = new LinkedHashSet();
        if (it != null) {
            providers.addAll(providers);
        }
        providers.add(provider);
        $this$storeProvider_u24lambda_u2412.edit().putStringSet(storedProvidersKey, providers).apply();
    }

    @RequiresApi(value=23)
    private final void tryToStoreCredentials() {
        CheckBoxLineData consentCheckBoxLineData;
        CheckBoxLineData checkBoxLineData;
        Object v1;
        block3: {
            CharSequence charSequence;
            if (this.form.getValue() == null || (charSequence = (CharSequence)this.provider) == null || charSequence.length() == 0) {
                return;
            }
            Object object = this.form.getValue();
            Intrinsics.checkNotNull((Object)object);
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FormLineData it = (FormLineData)element$iv;
                boolean bl = false;
                if (!(it instanceof CheckBoxLineData && Intrinsics.areEqual((Object)((CheckBoxLineData)it).getName(), (Object)rememberLoginName))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if (!((checkBoxLineData = (consentCheckBoxLineData = (CheckBoxLineData)v1)) != null && (checkBoxLineData = checkBoxLineData.getValue()) != null && (checkBoxLineData = JsonElementKt.getJsonPrimitive((JsonElement)checkBoxLineData)) != null ? JsonElementKt.getBoolean((JsonPrimitive)checkBoxLineData) : false)) {
            return;
        }
        Object object = this.form.getValue();
        Intrinsics.checkNotNull((Object)object);
        List formCopy = (List)object;
        Object t = this.currentActivity.get();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        FragmentActivity fragmentActivity = (FragmentActivity)t;
        String string2 = this.getContext().getString(R.string.save_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026credentials_prompt_title)");
        String string3 = this.getContext().getString(R.string.save_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026tials_prompt_description)");
        String string4 = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.string.cancel)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, string2, string3, string4, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)new Function1<BiometricPrompt.AuthenticationResult, Unit>(this, (List<? extends FormLineData>)formCopy){
            final /* synthetic */ XS2AWizardViewModel this$0;
            final /* synthetic */ List<FormLineData> $formCopy;
            {
                this.this$0 = $receiver;
                this.$formCopy = $formCopy;
                super(1);
            }

            public final void invoke(@NotNull BiometricPrompt.AuthenticationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardViewModel.access$storeCredentials(this.this$0, this.$formCopy);
            }
        }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)tryToStoreCredentials.2.INSTANCE));
    }

    @RequiresApi(value=23)
    private final void storeCredentials(List<? extends FormLineData> form) {
        SharedPreferences.Editor editor;
        String string2 = this.provider;
        Intrinsics.checkNotNull((Object)string2);
        this.storeProvider(string2);
        SharedPreferences.Editor $this$storeCredentials_u24lambda_u2415 = editor = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, Crypto.INSTANCE.createMasterKey(this.getContext(), masterKeyAlias)).edit();
        boolean bl = false;
        Iterable $this$forEach$iv = form;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FormLineData it = (FormLineData)element$iv;
            boolean bl2 = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            if (it instanceof CheckBoxLineData) {
                JsonElement jsonElement;
                CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
                String string3 = this.provider;
                Intrinsics.checkNotNull((Object)string3);
                $this$storeCredentials_u24lambda_u2415.putBoolean(credentialFormLineData.getProviderName(string3), (jsonElement = ((CredentialFormLineData)it).getValue()) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getBoolean((JsonPrimitive)jsonElement) : false);
                continue;
            }
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string4 = this.provider;
            Intrinsics.checkNotNull((Object)string4);
            String string5 = credentialFormLineData.getProviderName(string4);
            Object object = ((CredentialFormLineData)it).getValue();
            if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                object = "";
            }
            $this$storeCredentials_u24lambda_u2415.putString(string5, (String)object);
        }
        $this$storeCredentials_u24lambda_u2415.apply();
    }

    @RequiresApi(value=23)
    private final void tryToAutoFillCredentials() {
        block12: {
            block11: {
                boolean bl;
                if (this.form.getValue() == null) break block11;
                List list = (List)this.form.getValue();
                if (list != null) {
                    boolean bl2;
                    block10: {
                        Iterable $this$none$iv = list;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                FormLineData it = (FormLineData)element$iv;
                                boolean bl3 = false;
                                if (!(it instanceof CredentialFormLineData && Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true))) continue;
                                bl2 = false;
                                break block10;
                            }
                            bl2 = true;
                        }
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (!bl) break block12;
            }
            return;
        }
        CharSequence charSequence = this.provider;
        if (charSequence == null || charSequence.length() == 0 || !this.isProviderInStore(this.provider)) {
            return;
        }
        Object t = this.currentActivity.get();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        FragmentActivity fragmentActivity = (FragmentActivity)t;
        String string2 = this.getContext().getString(R.string.fill_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026credentials_prompt_title)");
        String string3 = this.getContext().getString(R.string.fill_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026tials_prompt_description)");
        String string4 = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.string.cancel)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, string2, string3, string4, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)new Function1<BiometricPrompt.AuthenticationResult, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BiometricPrompt.AuthenticationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardViewModel.access$autoFillCredentials(this.this$0);
            }
        }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)tryToAutoFillCredentials.3.INSTANCE));
    }

    @RequiresApi(value=23)
    private final void autoFillCredentials() {
        SharedPreferences sharedPreferences = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, Crypto.INSTANCE.createMasterKey(this.getContext(), masterKeyAlias));
        Object object = this.form.getValue();
        Intrinsics.checkNotNull((Object)object);
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FormLineData it = (FormLineData)element$iv;
            boolean bl = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string2 = this.provider;
            Intrinsics.checkNotNull((Object)string2);
            String key = credentialFormLineData.getProviderName(string2);
            if (it instanceof CheckBoxLineData) {
                if (!sharedPreferences.contains(key)) continue;
                ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((Boolean)sharedPreferences.getBoolean(key, false)));
                continue;
            }
            if (!sharedPreferences.contains(key)) continue;
            ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((String)sharedPreferences.getString(key, "")));
        }
        this.submitForm$xs2awizard_release();
    }

    private final void parseCallback(FormResponse response) {
        block10: {
            this.currentState = response.getStep();
            String string2 = response.getCallback();
            if (Intrinsics.areEqual((Object)string2, (Object)"finish")) {
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
                if (xS2AWizardCallbackListener != null) {
                    JsonElement jsonElement = response.getCallbackParams();
                    xS2AWizardCallbackListener.onFinish(jsonElement != null && (jsonElement = (JsonElement)CollectionsKt.getOrNull(jsonElement, (int)0)) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null);
                }
            } else if (Intrinsics.areEqual((Object)string2, (Object)"abort")) {
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
                if (xS2AWizardCallbackListener != null) {
                    xS2AWizardCallbackListener.onAbort();
                }
            } else {
                this.currentStep = XS2AWizardStep.Companion.getRelevantStep(response.getCallback());
                if (this.currentStep != null) {
                    XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
                    if (xS2AWizardCallbackListener != null) {
                        XS2AWizardStep xS2AWizardStep = this.currentStep;
                        Intrinsics.checkNotNull((Object)xS2AWizardStep);
                        xS2AWizardCallbackListener.onStep(xS2AWizardStep);
                    }
                }
            }
            List<JsonElement> list = response.getCallbackParams();
            JsonElement it = list != null ? (JsonElement)CollectionsKt.first(list) : null;
            boolean bl = false;
            if (it instanceof JsonObject && ((JsonObject)it).containsKey((Object)"provider")) {
                Object object = ((JsonObject)it).get((Object)"provider");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
                this.provider = ((JsonPrimitive)object).getContent();
            }
            if (response.getError() == null) break block10;
            XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
            if (xS2AWizardCallbackListener != null) {
                Boolean bl2 = response.isErrorRecoverable();
                xS2AWizardCallbackListener.onError(XS2AWizardError.Companion.getRelevantError(response.getError(), bl2 != null ? bl2 : false));
            }
        }
    }

    private final void openWebView(String url) {
        this.currentWebViewUrl.setValue((Object)url);
    }

    public final void closeWebView$xs2awizard_release() {
        this.currentWebViewUrl.setValue(null);
    }

    private final void openExternalUrl(String url) {
        Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        Object t = this.currentActivity.get();
        Intrinsics.checkNotNull(t);
        ((Activity)t).startActivity(webIntent);
    }

    public final void openRedirectURL$xs2awizard_release(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.urlSupportsAppRedirection(url)) {
            AlertDialog.Builder builder;
            Object t = this.currentActivity.get();
            Intrinsics.checkNotNull(t);
            AlertDialog.Builder $this$openRedirectURL_u24lambda_u2421 = builder = new AlertDialog.Builder((Context)t);
            boolean bl = false;
            $this$openRedirectURL_u24lambda_u2421.setTitle(R.string.redirect_dialog_title);
            $this$openRedirectURL_u24lambda_u2421.setMessage(R.string.redirect_dialog_message);
            $this$openRedirectURL_u24lambda_u2421.setPositiveButton(R.string.redirect_dialog_banking_app_button_title, (arg_0, arg_1) -> XS2AWizardViewModel.openRedirectURL$lambda$21$lambda$19(this, url, arg_0, arg_1));
            $this$openRedirectURL_u24lambda_u2421.setNegativeButton(R.string.redirect_dialog_website_button_title, (arg_0, arg_1) -> XS2AWizardViewModel.openRedirectURL$lambda$21$lambda$20(this, url, arg_0, arg_1));
            $this$openRedirectURL_u24lambda_u2421.show();
        } else {
            this.openWebView(url);
        }
    }

    public final boolean isBankSearch() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)"bank");
    }

    public final boolean isLogin() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)"login");
    }

    private final boolean urlSupportsAppRedirection(String url) {
        Iterable iterable = supportedAppRedirectionURLs;
        String $this$toUri$iv = url;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        return CollectionsKt.contains((Iterable)iterable, (Object)uri.getHost());
    }

    public final boolean isRedirectDeepLink$xs2awizard_release(@Nullable String url) {
        return Intrinsics.areEqual((Object)url, (Object)this.redirectDeepLink);
    }

    public final void redirectionCallback$xs2awizard_release(boolean success) {
        this.closeWebView$xs2awizard_release();
        if (success) {
            this.submitForm$xs2awizard_release("post-code");
        }
    }

    private static final void onNewIntentListener$lambda$0(XS2AWizardViewModel this$0, Intent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!Intrinsics.areEqual((Object)it.getAction(), (Object)"android.intent.action.VIEW") || it.getData() == null) {
            return;
        }
        if (this$0.isRedirectDeepLink$xs2awizard_release(it.getDataString())) {
            this$0.redirectionCallback$xs2awizard_release(true);
        }
    }

    private static final void openRedirectURL$lambda$21$lambda$19(XS2AWizardViewModel this$0, String $url, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        this$0.openExternalUrl($url);
    }

    private static final void openRedirectURL$lambda$21$lambda$20(XS2AWizardViewModel this$0, String $url, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        this$0.openWebView($url);
    }

    public static final /* synthetic */ void access$onFormReceived(XS2AWizardViewModel $this, String jsonString) {
        $this.onFormReceived(jsonString);
    }

    public static final /* synthetic */ void access$storeCredentials(XS2AWizardViewModel $this, List form) {
        $this.storeCredentials(form);
    }

    public static final /* synthetic */ void access$autoFillCredentials(XS2AWizardViewModel $this) {
        $this.autoFillCredentials();
    }

    static {
        Object[] objectArray = new String[]{"manage.xs2a.com", "myaccount.ing.com"};
        supportedAppRedirectionURLs = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$Companion;", "", "()V", "masterKeyAlias", "", "rememberLoginName", "sharedPreferencesFileName", "storedProvidersKey", "supportedAppRedirectionURLs", "", "clearCredentials", "", "context", "Landroid/content/Context;", "xs2awizard_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCredentials(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSharedPreferences(XS2AWizardViewModel.sharedPreferencesFileName, 0).edit();
            SharedPreferences.Editor $this$clearCredentials_u24lambda_u240 = object;
            boolean bl = false;
            $this$clearCredentials_u24lambda_u240.clear();
            $this$clearCredentials_u24lambda_u240.apply();
            Object $this$clearCredentials_u24lambda_u241 = object = KeyStore.getInstance("AndroidKeyStore");
            boolean bl2 = false;
            ((KeyStore)$this$clearCredentials_u24lambda_u241).load(null);
            ((KeyStore)$this$clearCredentials_u24lambda_u241).deleteEntry(XS2AWizardViewModel.masterKeyAlias);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

