/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.components;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import androidx.biometric.BiometricPrompt;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.savedstate.SavedStateRegistry;
import com.android.volley.VolleyError;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardCallbackListener;
import com.fintecsystems.xs2awizard.components.XS2AWizardError;
import com.fintecsystems.xs2awizard.components.XS2AWizardLanguage;
import com.fintecsystems.xs2awizard.components.XS2AWizardStep;
import com.fintecsystems.xs2awizard.components.XS2AWizardViewModel;
import com.fintecsystems.xs2awizard.components.networking.ConnectionState;
import com.fintecsystems.xs2awizard.form.CheckBoxLineData;
import com.fintecsystems.xs2awizard.form.CredentialFormLineData;
import com.fintecsystems.xs2awizard.form.FormLineData;
import com.fintecsystems.xs2awizard.form.FormResponse;
import com.fintecsystems.xs2awizard.form.SubmitLineData;
import com.fintecsystems.xs2awizard.form.ValueFormLineData;
import com.fintecsystems.xs2awizard.helper.Crypto;
import com.fintecsystems.xs2awizard.helper.JSONFormatter;
import com.fintecsystems.xs2awizard.helper.MarkupParser;
import com.fintecsystems.xs2awizard.helper.Utils;
import com.fintecsystems.xs2awizard_networking.ContextExtensionsKt;
import com.fintecsystems.xs2awizard_networking.NetworkingInstance;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u00015\b\u0007\u0018\u0000 j2\u00020\u0001:\u0001jB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u000209H\u0003J\u0006\u0010;\u001a\u00020#J\r\u0010<\u001a\u000209H\u0000\u00a2\u0006\u0002\b=J!\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001d2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010?H\u0000\u00a2\u0006\u0002\bBJ\u0006\u0010C\u001a\u000209J#\u0010D\u001a\u0002092\u0006\u0010E\u001a\u00020\u00192\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d0GH\u0000\u00a2\u0006\u0002\bHJ\b\u0010I\u001a\u000209H\u0002J\u0006\u0010J\u001a\u00020#J\u0006\u0010K\u001a\u00020#J\u0012\u0010L\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010M\u001a\u0002092\u0006\u0010N\u001a\u00020\u001dH\u0002JI\u0010O\u001a\u0002092\u0006\u0010P\u001a\u00020\u001d2\b\u0010Q\u001a\u0004\u0018\u00010\u001d2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\u0006\u0010E\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bRJ\r\u0010S\u001a\u000209H\u0000\u00a2\u0006\u0002\bTJ\u0015\u0010U\u001a\u0002092\u0006\u0010V\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bWJ\u0010\u0010X\u001a\u0002092\u0006\u0010Y\u001a\u00020ZH\u0002J\u0006\u0010[\u001a\u000209J\b\u0010\\\u001a\u00020#H\u0002J\u0016\u0010]\u001a\u0002092\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0003J\u0010\u0010^\u001a\u0002092\u0006\u00107\u001a\u00020\u001dH\u0002J\r\u0010_\u001a\u000209H\u0000\u00a2\u0006\u0002\b`J\u0015\u0010_\u001a\u0002092\u0006\u0010@\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b`J\u0018\u0010_\u001a\u0002092\u0006\u0010a\u001a\u00020\u001d2\u0006\u0010b\u001a\u00020#H\u0002J\u001f\u0010_\u001a\u0002092\u0006\u0010a\u001a\u00020c2\b\b\u0002\u0010b\u001a\u00020#H\u0000\u00a2\u0006\u0002\b`J)\u0010d\u001a\u0002092\u0006\u0010@\u001a\u00020\u001d2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002090fH\u0000\u00a2\u0006\u0002\bgJ\b\u0010h\u001a\u000209H\u0003J\b\u0010i\u001a\u000209H\u0003R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\"\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020.\u0018\u00010-0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0012R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00102\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010#0#0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0012R\u0010\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106R\u0010\u00107\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Landroid/app/Application;Landroidx/lifecycle/SavedStateHandle;)V", "callbackListener", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;", "getCallbackListener", "()Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;", "setCallbackListener", "(Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;)V", "connectionState", "Landroidx/lifecycle/MutableLiveData;", "Lcom/fintecsystems/xs2awizard/components/networking/ConnectionState;", "kotlin.jvm.PlatformType", "getConnectionState$xs2awizard_release", "()Landroidx/lifecycle/MutableLiveData;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "currentBiometricPromp", "Landroidx/biometric/BiometricPrompt;", "currentState", "", "currentStep", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardStep;", "currentWebViewUrl", "getCurrentWebViewUrl$xs2awizard_release", "enableAutomaticRetry", "", "enableBackButton", "getEnableBackButton$xs2awizard_release", "()Z", "setEnableBackButton$xs2awizard_release", "(Z)V", "enableScroll", "getEnableScroll$xs2awizard_release", "setEnableScroll$xs2awizard_release", "form", "", "Lcom/fintecsystems/xs2awizard/form/FormLineData;", "getForm$xs2awizard_release", "language", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardLanguage;", "loadingIndicatorLock", "getLoadingIndicatorLock$xs2awizard_release", "networkCallback", "com/fintecsystems/xs2awizard/components/XS2AWizardViewModel$networkCallback$1", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$networkCallback$1;", "provider", "abort", "", "autoFillCredentials", "backButtonIsPresent", "closeWebView", "closeWebView$xs2awizard_release", "constructJsonBody", "Lkotlinx/serialization/json/JsonObject;", "action", "values", "constructJsonBody$xs2awizard_release", "goBack", "handleAnnotationClick", "activity", "annotation", "Landroidx/compose/ui/text/AnnotatedString$Range;", "handleAnnotationClick$xs2awizard_release", "initForm", "isBankSearch", "isLogin", "isProviderInStore", "onFormReceived", "jsonString", "onStart", "sessionKey", "backendURL", "onStart$xs2awizard_release", "onStop", "onStop$xs2awizard_release", "openWebView", "url", "openWebView$xs2awizard_release", "parseCallback", "response", "Lcom/fintecsystems/xs2awizard/form/FormResponse;", "restart", "shouldAbortNetworkRequest", "storeCredentials", "storeProvider", "submitForm", "submitForm$xs2awizard_release", "jsonBody", "showIndicator", "Lkotlinx/serialization/json/JsonElement;", "submitFormWithCallback", "onSuccess", "Lkotlin/Function1;", "submitFormWithCallback$xs2awizard_release", "tryToAutoFillCredentials", "tryToStoreCredentials", "Companion", "xs2awizard_release"})
@StabilityInferred(parameters=0)
public final class XS2AWizardViewModel
extends AndroidViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private XS2AWizardCallbackListener callbackListener;
    @Nullable
    private XS2AWizardLanguage language;
    private boolean enableScroll;
    private boolean enableBackButton;
    private boolean enableAutomaticRetry;
    @NotNull
    private final MutableLiveData<List<FormLineData>> form;
    @NotNull
    private final MutableLiveData<Boolean> loadingIndicatorLock;
    @NotNull
    private final MutableLiveData<String> currentWebViewUrl;
    @NotNull
    private final MutableLiveData<ConnectionState> connectionState;
    @NotNull
    private final networkCallback.1 networkCallback;
    @Nullable
    private XS2AWizardStep currentStep;
    @Nullable
    private String provider;
    @NotNull
    private WeakReference<Activity> currentActivity;
    @Nullable
    private BiometricPrompt currentBiometricPromp;
    @Nullable
    private String currentState;
    public static final int $stable = 8;
    @NotNull
    private static final String rememberLoginName = "store_credentials";
    @NotNull
    private static final String sharedPreferencesFileName = "xs2a_credentials";
    @NotNull
    private static final String storedProvidersKey = "providers";
    @NotNull
    private static final String masterKeyAlias = "xs2a_credentials_master_key";

    public XS2AWizardViewModel(@NotNull Application application, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        super(application);
        this.enableScroll = true;
        this.enableBackButton = true;
        this.enableAutomaticRetry = true;
        this.form = new MutableLiveData();
        this.loadingIndicatorLock = new MutableLiveData((Object)false);
        this.currentWebViewUrl = new MutableLiveData(null);
        this.connectionState = new MutableLiveData((Object)ConnectionState.UNKNOWN);
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                this.this$0.getConnectionState$xs2awizard_release().postValue((Object)((Object)ConnectionState.CONNECTED));
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                this.this$0.getConnectionState$xs2awizard_release().postValue((Object)((Object)ConnectionState.DISCONNECTED));
            }
        };
        this.currentActivity = new WeakReference<Object>(null);
        Bundle xs2aWizardBundle = (Bundle)savedStateHandle.get("xs2aWizardConfig");
        if (xs2aWizardBundle != null) {
            this.currentWebViewUrl.setValue((Object)xs2aWizardBundle.getString("currentWebViewUrl"));
        }
        savedStateHandle.setSavedStateProvider("xs2aWizardConfig", new SavedStateRegistry.SavedStateProvider(){

            @NotNull
            public final Bundle saveState() {
                Bundle bundle = new Bundle();
                XS2AWizardViewModel xS2AWizardViewModel = this;
                Bundle $this$saveState_u24lambda_u2d0 = bundle;
                boolean bl = false;
                $this$saveState_u24lambda_u2d0.putString("currentWebViewUrl", (String)xS2AWizardViewModel.getCurrentWebViewUrl$xs2awizard_release().getValue());
                return bundle;
            }
        });
    }

    @Nullable
    public final XS2AWizardCallbackListener getCallbackListener() {
        return this.callbackListener;
    }

    public final void setCallbackListener(@Nullable XS2AWizardCallbackListener xS2AWizardCallbackListener) {
        this.callbackListener = xS2AWizardCallbackListener;
    }

    public final boolean getEnableScroll$xs2awizard_release() {
        return this.enableScroll;
    }

    public final void setEnableScroll$xs2awizard_release(boolean bl) {
        this.enableScroll = bl;
    }

    public final boolean getEnableBackButton$xs2awizard_release() {
        return this.enableBackButton;
    }

    public final void setEnableBackButton$xs2awizard_release(boolean bl) {
        this.enableBackButton = bl;
    }

    @NotNull
    public final MutableLiveData<List<FormLineData>> getForm$xs2awizard_release() {
        return this.form;
    }

    @NotNull
    public final MutableLiveData<Boolean> getLoadingIndicatorLock$xs2awizard_release() {
        return this.loadingIndicatorLock;
    }

    @NotNull
    public final MutableLiveData<String> getCurrentWebViewUrl$xs2awizard_release() {
        return this.currentWebViewUrl;
    }

    @NotNull
    public final MutableLiveData<ConnectionState> getConnectionState$xs2awizard_release() {
        return this.connectionState;
    }

    private final Context getContext() {
        Context context = this.getApplication().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplication<Application>().applicationContext");
        return context;
    }

    public final void onStart$xs2awizard_release(@NotNull String sessionKey, @Nullable String backendURL, @Nullable XS2AWizardLanguage language, boolean enableScroll, boolean enableBackButton, boolean enableAutomaticRetry, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.language = language;
        this.enableScroll = enableScroll;
        this.enableBackButton = enableBackButton;
        this.enableAutomaticRetry = enableAutomaticRetry;
        this.currentActivity = new WeakReference<Activity>(activity);
        Object object = NetworkingInstance.Companion.getInstance((Object)this.getContext());
        NetworkingInstance $this$onStart_u24lambda_u2d0 = (NetworkingInstance)object;
        boolean bl = false;
        $this$onStart_u24lambda_u2d0.setSessionKey(sessionKey);
        $this$onStart_u24lambda_u2d0.setBackendURL(backendURL);
        ContextExtensionsKt.registerNetworkCallback((Context)this.getContext(), (ConnectivityManager.NetworkCallback)this.networkCallback);
        this.initForm();
    }

    public final void onStop$xs2awizard_release() {
        this.loadingIndicatorLock.setValue((Object)false);
        this.currentWebViewUrl.setValue(null);
        this.form.setValue((Object)CollectionsKt.emptyList());
        this.language = null;
        this.currentStep = null;
        this.enableScroll = true;
        this.enableBackButton = true;
        this.enableAutomaticRetry = true;
        this.currentActivity = new WeakReference<Object>(null);
        this.connectionState.setValue((Object)ConnectionState.UNKNOWN);
        ContextExtensionsKt.unregisterNetworkCallback((Context)this.getContext(), (ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    /*
     * WARNING - void declaration
     */
    private final void initForm() {
        void $this$initForm_u24lambda_u2d1;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$initForm_u24lambda_u2d1.put("version", (JsonElement)JsonElementKt.JsonPrimitive((String)"4.0.0"));
        $this$initForm_u24lambda_u2d1.put("client", (JsonElement)JsonElementKt.JsonPrimitive((String)this.getContext().getString(R.string.xs2a_client_tag)));
        Unit unit = Unit.INSTANCE;
        xS2AWizardViewModel.submitForm$xs2awizard_release((JsonElement)builder$iv.build(), true);
    }

    public final boolean backButtonIsPresent() {
        boolean bl;
        List list = (List)this.form.getValue();
        if (list == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            block5: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CharSequence charSequence;
                        FormLineData it = (FormLineData)element$iv;
                        boolean bl4 = false;
                        boolean bl5 = it instanceof SubmitLineData && !((charSequence = (CharSequence)((SubmitLineData)it).getBackLabel()) == null || charSequence.length() == 0);
                        if (!bl5) continue;
                        bl3 = true;
                        break block5;
                    }
                    bl3 = false;
                }
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    private final boolean shouldAbortNetworkRequest() {
        return !this.enableAutomaticRetry && this.connectionState.getValue() == ConnectionState.DISCONNECTED;
    }

    /*
     * WARNING - void declaration
     */
    public final void goBack() {
        void $this$goBack_u24lambda_u2d3;
        JsonObjectBuilder builder$iv;
        if (!this.backButtonIsPresent()) {
            return;
        }
        XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
        if (xS2AWizardCallbackListener != null) {
            xS2AWizardCallbackListener.onBack();
        }
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$goBack_u24lambda_u2d3.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"back"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void abort() {
        void $this$abort_u24lambda_u2d4;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$abort_u24lambda_u2d4.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"abort"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void restart() {
        void $this$restart_u24lambda_u2d5;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$restart_u24lambda_u2d5.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"restart"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    @NotNull
    public final JsonObject constructJsonBody$xs2awizard_release(@NotNull String action, @Nullable JsonObject values) {
        Set set;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder $this$constructJsonBody_u24lambda_u2d8 = builder$iv = new JsonObjectBuilder();
        boolean bl2 = false;
        List list = (List)this.getForm$xs2awizard_release().getValue();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormLineData it = (FormLineData)element$iv;
                boolean bl3 = false;
                if (!(it instanceof ValueFormLineData)) continue;
                JsonElement jsonElement = ((ValueFormLineData)it).getValue();
                JsonPrimitive jsonPrimitive = jsonElement == null ? null : JsonElementKt.getJsonPrimitive((JsonElement)jsonElement);
                $this$constructJsonBody_u24lambda_u2d8.put(((ValueFormLineData)it).getName(), (JsonElement)(jsonPrimitive == null ? (JsonPrimitive)JsonNull.INSTANCE : jsonPrimitive));
            }
        }
        $this$constructJsonBody_u24lambda_u2d8.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)action));
        list = values;
        if (list != null && (set = list.entrySet()) != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                JsonElementBuildersKt.put((JsonObjectBuilder)$this$constructJsonBody_u24lambda_u2d8, (String)((String)it.getKey()), (String)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)it.getValue())).getContent());
            }
        }
        return builder$iv.build();
    }

    public static /* synthetic */ JsonObject constructJsonBody$xs2awizard_release$default(XS2AWizardViewModel xS2AWizardViewModel, String string, JsonObject jsonObject, int n, Object object) {
        if ((n & 2) != 0) {
            jsonObject = null;
        }
        return xS2AWizardViewModel.constructJsonBody$xs2awizard_release(string, jsonObject);
    }

    public final void submitForm$xs2awizard_release() {
        this.submitForm$xs2awizard_release("submit");
    }

    public final void submitForm$xs2awizard_release(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.submitForm$xs2awizard_release((JsonElement)XS2AWizardViewModel.constructJsonBody$xs2awizard_release$default(this, action, null, 2, null), true);
    }

    public final void submitForm$xs2awizard_release(@NotNull JsonElement jsonBody, boolean showIndicator) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.submitForm(jsonBody.toString(), showIndicator);
    }

    public static /* synthetic */ void submitForm$xs2awizard_release$default(XS2AWizardViewModel xS2AWizardViewModel, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        xS2AWizardViewModel.submitForm$xs2awizard_release(jsonElement, bl);
    }

    private final void submitForm(String jsonBody, boolean showIndicator) {
        BiometricPrompt biometricPrompt;
        if (this.shouldAbortNetworkRequest()) {
            return;
        }
        if (showIndicator) {
            this.loadingIndicatorLock.setValue((Object)true);
        }
        if ((biometricPrompt = this.currentBiometricPromp) != null) {
            biometricPrompt.cancelAuthentication();
        }
        if (Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToStoreCredentials();
        }
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(jsonBody, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                XS2AWizardViewModel.access$onFormReceived((XS2AWizardViewModel)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.this$0.getCallbackListener();
                if (xS2AWizardCallbackListener != null) {
                    xS2AWizardCallbackListener.onNetworkError();
                }
                this.this$0.getLoadingIndicatorLock$xs2awizard_release().setValue((Object)false);
            }
        });
    }

    public final void submitFormWithCallback$xs2awizard_release(@NotNull String action, @NotNull Function1<? super String, Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        if (this.shouldAbortNetworkRequest()) {
            return;
        }
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(XS2AWizardViewModel.constructJsonBody$xs2awizard_release$default(this, action, null, 2, null).toString(), onSuccess, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.this$0.getCallbackListener();
                if (xS2AWizardCallbackListener != null) {
                    xS2AWizardCallbackListener.onNetworkError();
                }
                this.this$0.getLoadingIndicatorLock$xs2awizard_release().setValue((Object)false);
            }
        });
    }

    public final void handleAnnotationClick$xs2awizard_release(@NotNull Activity activity, @NotNull AnnotatedString.Range<String> annotation) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        String string2 = annotation.getTag();
        if (Intrinsics.areEqual((Object)string2, (Object)"autosubmit")) {
            JsonObject jsonBody = MarkupParser.INSTANCE.parseAutoSubmitPayloadAsJson((String)annotation.getItem());
            XS2AWizardViewModel.submitForm$xs2awizard_release$default(this, (JsonElement)this.constructJsonBody$xs2awizard_release("autosubmit", jsonBody), false, 2, null);
        } else {
            new CustomTabsIntent.Builder().build().launchUrl((Context)activity, Uri.parse((String)((String)annotation.getItem())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onFormReceived(String jsonString) {
        StringFormat $this$decodeFromString$iv = (StringFormat)JSONFormatter.INSTANCE.getFormatter();
        boolean $i$f$decodeFromString2 = false;
        Object $this$serializer$iv$iv2 = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer2 = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv2, (KType)Reflection.typeOf(FormResponse.class));
        boolean $i$f$cast = false;
        FormResponse formResponse = (FormResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonString);
        if (Utils.INSTANCE.checkIfLanguageNeedsToBeChanged(formResponse.getLanguage(), this.language)) {
            void $this$onFormReceived_u24lambda_u2d9;
            JsonObjectBuilder builder$iv;
            XS2AWizardLanguage xS2AWizardLanguage;
            XS2AWizardLanguage $i$f$decodeFromString2 = this.language;
            if ($i$f$decodeFromString2 == null) {
                $this$serializer$iv$iv2 = Locale.getDefault().getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)$this$serializer$iv$iv2, (String)"getDefault().language");
                xS2AWizardLanguage = XS2AWizardLanguage.Companion.fromString$default(XS2AWizardLanguage.Companion, (String)$this$serializer$iv$iv2, null, 2, null);
            } else {
                xS2AWizardLanguage = $i$f$decodeFromString2;
            }
            XS2AWizardLanguage languageToChangeTo = xS2AWizardLanguage;
            boolean $i$f$buildJsonObject = false;
            boolean $this$serializer$iv$iv2 = false;
            JsonObjectBuilder $i$f$serializer2 = builder$iv = new JsonObjectBuilder();
            XS2AWizardViewModel xS2AWizardViewModel = this;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2d9, (String)"action", (String)"change-language");
            String string2 = languageToChangeTo.toString();
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2d9, (String)"language", (String)string3);
            Unit unit = Unit.INSTANCE;
            XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
            return;
        }
        this.parseCallback(formResponse);
        this.form.setValue(formResponse.getForm());
        if (Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToAutoFillCredentials();
        }
        this.loadingIndicatorLock.setValue((Object)false);
    }

    private final boolean isProviderInStore(String provider) {
        Set set = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0).getStringSet(storedProvidersKey, null);
        return set == null ? false : set.contains(provider);
    }

    private final void storeProvider(String provider) {
        Set set;
        SharedPreferences sharedPreferences;
        SharedPreferences $this$storeProvider_u24lambda_u2d11 = sharedPreferences = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0);
        boolean bl = false;
        Set it = set = $this$storeProvider_u24lambda_u2d11.getStringSet(storedProvidersKey, null);
        boolean bl2 = false;
        Set providers = new LinkedHashSet();
        if (it != null) {
            providers.addAll(providers);
        }
        providers.add(provider);
        $this$storeProvider_u24lambda_u2d11.edit().putStringSet(storedProvidersKey, providers).apply();
    }

    @RequiresApi(value=23)
    private final void tryToStoreCredentials() {
        JsonElement jsonElement;
        Object v1;
        JsonPrimitive jsonPrimitive;
        Object $this$firstOrNull$iv;
        block4: {
            CharSequence charSequence;
            if (this.form.getValue() == null || (charSequence = (CharSequence)this.provider) == null || charSequence.length() == 0) {
                return;
            }
            Object object = this.form.getValue();
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"form.value!!");
            $this$firstOrNull$iv = (Iterable)object2;
            boolean $i$f$firstOrNull = false;
            jsonPrimitive = $this$firstOrNull$iv.iterator();
            while (jsonPrimitive.hasNext()) {
                Object element$iv = jsonPrimitive.next();
                FormLineData it = (FormLineData)element$iv;
                boolean bl = false;
                if (!(it instanceof CheckBoxLineData && Intrinsics.areEqual((Object)((CheckBoxLineData)it).getName(), (Object)rememberLoginName))) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        CheckBoxLineData consentCheckBoxLineData = v1;
        $this$firstOrNull$iv = consentCheckBoxLineData;
        if (!($this$firstOrNull$iv == null ? false : ((jsonElement = ((CheckBoxLineData)$this$firstOrNull$iv).getValue()) == null ? false : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? false : JsonElementKt.getBoolean((JsonPrimitive)jsonPrimitive))))) {
            return;
        }
        Object object = this.form.getValue();
        Intrinsics.checkNotNull((Object)object);
        Object object3 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"form.value!!");
        List formCopy = (List)object3;
        object3 = this.currentActivity.get();
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        }
        FragmentActivity fragmentActivity = (FragmentActivity)object3;
        object3 = this.getContext().getString(R.string.save_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.getString(R.stri\u2026credentials_prompt_title)");
        Object object4 = object3;
        object3 = this.getContext().getString(R.string.save_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.getString(R.stri\u2026tials_prompt_description)");
        Object object5 = object3;
        object3 = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.getString(R.string.cancel)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, (String)object4, (String)object5, (String)object3, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)new Function1<BiometricPrompt.AuthenticationResult, Unit>(this, (List<? extends FormLineData>)formCopy){
            final /* synthetic */ XS2AWizardViewModel this$0;
            final /* synthetic */ List<FormLineData> $formCopy;
            {
                this.this$0 = $receiver;
                this.$formCopy = $formCopy;
                super(1);
            }

            public final void invoke(@NotNull BiometricPrompt.AuthenticationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardViewModel.access$storeCredentials(this.this$0, this.$formCopy);
            }
        }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)tryToStoreCredentials.2.INSTANCE));
    }

    @RequiresApi(value=23)
    private final void storeCredentials(List<? extends FormLineData> form) {
        SharedPreferences.Editor editor;
        String string2 = this.provider;
        Intrinsics.checkNotNull((Object)string2);
        this.storeProvider(string2);
        SharedPreferences.Editor $this$storeCredentials_u24lambda_u2d14 = editor = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, Crypto.INSTANCE.createMasterKey(this.getContext(), masterKeyAlias)).edit();
        boolean bl = false;
        Iterable $this$forEach$iv = form;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string3;
            JsonPrimitive jsonPrimitive;
            JsonElement jsonElement;
            FormLineData it = (FormLineData)element$iv;
            boolean bl2 = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            if (it instanceof CheckBoxLineData) {
                boolean bl3;
                CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
                String string4 = this.provider;
                Intrinsics.checkNotNull((Object)string4);
                jsonElement = ((CredentialFormLineData)it).getValue();
                $this$storeCredentials_u24lambda_u2d14.putBoolean(credentialFormLineData.getProviderName(string4), jsonElement == null ? false : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? false : (bl3 = JsonElementKt.getBoolean((JsonPrimitive)jsonPrimitive))));
                continue;
            }
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string5 = this.provider;
            Intrinsics.checkNotNull((Object)string5);
            jsonElement = ((CredentialFormLineData)it).getValue();
            $this$storeCredentials_u24lambda_u2d14.putString(credentialFormLineData.getProviderName(string5), jsonElement == null ? "" : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? "" : ((string3 = jsonPrimitive.getContent()) == null ? "" : string3)));
        }
        $this$storeCredentials_u24lambda_u2d14.apply();
    }

    @RequiresApi(value=23)
    private final void tryToAutoFillCredentials() {
        Object object;
        block13: {
            block12: {
                boolean bl;
                if (this.form.getValue() == null) break block12;
                object = (List)this.form.getValue();
                if (object == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    block11: {
                        Iterable $this$none$iv = (Iterable)object;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                FormLineData it = (FormLineData)element$iv;
                                boolean bl3 = false;
                                if (!(it instanceof CredentialFormLineData && Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true))) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                    }
                    bl = bl2;
                }
                if (!bl) break block13;
            }
            return;
        }
        object = this.provider;
        if (object == null || object.length() == 0 || !this.isProviderInStore(this.provider)) {
            return;
        }
        object = this.currentActivity.get();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        }
        FragmentActivity fragmentActivity = (FragmentActivity)object;
        object = this.getContext().getString(R.string.fill_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(R.stri\u2026credentials_prompt_title)");
        Object object2 = object;
        object = this.getContext().getString(R.string.fill_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(R.stri\u2026tials_prompt_description)");
        Object object3 = object;
        object = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(R.string.cancel)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, (String)object2, (String)object3, (String)object, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)new Function1<BiometricPrompt.AuthenticationResult, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BiometricPrompt.AuthenticationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardViewModel.access$autoFillCredentials(this.this$0);
            }
        }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)tryToAutoFillCredentials.3.INSTANCE));
    }

    @RequiresApi(value=23)
    private final void autoFillCredentials() {
        SharedPreferences sharedPreferences = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, Crypto.INSTANCE.createMasterKey(this.getContext(), masterKeyAlias));
        Object object = this.form.getValue();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"form.value!!");
        Iterable $this$forEach$iv = (Iterable)object2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FormLineData it = (FormLineData)element$iv;
            boolean bl = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string2 = this.provider;
            Intrinsics.checkNotNull((Object)string2);
            String key = credentialFormLineData.getProviderName(string2);
            if (it instanceof CheckBoxLineData) {
                if (!sharedPreferences.contains(key)) continue;
                ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((Boolean)sharedPreferences.getBoolean(key, false)));
                continue;
            }
            if (!sharedPreferences.contains(key)) continue;
            ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((String)sharedPreferences.getString(key, "")));
        }
        this.submitForm$xs2awizard_release();
    }

    private final void parseCallback(FormResponse response) {
        Object object;
        Object object2;
        this.currentState = response.getStep();
        Object object3 = response.getCallback();
        if (Intrinsics.areEqual((Object)object3, (Object)"finish")) {
            object2 = this.callbackListener;
            if (object2 != null) {
                JsonPrimitive jsonPrimitive;
                List<JsonElement> list = response.getCallbackParams();
                object2.onFinish(list == null ? null : ((object = (JsonElement)CollectionsKt.getOrNull(list, (int)0)) == null ? null : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null ? null : jsonPrimitive.getContent())));
            }
        } else if (Intrinsics.areEqual((Object)object3, (Object)"abort")) {
            object2 = this.callbackListener;
            if (object2 != null) {
                object2.onAbort();
            }
        } else {
            this.currentStep = XS2AWizardStep.Companion.getRelevantStep(response.getCallback());
            if (this.currentStep != null && (object2 = this.callbackListener) != null) {
                XS2AWizardStep xS2AWizardStep = this.currentStep;
                Intrinsics.checkNotNull((Object)xS2AWizardStep);
                object2.onStep(xS2AWizardStep);
            }
        }
        Object it = object3 = (object3 = response.getCallbackParams()) == null ? null : (JsonElement)CollectionsKt.first((List)object3);
        boolean bl = false;
        if (it instanceof JsonObject && ((JsonObject)it).containsKey((Object)"provider")) {
            object = ((JsonObject)it).get((Object)"provider");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            }
            this.provider = ((JsonPrimitive)object).getContent();
        }
        if (response.getError() != null && (object3 = this.callbackListener) != null) {
            object3.onError(XS2AWizardError.Companion.getRelevantError(response.getError(), (object2 = response.isErrorRecoverable()) == null ? false : (Boolean)object2));
        }
    }

    public final void openWebView$xs2awizard_release(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.currentWebViewUrl.setValue((Object)url);
    }

    public final void closeWebView$xs2awizard_release() {
        this.currentWebViewUrl.setValue(null);
    }

    public final boolean isBankSearch() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)"bank");
    }

    public final boolean isLogin() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)"login");
    }

    public static final /* synthetic */ void access$onFormReceived(XS2AWizardViewModel $this, String jsonString) {
        $this.onFormReceived(jsonString);
    }

    public static final /* synthetic */ void access$storeCredentials(XS2AWizardViewModel $this, List form) {
        $this.storeCredentials(form);
    }

    public static final /* synthetic */ void access$autoFillCredentials(XS2AWizardViewModel $this) {
        $this.autoFillCredentials();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$Companion;", "", "()V", "masterKeyAlias", "", "rememberLoginName", "sharedPreferencesFileName", "storedProvidersKey", "clearCredentials", "", "context", "Landroid/content/Context;", "xs2awizard_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCredentials(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSharedPreferences(XS2AWizardViewModel.sharedPreferencesFileName, 0).edit();
            SharedPreferences.Editor $this$clearCredentials_u24lambda_u2d0 = object;
            boolean bl = false;
            $this$clearCredentials_u24lambda_u2d0.clear();
            $this$clearCredentials_u24lambda_u2d0.apply();
            Object $this$clearCredentials_u24lambda_u2d1 = object = KeyStore.getInstance("AndroidKeyStore");
            boolean bl2 = false;
            ((KeyStore)$this$clearCredentials_u24lambda_u2d1).load(null);
            ((KeyStore)$this$clearCredentials_u24lambda_u2d1).deleteEntry(XS2AWizardViewModel.masterKeyAlias);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

