/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.helper;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.biometric.BiometricManager;
import androidx.biometric.BiometricPrompt;
import androidx.fragment.app.FragmentActivity;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\\\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001d\u00a8\u0006\u001f"}, d2={"Lcom/fintecsystems/xs2awizard/helper/Crypto;", "", "()V", "createEncryptedSharedPreferences", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "fileName", "", "masterKey", "Landroidx/security/crypto/MasterKey;", "createMasterKey", "keyAlias", "isDeviceSecure", "", "openBiometricPrompt", "Landroidx/biometric/BiometricPrompt;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "title", "description", "negativeText", "allowedAuthenticators", "", "onSuccess", "Lkotlin/Function1;", "Landroidx/biometric/BiometricPrompt$AuthenticationResult;", "", "onError", "Lkotlin/Function2;", "", "xs2awizard_release"})
@RequiresApi(value=23)
public final class Crypto {
    @NotNull
    public static final Crypto INSTANCE = new Crypto();

    private Crypto() {
    }

    @NotNull
    public final MasterKey createMasterKey(@NotNull Context context, @NotNull String keyAlias) {
        MasterKey.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        MasterKey.Builder $this$createMasterKey_u24lambda_u2d0 = builder = new MasterKey.Builder(context, keyAlias);
        boolean bl = false;
        $this$createMasterKey_u24lambda_u2d0.setKeyScheme(MasterKey.KeyScheme.AES256_GCM);
        $this$createMasterKey_u24lambda_u2d0.setUserAuthenticationRequired(true);
        if (Build.VERSION.SDK_INT >= 28) {
            $this$createMasterKey_u24lambda_u2d0.setRequestStrongBoxBacked(true);
        }
        MasterKey masterKey = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context, keyAlia\u2026      }\n        }.build()");
        return masterKey;
    }

    public final boolean isDeviceSecure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return BiometricManager.from((Context)context).canAuthenticate(15) == 0;
    }

    @NotNull
    public final SharedPreferences createEncryptedSharedPreferences(@NotNull Context context, @NotNull String fileName, @NotNull MasterKey masterKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)fileName, (MasterKey)masterKey, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n        context,\u2026onScheme.AES256_GCM\n    )");
        return sharedPreferences;
    }

    @NotNull
    public final BiometricPrompt openBiometricPrompt(@NotNull FragmentActivity fragmentActivity, @NotNull String title, @NotNull String description, @NotNull String negativeText, int allowedAuthenticators, @NotNull Function1<? super BiometricPrompt.AuthenticationResult, Unit> onSuccess, @NotNull Function2<? super Integer, ? super CharSequence, Unit> onError) {
        BiometricPrompt biometricPrompt;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)negativeText, (String)"negativeText");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        BiometricPrompt.AuthenticationCallback authenticationCallback2 = new BiometricPrompt.AuthenticationCallback(onSuccess, onError){
            final /* synthetic */ Function1<BiometricPrompt.AuthenticationResult, Unit> $onSuccess;
            final /* synthetic */ Function2<Integer, CharSequence, Unit> $onError;
            {
                this.$onSuccess = $onSuccess;
                this.$onError = $onError;
            }

            public void onAuthenticationSucceeded(@NotNull BiometricPrompt.AuthenticationResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                super.onAuthenticationSucceeded(result);
                this.$onSuccess.invoke((Object)result);
            }

            public void onAuthenticationError(int errorCode, @NotNull CharSequence errString) {
                Intrinsics.checkNotNullParameter((Object)errString, (String)"errString");
                super.onAuthenticationError(errorCode, errString);
                this.$onError.invoke((Object)errorCode, (Object)errString);
            }
        };
        BiometricPrompt $this$openBiometricPrompt_u24lambda_u2d1 = biometricPrompt = new BiometricPrompt(fragmentActivity, authenticationCallback2);
        boolean bl = false;
        BiometricPrompt.PromptInfo promptInfo = new BiometricPrompt.PromptInfo.Builder().setTitle((CharSequence)title).setDescription((CharSequence)description).setNegativeButtonText((CharSequence)negativeText).setAllowedAuthenticators(allowedAuthenticators).build();
        Intrinsics.checkNotNullExpressionValue((Object)promptInfo, (String)"Builder()\n              \u2026\n                .build()");
        BiometricPrompt.PromptInfo promptInfo2 = promptInfo;
        $this$openBiometricPrompt_u24lambda_u2d1.authenticate(promptInfo2);
        return biometricPrompt;
    }
}

