/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class FoldIndicator
extends AbstractGutterComponent {
    private Insets textAreaInsets;
    private Rectangle visibleRect;
    private Fold foldWithOutlineShowing;
    private Color foldIconBackground;
    private Icon collapsedFoldIcon;
    private Icon expandedFoldIcon;
    static final Color DEFAULT_FOREGROUND = Color.gray;
    static final Color DEFAULT_FOLD_BACKGROUND = Color.white;
    private Listener listener;
    private static final int WIDTH = 12;

    public FoldIndicator(RTextArea textArea) {
        super(textArea);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setFoldIconBackground(DEFAULT_FOLD_BACKGROUND);
        this.collapsedFoldIcon = new FoldIcon(true);
        this.expandedFoldIcon = new FoldIcon(false);
        this.listener = new Listener(this);
        this.visibleRect = new Rectangle();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public JToolTip createToolTip() {
        Color bg;
        JToolTip tip = super.createToolTip();
        Color textAreaBG = this.textArea.getBackground();
        if (textAreaBG != null && !Color.white.equals(textAreaBG) && (bg = TipUtil.getToolTipBackground()).getRed() >= 240 && bg.getGreen() >= 240 && bg.getBlue() >= 200) {
            tip.setBackground(textAreaBG);
        }
        return tip;
    }

    private Fold findOpenFoldClosestTo(Point p) {
        int offs;
        Fold fold = null;
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        if (rsta.isCodeFoldingEnabled() && (offs = rsta.viewToModel(p)) > -1) {
            try {
                int line;
                int origLine = line = rsta.getLineOfOffset(offs);
                FoldManager fm = rsta.getFoldManager();
                while ((fold = fm.getFoldForLine(line)) == null && line-- >= 0) {
                }
                if (fold != null && !fold.containsOrStartsOnLine(origLine)) {
                    fold = null;
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return fold;
    }

    public Color getFoldIconBackground() {
        return this.foldIconBackground;
    }

    public Dimension getPreferredSize() {
        int h = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(12, h);
    }

    public Point getToolTipLocation(MouseEvent e) {
        Point p = e.getPoint();
        p.y = p.y / this.textArea.getLineHeight() * this.textArea.getLineHeight();
        p.x = this.getWidth();
        return p;
    }

    public String getToolTipText(MouseEvent e) {
        String text = null;
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        if (rsta.isCodeFoldingEnabled()) {
            FoldManager fm = rsta.getFoldManager();
            int pos = rsta.viewToModel(new Point(0, e.getY()));
            if (pos >= 0) {
                int line = 0;
                try {
                    line = rsta.getLineOfOffset(pos);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    return null;
                }
                Fold fold = fm.getFoldForLine(line);
                if (fold != null && fold.isCollapsed()) {
                    int endLine = fold.getEndLine();
                    if (fold.getLineCount() > 25) {
                        endLine = fold.getStartLine() + 25;
                    }
                    StringBuffer sb = new StringBuffer("<html><nobr>");
                    while (line <= endLine && line < rsta.getLineCount()) {
                        for (Token t = rsta.getTokenListForLine(line); t != null && t.isPaintable(); t = t.getNextToken()) {
                            t.appendHTMLRepresentation(sb, rsta, true, true);
                        }
                        sb.append("<br>");
                        ++line;
                    }
                    text = sb.toString();
                }
            }
        }
        return text;
    }

    void handleDocumentEvent(DocumentEvent e) {
        int newLineCount = this.textArea.getLineCount();
        if (newLineCount != this.currentLineCount) {
            this.currentLineCount = newLineCount;
            this.repaint();
        }
    }

    void lineHeightsChanged() {
    }

    protected void paintComponent(Graphics g) {
        boolean paintingOutlineLine;
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = g.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        Color bg = this.getBackground();
        if (this.getGutter() != null) {
            bg = this.getGutter().getBackground();
        }
        g.setColor(bg);
        g.fillRect(0, this.visibleRect.y, this.getWidth(), this.visibleRect.height);
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        if (!rsta.isCodeFoldingEnabled()) {
            return;
        }
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(g);
            return;
        }
        int cellHeight = this.textArea.getLineHeight();
        int topLine = this.visibleRect.y / cellHeight;
        int y = topLine * cellHeight + (cellHeight - this.collapsedFoldIcon.getIconHeight()) / 2;
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.textAreaInsets != null) {
            y += this.textAreaInsets.top;
        }
        FoldManager fm = rsta.getFoldManager();
        topLine += fm.getHiddenLineCountAbove(topLine, true);
        int width = this.getWidth();
        int x = width - 10;
        int line = topLine;
        boolean bl = paintingOutlineLine = this.foldWithOutlineShowing != null && this.foldWithOutlineShowing.containsLine(line);
        while (y < this.visibleRect.y + this.visibleRect.height) {
            Fold fold;
            if (paintingOutlineLine) {
                g.setColor(this.getForeground());
                int w2 = width / 2;
                if (line == this.foldWithOutlineShowing.getEndLine()) {
                    int y2 = y + cellHeight / 2;
                    g.drawLine(w2, y, w2, y2);
                    g.drawLine(w2, y2, width - 2, y2);
                    paintingOutlineLine = false;
                } else {
                    g.drawLine(w2, y, w2, y + cellHeight);
                }
            }
            if ((fold = fm.getFoldForLine(line)) != null) {
                if (fold == this.foldWithOutlineShowing && !fold.isCollapsed()) {
                    g.setColor(this.getForeground());
                    int w2 = width / 2;
                    g.drawLine(w2, y + cellHeight / 2, w2, y + cellHeight);
                    paintingOutlineLine = true;
                }
                if (fold.isCollapsed()) {
                    this.collapsedFoldIcon.paintIcon(this, g, x, y);
                    while ((fold = fm.getFoldForLine(line += fold.getLineCount())) != null && fold.isCollapsed()) {
                    }
                } else {
                    this.expandedFoldIcon.paintIcon(this, g, x, y);
                }
            }
            ++line;
            y += cellHeight;
        }
    }

    private void paintComponentWrapped(Graphics g) {
        int width = this.getWidth();
        RTextAreaUI ui = (RTextAreaUI)this.textArea.getUI();
        View v = ui.getRootView(this.textArea).getView(0);
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int topPosition = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        int cellHeight = this.textArea.getLineHeight();
        FoldManager fm = ((RSyntaxTextArea)this.textArea).getFoldManager();
        Rectangle visibleEditorRect = ui.getVisibleEditorRect();
        Rectangle r = LineNumberList.getChildViewBounds(v, topLine, visibleEditorRect);
        int y = r.y;
        y += (cellHeight - this.collapsedFoldIcon.getIconHeight()) / 2;
        int visibleBottom = this.visibleRect.y + this.visibleRect.height;
        int x = width - 10;
        int line = topLine;
        boolean paintingOutlineLine = this.foldWithOutlineShowing != null && this.foldWithOutlineShowing.containsLine(line);
        int lineCount = root.getElementCount();
        while (y < visibleBottom && line < lineCount) {
            Fold fold;
            int curLineH = LineNumberList.getChildViewBounds((View)v, (int)line, (Rectangle)visibleEditorRect).height;
            if (paintingOutlineLine) {
                g.setColor(this.getForeground());
                int w2 = width / 2;
                if (line == this.foldWithOutlineShowing.getEndLine()) {
                    int y2 = y + curLineH - cellHeight / 2;
                    g.drawLine(w2, y, w2, y2);
                    g.drawLine(w2, y2, width - 2, y2);
                    paintingOutlineLine = false;
                } else {
                    g.drawLine(w2, y, w2, y + curLineH);
                }
            }
            if ((fold = fm.getFoldForLine(line)) != null) {
                if (fold == this.foldWithOutlineShowing && !fold.isCollapsed()) {
                    g.setColor(this.getForeground());
                    int w2 = width / 2;
                    g.drawLine(w2, y + cellHeight / 2, w2, y + curLineH);
                    paintingOutlineLine = true;
                }
                if (fold.isCollapsed()) {
                    this.collapsedFoldIcon.paintIcon(this, g, x, y);
                    y += LineNumberList.getChildViewBounds((View)v, (int)line, (Rectangle)visibleEditorRect).height;
                    line += fold.getLineCount() + 1;
                    continue;
                }
                this.expandedFoldIcon.paintIcon(this, g, x, y);
                y += curLineH;
                ++line;
                continue;
            }
            y += curLineH;
            ++line;
        }
    }

    private int rowAtPoint(Point p) {
        int line = 0;
        try {
            int offs = this.textArea.viewToModel(p);
            if (offs > -1) {
                line = this.textArea.getLineOfOffset(offs);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return line;
    }

    public void setFoldIconBackground(Color bg) {
        this.foldIconBackground = bg;
    }

    public void setFoldIcons(Icon collapsedIcon, Icon expandedIcon) {
        this.collapsedFoldIcon = collapsedIcon;
        this.expandedFoldIcon = expandedIcon;
        this.revalidate();
        this.repaint();
    }

    public void setTextArea(RTextArea textArea) {
        if (this.textArea != null) {
            this.textArea.removePropertyChangeListener("RSTA.codeFolding", this.listener);
        }
        super.setTextArea(textArea);
        if (this.textArea != null) {
            this.textArea.addPropertyChangeListener("RSTA.codeFolding", this.listener);
        }
    }

    private class Listener
    extends MouseInputAdapter
    implements PropertyChangeListener {
        public Listener(FoldIndicator fgc) {
            fgc.addMouseListener(this);
            fgc.addMouseMotionListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int line = FoldIndicator.this.rowAtPoint(p);
            RSyntaxTextArea rsta = (RSyntaxTextArea)FoldIndicator.this.textArea;
            FoldManager fm = rsta.getFoldManager();
            Fold fold = fm.getFoldForLine(line);
            if (fold != null) {
                fold.toggleCollapsedState();
                FoldIndicator.this.getGutter().repaint();
                FoldIndicator.this.textArea.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (FoldIndicator.this.foldWithOutlineShowing != null) {
                FoldIndicator.this.foldWithOutlineShowing = null;
                FoldIndicator.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            Fold newSelectedFold = FoldIndicator.this.findOpenFoldClosestTo(e.getPoint());
            if (newSelectedFold != FoldIndicator.this.foldWithOutlineShowing) {
                FoldIndicator.this.foldWithOutlineShowing = newSelectedFold;
                FoldIndicator.this.repaint();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            FoldIndicator.this.repaint();
        }
    }

    private class FoldIcon
    implements Icon {
        private boolean collapsed;

        public FoldIcon(boolean collapsed) {
            this.collapsed = collapsed;
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(FoldIndicator.this.foldIconBackground);
            g.fillRect(x, y, 8, 8);
            g.setColor(FoldIndicator.this.getForeground());
            g.drawRect(x, y, 8, 8);
            g.drawLine(x + 2, y + 4, x + 2 + 4, y + 4);
            if (this.collapsed) {
                g.drawLine(x + 4, y + 2, x + 4, y + 6);
            }
        }
    }
}

