/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class XmlFoldParser
implements FoldParser {
    private static final char[] MARKUP_CLOSING_TAG_START = new char[]{'<', '/'};
    private static final char[] MARKUP_SHORT_TAG_END = new char[]{'/', '>'};

    public List getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        try {
            for (int line = 0; line < lineCount; ++line) {
                for (Token t = textArea.getTokenListForLine(line); t != null && t.isPaintable(); t = t.getNextToken()) {
                    Fold parentFold;
                    if (t.type == 25 && t.isSingleChar('<')) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t.offset);
                            folds.add(currentFold);
                            continue;
                        }
                        currentFold = currentFold.createChild(0, t.offset);
                        continue;
                    }
                    if (t.is(25, MARKUP_SHORT_TAG_END)) {
                        if (currentFold == null) continue;
                        parentFold = currentFold.getParent();
                        currentFold.removeFromParent();
                        currentFold = parentFold;
                        continue;
                    }
                    if (!t.is(25, MARKUP_CLOSING_TAG_START) || currentFold == null) continue;
                    currentFold.setEndOffset(t.offset);
                    parentFold = currentFold.getParent();
                    if (currentFold.isOnSingleLine()) {
                        currentFold.removeFromParent();
                    }
                    currentFold = parentFold;
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }
}

