/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.HashMap;
import java.util.Map;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.folding.CurlyFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.XmlFoldParser;

public class FoldParserManager
implements SyntaxConstants {
    private Map foldParserMap = this.createFoldParserMap();
    private static final FoldParserManager INSTANCE = new FoldParserManager();

    private FoldParserManager() {
    }

    public void addFoldParserMapping(String syntaxStyle, FoldParser parser) {
        this.foldParserMap.put(syntaxStyle, parser);
    }

    private Map createFoldParserMap() {
        HashMap<String, FoldParser> map = new HashMap<String, FoldParser>();
        map.put("text/c", new CurlyFoldParser(true, false));
        map.put("text/cpp", new CurlyFoldParser(true, false));
        map.put("text/cs", new CurlyFoldParser(true, false));
        map.put("text/groovy", new CurlyFoldParser(true, false));
        map.put("text/java", new CurlyFoldParser(true, true));
        map.put("text/mxml", new XmlFoldParser());
        map.put("text/perl", new CurlyFoldParser(true, false));
        map.put("text/xml", new XmlFoldParser());
        return map;
    }

    public static FoldParserManager get() {
        return INSTANCE;
    }

    public FoldParser getFoldParser(String syntaxStyle) {
        return (FoldParser)this.foldParserMap.get(syntaxStyle);
    }
}

