/*
 * Decompiled with CFR 0.152.
 */
package com.fierydevs.calldetection.call;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import com.fierydevs.calldetection.CallSmsDetector;
import com.fierydevs.calldetection.call.CallListener;
import java.io.File;
import java.util.Date;

public class PhoneCallReceiver
extends BroadcastReceiver {
    private static int lastState = 0;
    private static Date callStartTime;
    private static boolean isIncoming;
    private static String savedNumber;
    private static CallListener mCallListener;

    public void onReceive(Context context, Intent intent) {
        CallSmsDetector.startOutgoingSms(context);
        if (intent.getAction().equals("android.intent.action.NEW_OUTGOING_CALL")) {
            savedNumber = intent.getExtras().getString("android.intent.extra.PHONE_NUMBER");
        } else {
            String stateStr = intent.getExtras().getString("state");
            String number = intent.getExtras().getString("incoming_number");
            int state = 0;
            if (stateStr.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                state = 0;
            } else if (stateStr.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                state = 2;
            } else if (stateStr.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                state = 1;
            }
            this.onCallStateChanged(context, state, number);
        }
    }

    public void onCallStateChanged(Context context, int state, String number) {
        if (lastState == state) {
            return;
        }
        String contactName = "";
        switch (state) {
            case 1: {
                isIncoming = true;
                callStartTime = new Date();
                savedNumber = number;
                contactName = CallSmsDetector.retrieveContactName(context, number);
                if (mCallListener == null) break;
                mCallListener.onIncomingCallStarted(context, number, callStartTime, contactName);
                break;
            }
            case 2: {
                if (lastState != 1) {
                    isIncoming = false;
                    callStartTime = new Date();
                    contactName = CallSmsDetector.retrieveContactName(context, savedNumber);
                    CallSmsDetector.startRecording(context);
                    if (mCallListener == null) break;
                    mCallListener.onOutgoingCallStarted(context, savedNumber, callStartTime, contactName);
                    break;
                }
                isIncoming = true;
                callStartTime = new Date();
                contactName = CallSmsDetector.retrieveContactName(context, savedNumber);
                CallSmsDetector.startRecording(context);
                if (mCallListener == null) break;
                mCallListener.onIncomingCallAnswered(context, savedNumber, callStartTime, contactName);
                break;
            }
            case 0: {
                if (lastState == 1) {
                    contactName = CallSmsDetector.retrieveContactName(context, savedNumber);
                    CallSmsDetector.stopRecording();
                    if (mCallListener == null) break;
                    mCallListener.onMissedCall(context, savedNumber, callStartTime, contactName);
                    break;
                }
                if (isIncoming) {
                    File recordedFile = CallSmsDetector.stopRecording();
                    if (mCallListener == null) break;
                    mCallListener.onIncomingCallEnded(context, savedNumber, callStartTime, new Date(), recordedFile);
                    break;
                }
                File recordedFile = CallSmsDetector.stopRecording();
                if (mCallListener == null) break;
                mCallListener.onOutgoingCallEnded(context, savedNumber, callStartTime, new Date(), recordedFile);
            }
        }
        lastState = state;
    }

    public static void setCallListener(CallListener callListener) {
        mCallListener = callListener;
    }
}

