/*
 * Decompiled with CFR 0.152.
 */
package com.fierydevs.calldetection;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.media.AudioManager;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.provider.ContactsContract;
import com.fierydevs.calldetection.DeviceAdminActivity;
import com.fierydevs.calldetection.PermissionsActivity;
import com.fierydevs.calldetection.sms.SmsObserver;
import java.io.File;
import java.io.IOException;

public class CallSmsDetector {
    private static MediaRecorder recorder;
    private static boolean recordstarted;
    private static File outputFile;

    public static void startOutgoingSms(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.registerContentObserver(Uri.parse((String)"content://sms"), true, (ContentObserver)new SmsObserver(new Handler(), context));
    }

    public static String retrieveContactName(Context context, String number) {
        ContentResolver cr = context.getContentResolver();
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)number));
        Cursor cursor = cr.query(uri, new String[]{"display_name"}, null, null, null);
        String contactName = "";
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                contactName = cursor.getString(cursor.getColumnIndex("display_name"));
            }
            if (!cursor.isClosed()) {
                cursor.close();
            }
        }
        return contactName;
    }

    public static void askForPermissions(Context context) {
        Intent intent = new Intent(context, PermissionsActivity.class);
        context.startActivity(intent);
    }

    public static boolean isMyServiceRunning(Context context, Class<?> aClass) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo serviceInfo : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!aClass.getName().equals(serviceInfo.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void startRecording(Context context) {
        File audiofile = null;
        File sampleDir = new File(Environment.getExternalStorageDirectory(), "/CallDetectionRecordings");
        if (!sampleDir.exists()) {
            sampleDir.mkdirs();
        }
        String file_name = "Record";
        try {
            outputFile = audiofile = File.createTempFile(file_name, ".amr", sampleDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String path = Environment.getExternalStorageDirectory().getAbsolutePath();
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        audioManager.setSpeakerphoneOn(true);
        audioManager.setStreamVolume(0, audioManager.getStreamMaxVolume(0), 0);
        recorder = new MediaRecorder();
        recorder.setAudioSource(7);
        recorder.setOutputFormat(3);
        recorder.setAudioEncoder(1);
        recorder.setOutputFile(audiofile.getAbsolutePath());
        try {
            recorder.prepare();
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
        }
        recorder.start();
        recordstarted = true;
    }

    public static File stopRecording() {
        if (recordstarted) {
            recorder.stop();
            recordstarted = false;
            return outputFile;
        }
        return null;
    }

    public static void callDeviceAdmin(Context context) {
        Intent intent = new Intent(context, DeviceAdminActivity.class);
        context.startActivity(intent);
    }

    static {
        recordstarted = false;
    }
}

