/*
 * Decompiled with CFR 0.152.
 */
package com.fierydevs.calldetection.sms;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import com.fierydevs.calldetection.CallSmsDetector;
import com.fierydevs.calldetection.sms.SmsSentListener;

public class SmsObserver
extends ContentObserver {
    Context context;
    private String lastSmsId;
    private static SmsSentListener mSentListener;

    public SmsObserver(Handler handler, Context context) {
        super(handler);
        this.context = context;
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        Uri uriSMSURI = Uri.parse((String)"content://sms/sent");
        Cursor cur = this.context.getContentResolver().query(uriSMSURI, null, null, null, null);
        if (cur != null) {
            cur.moveToNext();
            String id = cur.getString(cur.getColumnIndex("_id"));
            if (this.smsChecker(id)) {
                String address = cur.getString(cur.getColumnIndex("address"));
                String content = cur.getString(cur.getColumnIndex("body"));
                String date = cur.getString(cur.getColumnIndex("date"));
                String contactName = CallSmsDetector.retrieveContactName(this.context, address);
                mSentListener.onMessageSent(address, contactName, content, Long.parseLong(date));
                cur.close();
            }
        }
    }

    private boolean smsChecker(String sms) {
        boolean flagSMS = true;
        if (sms.equals(this.lastSmsId)) {
            flagSMS = false;
        } else {
            this.lastSmsId = sms;
        }
        return flagSMS;
    }

    public static void setSmsSentListener(SmsSentListener smsSentListener) {
        mSentListener = smsSentListener;
    }
}

