/*
 * Decompiled with CFR 0.152.
 */
package com.fiberlink.maas360.android.richtexteditor.colorpicker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.fiberlink.maas360.android.richtexteditor.R;
import com.fiberlink.maas360.android.richtexteditor.colorpicker.AmbilWarnaSquare;

public class AmbilWarnaDialog {
    final AlertDialog dialog;
    final OnAmbilWarnaListener listener;
    final ColorType type;
    final View viewHue;
    final AmbilWarnaSquare viewSatVal;
    final ImageView viewCursor;
    final TextView viewNewColorText;
    final ImageView viewTarget;
    final ImageView viewColorBlack;
    final ImageView viewColorGray;
    final ImageView viewColorLtGray;
    final ImageView viewColorWhite;
    final ImageView viewColorRed;
    final ImageView viewColorYellow;
    final ImageView viewColorBlue;
    final ImageView viewColorGreen;
    final ViewGroup viewContainer;
    final float[] currentColorHsv = new float[3];
    int currentDefaultColor = -1;
    int alpha;

    public AmbilWarnaDialog(Context context, int color, OnAmbilWarnaListener listener, ColorType type, String textPreviewString) {
        this.listener = listener;
        this.type = type;
        Color.colorToHSV((int)(color |= 0xFF000000), (float[])this.currentColorHsv);
        this.alpha = Color.alpha((int)color);
        final View view = LayoutInflater.from((Context)context).inflate(R.layout.ambilwarna_dialog, null);
        this.viewHue = view.findViewById(R.id.ambilwarna_viewHue);
        this.viewSatVal = (AmbilWarnaSquare)view.findViewById(R.id.ambilwarna_viewSatBri);
        this.viewCursor = (ImageView)view.findViewById(R.id.ambilwarna_cursor);
        this.viewNewColorText = (TextView)view.findViewById(R.id.ambilwarna_newColor_text);
        this.viewTarget = (ImageView)view.findViewById(R.id.ambilwarna_target);
        this.viewContainer = (ViewGroup)view.findViewById(R.id.ambilwarna_viewContainer);
        this.viewColorBlack = (ImageView)view.findViewById(R.id.color_black);
        this.viewColorGray = (ImageView)view.findViewById(R.id.color_gray);
        this.viewColorLtGray = (ImageView)view.findViewById(R.id.color_lt_gray);
        this.viewColorWhite = (ImageView)view.findViewById(R.id.color_white);
        this.viewColorRed = (ImageView)view.findViewById(R.id.color_red);
        this.viewColorYellow = (ImageView)view.findViewById(R.id.color_yellow);
        this.viewColorBlue = (ImageView)view.findViewById(R.id.color_blue);
        this.viewColorGreen = (ImageView)view.findViewById(R.id.color_green);
        this.viewSatVal.setHue(this.getHue());
        this.setSelectedColor(color);
        if (!TextUtils.isEmpty((CharSequence)textPreviewString)) {
            this.viewNewColorText.setText((CharSequence)textPreviewString);
        }
        this.viewColorBlack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -16777216;
                AmbilWarnaDialog.this.setSelectedColor(-16777216);
            }
        });
        this.viewColorGray.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -7829368;
                AmbilWarnaDialog.this.setSelectedColor(-7829368);
            }
        });
        this.viewColorLtGray.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -3355444;
                AmbilWarnaDialog.this.setSelectedColor(-3355444);
            }
        });
        this.viewColorWhite.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -1;
                AmbilWarnaDialog.this.setSelectedColor(-1);
            }
        });
        this.viewColorRed.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -65536;
                AmbilWarnaDialog.this.setSelectedColor(-65536);
            }
        });
        this.viewColorYellow.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -256;
                AmbilWarnaDialog.this.setSelectedColor(-256);
            }
        });
        this.viewColorBlue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -16776961;
                AmbilWarnaDialog.this.setSelectedColor(-16776961);
            }
        });
        this.viewColorGreen.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AmbilWarnaDialog.this.currentDefaultColor = -16711936;
                AmbilWarnaDialog.this.setSelectedColor(-16711936);
            }
        });
        this.viewHue.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 2 || event.getAction() == 0 || event.getAction() == 1) {
                    float hue;
                    AmbilWarnaDialog.this.currentDefaultColor = -1;
                    float y = event.getY();
                    if (y < 0.0f) {
                        y = 0.0f;
                    }
                    if (y > (float)AmbilWarnaDialog.this.viewHue.getMeasuredHeight()) {
                        y = (float)AmbilWarnaDialog.this.viewHue.getMeasuredHeight() - 0.001f;
                    }
                    if ((hue = 360.0f - 360.0f / (float)AmbilWarnaDialog.this.viewHue.getMeasuredHeight() * y) == 360.0f) {
                        hue = 0.0f;
                    }
                    AmbilWarnaDialog.this.setHue(hue);
                    AmbilWarnaDialog.this.viewSatVal.setHue(AmbilWarnaDialog.this.getHue());
                    AmbilWarnaDialog.this.moveCursor();
                    AmbilWarnaDialog.this.setSelectedColor(AmbilWarnaDialog.this.getColor());
                    return true;
                }
                return false;
            }
        });
        this.viewSatVal.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 2 || event.getAction() == 0 || event.getAction() == 1) {
                    AmbilWarnaDialog.this.currentDefaultColor = -1;
                    float x = event.getX();
                    float y = event.getY();
                    if (x < 0.0f) {
                        x = 0.0f;
                    }
                    if (x > (float)AmbilWarnaDialog.this.viewSatVal.getMeasuredWidth()) {
                        x = AmbilWarnaDialog.this.viewSatVal.getMeasuredWidth();
                    }
                    if (y < 0.0f) {
                        y = 0.0f;
                    }
                    if (y > (float)AmbilWarnaDialog.this.viewSatVal.getMeasuredHeight()) {
                        y = AmbilWarnaDialog.this.viewSatVal.getMeasuredHeight();
                    }
                    AmbilWarnaDialog.this.setSat(1.0f / (float)AmbilWarnaDialog.this.viewSatVal.getMeasuredWidth() * x);
                    AmbilWarnaDialog.this.setVal(1.0f - 1.0f / (float)AmbilWarnaDialog.this.viewSatVal.getMeasuredHeight() * y);
                    AmbilWarnaDialog.this.moveTarget();
                    AmbilWarnaDialog.this.setSelectedColor(AmbilWarnaDialog.this.getColor());
                    return true;
                }
                return false;
            }
        });
        this.dialog = new AlertDialog.Builder(context).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (AmbilWarnaDialog.this.listener != null) {
                    AmbilWarnaDialog.this.listener.onOk(AmbilWarnaDialog.this, AmbilWarnaDialog.this.getSelectedColor());
                }
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (AmbilWarnaDialog.this.listener != null) {
                    AmbilWarnaDialog.this.listener.onCancel(AmbilWarnaDialog.this);
                }
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface paramDialogInterface) {
                if (AmbilWarnaDialog.this.listener != null) {
                    AmbilWarnaDialog.this.listener.onCancel(AmbilWarnaDialog.this);
                }
            }
        }).create();
        this.dialog.setView(view, 0, 0, 0, 0);
        ViewTreeObserver vto = view.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                AmbilWarnaDialog.this.moveCursor();
                AmbilWarnaDialog.this.moveTarget();
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void setSelectedColor(int color) {
        if (this.type == ColorType.TEXT) {
            this.viewNewColorText.setTextColor(color);
        } else {
            this.viewNewColorText.setBackgroundColor(color);
        }
    }

    protected void moveCursor() {
        float y = (float)this.viewHue.getMeasuredHeight() - this.getHue() * (float)this.viewHue.getMeasuredHeight() / 360.0f;
        if (y == (float)this.viewHue.getMeasuredHeight()) {
            y = 0.0f;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.viewCursor.getLayoutParams();
        layoutParams.leftMargin = (int)((double)this.viewHue.getLeft() - Math.floor(this.viewCursor.getMeasuredWidth() / 2) - (double)this.viewContainer.getPaddingLeft());
        layoutParams.topMargin = (int)((double)((float)this.viewHue.getTop() + y) - Math.floor(this.viewCursor.getMeasuredHeight() / 2) - (double)this.viewContainer.getPaddingTop());
        this.viewCursor.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void moveTarget() {
        float x = this.getSat() * (float)this.viewSatVal.getMeasuredWidth();
        float y = (1.0f - this.getVal()) * (float)this.viewSatVal.getMeasuredHeight();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.viewTarget.getLayoutParams();
        layoutParams.leftMargin = (int)((double)((float)this.viewSatVal.getLeft() + x) - Math.floor(this.viewTarget.getMeasuredWidth() / 2) - (double)this.viewContainer.getPaddingLeft());
        layoutParams.topMargin = (int)((double)((float)this.viewSatVal.getTop() + y) - Math.floor(this.viewTarget.getMeasuredHeight() / 2) - (double)this.viewContainer.getPaddingTop());
        this.viewTarget.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private int getSelectedColor() {
        if (this.currentDefaultColor != -1) {
            return this.currentDefaultColor;
        }
        return this.getColor();
    }

    private int getColor() {
        int argb = Color.HSVToColor((float[])this.currentColorHsv);
        return this.alpha << 24 | argb & 0xFFFFFF;
    }

    private float getHue() {
        return this.currentColorHsv[0];
    }

    private float getSat() {
        return this.currentColorHsv[1];
    }

    private float getVal() {
        return this.currentColorHsv[2];
    }

    private void setHue(float hue) {
        this.currentColorHsv[0] = hue;
    }

    private void setSat(float sat) {
        this.currentColorHsv[1] = sat;
    }

    private void setVal(float val) {
        this.currentColorHsv[2] = val;
    }

    public void show() {
        this.dialog.show();
    }

    public AlertDialog getDialog() {
        return this.dialog;
    }

    public static interface OnAmbilWarnaListener {
        public void onCancel(AmbilWarnaDialog var1);

        public void onOk(AmbilWarnaDialog var1, int var2);
    }

    public static enum ColorType {
        TEXT,
        BACKGROUND;

    }
}

