/*
 * Decompiled with CFR 0.152.
 */
package com.fiberlink.maas360.android.richtexteditor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class RichWebView
extends WebView {
    private static final String SETUP_HTML = "file:///android_asset/editor.html";
    private static final String CALLBACK_SEPARATOR = "~!~!~!";
    private static final String JAVA_SCRIPT_INTERFACE_NAME = "JSInterface";
    private boolean isReady;
    private String mContents;
    private OnStateChangeListener mStateChangeListener;
    private AfterInitialLoadListener mLoadListener;

    public RichWebView(Context context) {
        this(context, null);
    }

    public RichWebView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public RichWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.addJavascriptInterface(new EditorJavaScriptInterface(), JAVA_SCRIPT_INTERFACE_NAME);
        this.setWebChromeClient(new WebChromeClient());
        this.setWebViewClient(this.createWebviewClient());
        if (Build.VERSION.SDK_INT >= 19 && 0 != (context.getApplicationInfo().flags &= 2)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.loadUrl(SETUP_HTML);
        this.applyAttributes(context, attrs);
    }

    protected EditorWebViewClient createWebviewClient() {
        return new EditorWebViewClient();
    }

    public void setStateChangeListener(OnStateChangeListener listener) {
        this.mStateChangeListener = listener;
    }

    public void setOnInitialLoadListener(AfterInitialLoadListener listener) {
        this.mLoadListener = listener;
    }

    private void handleCallback(String text) {
        String[] stringParts = text.split(CALLBACK_SEPARATOR);
        String allowedString = "";
        String enabledString = "";
        if (stringParts.length > 0) {
            allowedString = stringParts[0];
            if (stringParts.length > 1) {
                enabledString = stringParts[1];
                if (stringParts.length > 2) {
                    this.mContents = stringParts[2];
                }
            }
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type type : Type.values()) {
            if (TextUtils.indexOf((CharSequence)allowedString, (CharSequence)type.name()) == -1) continue;
            types.add(type);
        }
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(allowedString, types, StateType.ALLOW);
        }
        types = new ArrayList();
        for (Type type : Type.values()) {
            if (TextUtils.indexOf((CharSequence)enabledString, (CharSequence)type.name()) == -1) continue;
            types.add(type);
        }
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(enabledString, types, StateType.ENABLE);
        }
    }

    private void applyAttributes(Context context, AttributeSet attrs) {
        int[] attrsArray = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrsArray);
        int gravity = ta.getInt(0, -1);
        switch (gravity) {
            case 3: {
                this.exec("javascript:RE.setTextAlign(\"left\")");
                break;
            }
            case 5: {
                this.exec("javascript:RE.setTextAlign(\"right\")");
                break;
            }
            case 48: {
                this.exec("javascript:RE.setVerticalAlign(\"top\")");
                break;
            }
            case 80: {
                this.exec("javascript:RE.setVerticalAlign(\"bottom\")");
                break;
            }
            case 16: {
                this.exec("javascript:RE.setVerticalAlign(\"middle\")");
                break;
            }
            case 1: {
                this.exec("javascript:RE.setTextAlign(\"center\")");
                break;
            }
            case 17: {
                this.exec("javascript:RE.setVerticalAlign(\"middle\")");
                this.exec("javascript:RE.setTextAlign(\"center\")");
            }
        }
        ta.recycle();
    }

    public void setHtml(String contents) {
        if (contents == null) {
            contents = "";
        }
        this.mContents = contents;
        this.execSetHtml();
    }

    private void execSetHtml() {
        try {
            if (this.isReady) {
                this.load("javascript:RE.setHtml('" + URLEncoder.encode(this.mContents, "UTF-8") + "');");
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        RichWebView.this.execSetHtml();
                    }
                }, 100L);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getHtml() {
        if (this.mContents == null) {
            return "";
        }
        return this.mContents;
    }

    public void setEditorHeight(int px) {
        this.exec("javascript:RE.setHeight('" + px + "px');");
    }

    public void setEditorFontColor(int color2) {
        String hex = this.convertHexColorString(color2);
        this.exec("javascript:RE.setBaseTextColor('" + hex + "');");
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.exec("javascript:RE.setPadding('" + left + "px', '" + top + "px', '" + right + "px', '" + bottom + "px');");
    }

    public void setPlaceholder(String placeholder) {
        this.exec("javascript:RE.setPlaceholder('" + placeholder + "');");
    }

    public void setBold() {
        this.exec("javascript:RE.setBold();");
    }

    public void setItalic() {
        this.exec("javascript:RE.setItalic();");
    }

    public void setUnderline() {
        this.exec("javascript:RE.setUnderline();");
    }

    public void setStrikethrough() {
        this.exec("javascript:RE.setStrikeThrough();");
    }

    public void setTextColor(int color2) {
        this.exec("javascript:RE.prepareInsert();");
        String hex = this.convertHexColorString(color2);
        this.exec("javascript:RE.setTextColor('" + hex + "');");
    }

    public void setTextBackgroundColor(int color2) {
        this.exec("javascript:RE.prepareInsert();");
        String hex = this.convertHexColorString(color2);
        this.exec("javascript:RE.setTextBackgroundColor('" + hex + "');");
    }

    public void setTextAndBackgroundColor(int textColor, int textBackgroundColor) {
        this.exec("javascript:RE.prepareInsert();");
        String hex1 = this.convertHexColorString(textColor);
        String hex2 = this.convertHexColorString(textBackgroundColor);
        this.exec("javascript:RE.setTextAndBackgroundColor('" + hex1 + "','" + hex2 + "');");
    }

    private String convertHexColorString(int color2) {
        return String.format("#%06X", 0xFFFFFF & color2);
    }

    protected void exec(final String trigger) {
        if (this.isReady) {
            this.load(trigger);
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    RichWebView.this.exec(trigger);
                }
            }, 100L);
        }
    }

    private void load(String trigger) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.evaluateJavascript(trigger, null);
        } else {
            this.loadUrl(trigger);
        }
    }

    public class EditorJavaScriptInterface {
        @JavascriptInterface
        public void callback(String callbackString) {
            if (TextUtils.isEmpty((CharSequence)callbackString)) {
                return;
            }
            try {
                String decodedString = URLDecoder.decode(callbackString, "UTF-8");
                RichWebView.this.handleCallback(decodedString);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public class EditorWebViewClient
    extends WebViewClient {
        public void onPageFinished(WebView view, String url) {
            RichWebView.this.isReady = url.equalsIgnoreCase(RichWebView.SETUP_HTML);
            if (RichWebView.this.mLoadListener != null) {
                RichWebView.this.mLoadListener.onAfterInitialLoad(RichWebView.this.isReady);
            }
        }
    }

    public static interface AfterInitialLoadListener {
        public void onAfterInitialLoad(boolean var1);
    }

    public static interface OnStateChangeListener {
        public void onStateChanged(String var1, List<Type> var2, StateType var3);
    }

    public static enum StateType {
        ENABLE,
        ALLOW;

    }

    public static enum Type {
        BOLD,
        ITALIC,
        UNDERLINE,
        STRIKETHROUGH,
        FORECOLOR,
        HILITECOLOR;

    }
}

