/*
 * Decompiled with CFR 0.152.
 */
package com.fiberlink.maas360.android.richtexteditor;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import com.fiberlink.maas360.android.richtexteditor.R;
import com.fiberlink.maas360.android.richtexteditor.RichTextActions;
import com.fiberlink.maas360.android.richtexteditor.RichWebView;
import com.fiberlink.maas360.android.richtexteditor.colorpicker.AmbilWarnaDialog;
import java.util.List;

public class RichEditText
extends RelativeLayout {
    private Context mContext;
    private LayoutInflater mInflater;
    private Handler mHandler;
    private String mPreviewText;
    private RichWebView mEditor;
    private RichTextActions mActions;
    private ChangeListener mListener;
    private ImageButton mBoldButton;
    private ImageButton mItalicButton;
    private ImageButton mUnderlineButton;
    private ImageButton mStrikethroughButton;
    private ImageButton mTextColorButton;
    private ImageButton mTextBackgroundColorButton;
    private boolean mBoldEnabled;
    private boolean mBoldAllowed;
    private boolean mItalicEnabled;
    private boolean mItalicAllowed;
    private boolean mUnderlineEnabled;
    private boolean mUnderlineAllowed;
    private boolean mStrikethroughEnabled;
    private boolean mStrikethroughAllowed;
    private boolean mTextColorAllowed;
    private boolean mBackgroundColorAllowed;
    private int mSelectedTextColor = -1;
    private int mSelectedTextBackgroundColor = -1;

    public RichEditText(Context context) {
        super(context);
        this.setupView(context);
    }

    public RichEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context);
    }

    public RichEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView(context);
    }

    @TargetApi(value=21)
    public RichEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView(context);
    }

    public void setRichTextActionsView(RichTextActions actionsView) {
        this.mActions = actionsView;
        this.setupActions();
    }

    public void setPreviewText(String previewText) {
        this.mPreviewText = previewText;
    }

    public void setHtml(String html) {
        if (html == null) {
            return;
        }
        this.mEditor.setHtml(html);
    }

    public String getHtml() {
        return this.mEditor.getHtml();
    }

    public void setHint(String hint) {
        if (!TextUtils.isEmpty((CharSequence)hint) && this.mEditor != null) {
            this.mEditor.setPlaceholder(hint);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.mListener = listener;
    }

    public void removeChangeListener() {
        this.mListener = null;
    }

    private void setupView(Context context) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mInflater.inflate(R.layout.rich_edit_text, (ViewGroup)this, true);
        this.mHandler = new Handler();
        this.setupEditor();
    }

    private void setupEditor() {
        this.mEditor = (RichWebView)this.findViewById(R.id.editor);
        this.mEditor.setEditorFontColor(-16777216);
        this.mEditor.setPadding(16, 16, 16, 16);
        this.mEditor.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    RichEditText.this.mActions.setVisibility(8);
                    RichEditText.this.blockAndDisableAllButtons();
                } else {
                    RichEditText.this.mActions.setVisibility(0);
                }
            }
        });
        this.mEditor.setStateChangeListener(new RichWebView.OnStateChangeListener(){

            @Override
            public void onStateChanged(final String text, final List<RichWebView.Type> types, final RichWebView.StateType stateType) {
                RichEditText.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        RichEditText.this.handleStateChange(text, types, stateType);
                    }
                });
            }
        });
    }

    private void handleStateChange(String text, List<RichWebView.Type> types, RichWebView.StateType stateType) {
        this.notifyChangeListener();
        this.mSelectedTextColor = -1;
        this.mSelectedTextBackgroundColor = -1;
        switch (stateType) {
            case ALLOW: {
                if (types.contains((Object)RichWebView.Type.BOLD)) {
                    this.allowBoldButton();
                } else {
                    this.blockBoldButton();
                }
                if (types.contains((Object)RichWebView.Type.ITALIC)) {
                    this.allowItalicButton();
                } else {
                    this.blockItalicButton();
                }
                if (types.contains((Object)RichWebView.Type.UNDERLINE)) {
                    this.allowUnderlineButton();
                } else {
                    this.blockUnderlineButton();
                }
                if (types.contains((Object)RichWebView.Type.STRIKETHROUGH)) {
                    this.allowStrikethroughButton();
                } else {
                    this.blockStrikethroughButton();
                }
                if (types.contains((Object)RichWebView.Type.FORECOLOR)) {
                    this.allowTextColorButton();
                } else {
                    this.blockTextColorButton();
                }
                if (types.contains((Object)RichWebView.Type.HILITECOLOR)) {
                    this.allowBackgroundColorButton();
                    break;
                }
                this.blockTextBackgroundColorButton();
                break;
            }
            case ENABLE: {
                if (types.contains((Object)RichWebView.Type.BOLD)) {
                    this.enableBoldButton();
                } else {
                    this.disableBoldButton();
                }
                if (types.contains((Object)RichWebView.Type.ITALIC)) {
                    this.enableItalicButton();
                } else {
                    this.disableItalicButton();
                }
                if (types.contains((Object)RichWebView.Type.UNDERLINE)) {
                    this.enableUnderlineButton();
                } else {
                    this.disableUnderlineButton();
                }
                if (types.contains((Object)RichWebView.Type.STRIKETHROUGH)) {
                    this.enableStrikethroughButton();
                    break;
                }
                this.disableStrikethroughButton();
            }
        }
    }

    private void setupActions() {
        this.mActions.setVisibility(8);
        this.setupBoldButton();
        this.setupItalicButton();
        this.setupUnderlineButton();
        this.setupStrikethroughButton();
        this.setupTextColorButton();
        this.setupTextBackgroundColorButton();
    }

    private void notifyChangeListener() {
        if (this.mListener != null) {
            this.mListener.onChange();
        }
    }

    private void blockAndDisableAllButtons() {
        this.blockBoldButton();
        this.disableBoldButton();
        this.blockItalicButton();
        this.disableItalicButton();
        this.blockUnderlineButton();
        this.disableUnderlineButton();
        this.blockStrikethroughButton();
        this.disableStrikethroughButton();
        this.blockTextColorButton();
        this.blockTextBackgroundColorButton();
    }

    private void setupBoldButton() {
        this.mBoldButton = (ImageButton)this.mActions.findViewById(R.id.action_bold);
        this.blockBoldButton();
        this.disableBoldButton();
        this.mBoldButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RichEditText.this.toggleBoldButton();
                RichEditText.this.mEditor.setBold();
            }
        });
    }

    private void setupItalicButton() {
        this.mItalicButton = (ImageButton)this.mActions.findViewById(R.id.action_italic);
        this.blockItalicButton();
        this.disableItalicButton();
        this.mItalicButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RichEditText.this.toggleItalicButton();
                RichEditText.this.mEditor.setItalic();
            }
        });
    }

    private void setupUnderlineButton() {
        this.mUnderlineButton = (ImageButton)this.mActions.findViewById(R.id.action_underline);
        this.blockUnderlineButton();
        this.disableUnderlineButton();
        this.mUnderlineButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RichEditText.this.toggleUnderlineButton();
                RichEditText.this.mEditor.setUnderline();
            }
        });
    }

    private void setupStrikethroughButton() {
        this.mStrikethroughButton = (ImageButton)this.mActions.findViewById(R.id.action_strikethrough);
        this.blockStrikethroughButton();
        this.disableStrikethroughButton();
        this.mStrikethroughButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RichEditText.this.toggleStrikethroughButton();
                RichEditText.this.mEditor.setStrikethrough();
            }
        });
    }

    private void setupTextColorButton() {
        this.mTextColorButton = (ImageButton)this.mActions.findViewById(R.id.action_txt_color);
        this.blockTextColorButton();
        this.mTextColorButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RichEditText.this.mTextColorAllowed) {
                    RichEditText.this.showTextColorChooser();
                }
            }
        });
    }

    private void setupTextBackgroundColorButton() {
        this.mTextBackgroundColorButton = (ImageButton)this.mActions.findViewById(R.id.action_txt_bg_color);
        this.blockTextBackgroundColorButton();
        this.mTextBackgroundColorButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RichEditText.this.mBackgroundColorAllowed) {
                    RichEditText.this.showTextBackgroundColorChooser();
                }
            }
        });
    }

    private void showTextColorChooser() {
        AmbilWarnaDialog dialog = new AmbilWarnaDialog(this.getContext(), -16777216, new AmbilWarnaDialog.OnAmbilWarnaListener(){

            @Override
            public void onCancel(AmbilWarnaDialog dialog) {
            }

            @Override
            public void onOk(AmbilWarnaDialog dialog, int color2) {
                RichEditText.this.mSelectedTextColor = color2;
                if (RichEditText.this.mSelectedTextBackgroundColor == -1) {
                    RichEditText.this.mEditor.setTextColor(RichEditText.this.mSelectedTextColor);
                } else {
                    RichEditText.this.mEditor.setTextAndBackgroundColor(RichEditText.this.mSelectedTextColor, RichEditText.this.mSelectedTextBackgroundColor);
                }
            }
        }, AmbilWarnaDialog.ColorType.TEXT, this.mPreviewText);
        dialog.show();
    }

    private void showTextBackgroundColorChooser() {
        AmbilWarnaDialog dialog = new AmbilWarnaDialog(this.getContext(), -1, new AmbilWarnaDialog.OnAmbilWarnaListener(){

            @Override
            public void onCancel(AmbilWarnaDialog dialog) {
            }

            @Override
            public void onOk(AmbilWarnaDialog dialog, int color2) {
                RichEditText.this.mSelectedTextBackgroundColor = color2;
                if (RichEditText.this.mSelectedTextColor == -1) {
                    RichEditText.this.mEditor.setTextBackgroundColor(RichEditText.this.mSelectedTextBackgroundColor);
                } else {
                    RichEditText.this.mEditor.setTextAndBackgroundColor(RichEditText.this.mSelectedTextColor, RichEditText.this.mSelectedTextBackgroundColor);
                }
            }
        }, AmbilWarnaDialog.ColorType.BACKGROUND, this.mPreviewText);
        dialog.show();
    }

    private void allowBoldButton() {
        this.mBoldAllowed = true;
        this.mBoldButton.setImageDrawable(this.getResources().getDrawable(R.drawable.bold_48));
    }

    private void blockBoldButton() {
        this.mBoldAllowed = false;
        this.mBoldButton.setImageDrawable(this.getResources().getDrawable(R.drawable.bold_grey_48));
    }

    private void toggleBoldButton() {
        if (this.mBoldAllowed) {
            if (this.mBoldEnabled) {
                this.disableBoldButton();
            } else {
                this.enableBoldButton();
            }
        }
    }

    private void enableBoldButton() {
        this.mBoldEnabled = true;
        if (this.mBoldAllowed) {
            this.mBoldButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndAllowedButtonBackground));
        } else {
            this.mBoldButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndNotAllowedButtonBackground));
        }
    }

    private void disableBoldButton() {
        this.mBoldEnabled = false;
        this.mBoldButton.setBackgroundColor(this.getResources().getColor(R.color.colorDisabledButtonBackground));
    }

    private void allowItalicButton() {
        this.mItalicAllowed = true;
        this.mItalicButton.setImageDrawable(this.getResources().getDrawable(R.drawable.italic_48));
    }

    private void blockItalicButton() {
        this.mItalicAllowed = false;
        this.mItalicButton.setImageDrawable(this.getResources().getDrawable(R.drawable.italic_grey_48));
    }

    private void toggleItalicButton() {
        if (this.mItalicAllowed) {
            if (this.mItalicEnabled) {
                this.disableItalicButton();
            } else {
                this.enableItalicButton();
            }
        }
    }

    private void enableItalicButton() {
        this.mItalicEnabled = true;
        if (this.mItalicAllowed) {
            this.mItalicButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndAllowedButtonBackground));
        } else {
            this.mItalicButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndNotAllowedButtonBackground));
        }
    }

    private void disableItalicButton() {
        this.mItalicEnabled = false;
        this.mItalicButton.setBackgroundColor(this.getResources().getColor(R.color.colorDisabledButtonBackground));
    }

    private void allowUnderlineButton() {
        this.mUnderlineAllowed = true;
        this.mUnderlineButton.setImageDrawable(this.getResources().getDrawable(R.drawable.underline_48));
    }

    private void blockUnderlineButton() {
        this.mUnderlineAllowed = false;
        this.mUnderlineButton.setImageDrawable(this.getResources().getDrawable(R.drawable.underline_grey_48));
    }

    private void toggleUnderlineButton() {
        if (this.mUnderlineAllowed) {
            if (this.mUnderlineEnabled) {
                this.disableUnderlineButton();
            } else {
                this.enableUnderlineButton();
            }
        }
    }

    private void enableUnderlineButton() {
        this.mUnderlineEnabled = true;
        if (this.mUnderlineAllowed) {
            this.mUnderlineButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndAllowedButtonBackground));
        } else {
            this.mUnderlineButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndNotAllowedButtonBackground));
        }
    }

    private void disableUnderlineButton() {
        this.mUnderlineEnabled = false;
        this.mUnderlineButton.setBackgroundColor(this.getResources().getColor(R.color.colorDisabledButtonBackground));
    }

    private void allowStrikethroughButton() {
        this.mStrikethroughAllowed = true;
        this.mStrikethroughButton.setImageDrawable(this.getResources().getDrawable(R.drawable.strikethrough_48));
    }

    private void blockStrikethroughButton() {
        this.mStrikethroughAllowed = false;
        this.mStrikethroughButton.setImageDrawable(this.getResources().getDrawable(R.drawable.strikethrough_grey_48));
    }

    private void toggleStrikethroughButton() {
        if (this.mStrikethroughAllowed) {
            if (this.mStrikethroughEnabled) {
                this.disableStrikethroughButton();
            } else {
                this.enableStrikethroughButton();
            }
        }
    }

    private void enableStrikethroughButton() {
        this.mStrikethroughEnabled = true;
        if (this.mStrikethroughAllowed) {
            this.mStrikethroughButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndAllowedButtonBackground));
        } else {
            this.mStrikethroughButton.setBackgroundColor(this.getResources().getColor(R.color.colorEnabledAndNotAllowedButtonBackground));
        }
    }

    private void disableStrikethroughButton() {
        this.mStrikethroughEnabled = false;
        this.mStrikethroughButton.setBackgroundColor(this.getResources().getColor(R.color.colorDisabledButtonBackground));
    }

    private void allowTextColorButton() {
        this.mTextColorAllowed = true;
        this.mTextColorButton.setImageDrawable(this.getResources().getDrawable(R.drawable.fore_color_48));
    }

    private void blockTextColorButton() {
        this.mTextColorAllowed = false;
        this.mTextColorButton.setImageDrawable(this.getResources().getDrawable(R.drawable.fore_color_grey_48));
    }

    private void allowBackgroundColorButton() {
        this.mBackgroundColorAllowed = true;
        this.mTextBackgroundColorButton.setImageDrawable(this.getResources().getDrawable(R.drawable.hilite_color_48));
    }

    private void blockTextBackgroundColorButton() {
        this.mBackgroundColorAllowed = false;
        this.mTextBackgroundColorButton.setImageDrawable(this.getResources().getDrawable(R.drawable.hilite_color_grey_48));
    }

    public static interface ChangeListener {
        public void onChange();
    }
}

