/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.listener.TransMessageListener;
import com.fhs.trans.service.impl.SimpleTransService;
import com.fhs.trans.service.impl.TransService;
import com.fhs.trans.vo.BasicVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class RpcTransService
extends SimpleTransService {
    private static final Logger log = LoggerFactory.getLogger(RpcTransService.class);
    public static final Logger LOGGER = LoggerFactory.getLogger(SimpleTransService.class);
    private RestTemplate restTemplate;
    @Value(value="${easy-trans.is-enable-cloud:true}")
    private Boolean isEnableCloud;
    private Map<String, String> serviceContextPathConfigMap = new HashMap<String, String>();

    public void addContextPath(String serviceName, String contextPath) {
        this.serviceContextPathConfigMap.put(serviceName, contextPath);
    }

    @Override
    public List<? extends VO> findByIds(List ids, Trans tempTrans, Set<String> targetFields) {
        if (!this.isEnableCloud.booleanValue()) {
            try {
                Class<?> clazz = Class.forName(tempTrans.targetClassName());
                return this.findByIds(() -> this.transDiver.findByIds(ids, clazz, tempTrans.uniqueField(), targetFields), tempTrans.dataSource());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u7c7b\u627e\u4e0d\u5230\uff1a" + tempTrans.targetClassName());
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        paramMap.put("uniqueField", tempTrans.uniqueField());
        if (targetFields != null) {
            paramMap.put("targetFields", targetFields);
        }
        try {
            String respJson = (String)this.restTemplate.postForObject("http://" + tempTrans.serviceName() + this.getContextPath(tempTrans) + "/easyTrans/proxy/" + tempTrans.targetClassName() + "/findByIds", paramMap, String.class, new Object[0]);
            return JSONArray.parseArray((String)respJson, BasicVO.class);
        }
        catch (Exception e) {
            log.error("trans service\u6267\u884cRPC Trans \u8fdc\u7a0b\u8c03\u7528\u9519\u8bef:" + tempTrans.serviceName(), (Throwable)e);
            return new ArrayList();
        }
    }

    @Override
    public VO findById(Object id, Trans tempTrans) {
        if (!this.isEnableCloud.booleanValue()) {
            try {
                Class<?> clazz = Class.forName(tempTrans.targetClassName());
                return this.findById(() -> this.transDiver.findById((Serializable)id, clazz, tempTrans.uniqueField(), new HashSet<String>(Arrays.asList(tempTrans.fields()))), tempTrans.dataSource());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u7c7b\u627e\u4e0d\u5230\uff1a" + tempTrans.targetClassName());
            }
        }
        try {
            return (VO)this.restTemplate.getForObject("http://" + tempTrans.serviceName() + this.getContextPath(tempTrans) + "/easyTrans/proxy/" + tempTrans.targetClassName() + "/findById/" + id + "?uniqueField=" + tempTrans.uniqueField() + "&targetFields=" + Arrays.stream(tempTrans.fields()).collect(Collectors.joining(",")), BasicVO.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("trans service\u6267\u884cRPC Trans \u8fdc\u7a0b\u8c03\u7528\u9519\u8bef:" + tempTrans.serviceName(), (Throwable)e);
            return null;
        }
    }

    private String getContextPath(Trans tempTrans) {
        if (this.serviceContextPathConfigMap.containsKey(tempTrans.serviceName())) {
            return this.serviceContextPathConfigMap.get(tempTrans.serviceName());
        }
        return StringUtil.isEmpty(tempTrans.serviceContextPath()) ? "" : tempTrans.serviceContextPath();
    }

    @Override
    public Object getUniqueKey(VO vo, Trans tempTrans) {
        if (!this.isEnableCloud.booleanValue()) {
            return super.getUniqueKey(vo, tempTrans);
        }
        if (StringUtil.isEmpty(tempTrans.uniqueField())) {
            return vo.getPkey();
        }
        BasicVO basicVO = (BasicVO)vo;
        return basicVO.getObjContentMap().get(tempTrans.uniqueField());
    }

    @Override
    protected Map<String, Object> createTempTransCacheMap(VO po, Trans trans, Set<String> targetFields) {
        if (!this.isEnableCloud.booleanValue()) {
            return super.createTempTransCacheMap(po, trans, targetFields);
        }
        String fielVal = null;
        LinkedHashMap<String, Object> tempCacheTransMap = new LinkedHashMap<String, Object>();
        if (po == null) {
            return tempCacheTransMap;
        }
        BasicVO basicVO = (BasicVO)po;
        List<String> tempFields = targetFields != null ? new ArrayList<String>(targetFields) : Arrays.asList(trans.fields());
        for (String field : tempFields) {
            fielVal = ConverterUtils.toString(basicVO.getObjContentMap().get(field));
            tempCacheTransMap.put(field, fielVal);
        }
        if (this.transCacheSettMap.containsKey(trans.targetClassName())) {
            SimpleTransService.TransCacheSett cacheSett = (SimpleTransService.TransCacheSett)this.transCacheSettMap.get(trans.targetClassName());
            this.put2GlobalCache(basicVO.getObjContentMap(), cacheSett.isAccess(), cacheSett.getCacheSeconds(), cacheSett.getMaxCache(), po.getPkey(), trans.targetClassName(), "rpc");
        }
        return tempCacheTransMap;
    }

    @Override
    public void setTransCache(Object type, SimpleTransService.TransCacheSett cacheSett) {
        this.transCacheSettMap.put(ConverterUtils.toString(type), cacheSett);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("rpc", this);
        TransMessageListener.regTransRefresher("rpc", this::onMessage);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public Boolean getIsEnableCloud() {
        return this.isEnableCloud;
    }

    public Map<String, String> getServiceContextPathConfigMap() {
        return this.serviceContextPathConfigMap;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setIsEnableCloud(Boolean isEnableCloud) {
        this.isEnableCloud = isEnableCloud;
    }

    public void setServiceContextPathConfigMap(Map<String, String> serviceContextPathConfigMap) {
        this.serviceContextPathConfigMap = serviceContextPathConfigMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcTransService)) {
            return false;
        }
        RpcTransService other = (RpcTransService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isEnableCloud = this.getIsEnableCloud();
        Boolean other$isEnableCloud = other.getIsEnableCloud();
        if (this$isEnableCloud == null ? other$isEnableCloud != null : !((Object)this$isEnableCloud).equals(other$isEnableCloud)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        Map<String, String> this$serviceContextPathConfigMap = this.getServiceContextPathConfigMap();
        Map<String, String> other$serviceContextPathConfigMap = other.getServiceContextPathConfigMap();
        return !(this$serviceContextPathConfigMap == null ? other$serviceContextPathConfigMap != null : !((Object)this$serviceContextPathConfigMap).equals(other$serviceContextPathConfigMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpcTransService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isEnableCloud = this.getIsEnableCloud();
        result = result * 59 + ($isEnableCloud == null ? 43 : ((Object)$isEnableCloud).hashCode());
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        Map<String, String> $serviceContextPathConfigMap = this.getServiceContextPathConfigMap();
        result = result * 59 + ($serviceContextPathConfigMap == null ? 43 : ((Object)$serviceContextPathConfigMap).hashCode());
        return result;
    }

    public String toString() {
        return "RpcTransService(restTemplate=" + this.getRestTemplate() + ", isEnableCloud=" + this.getIsEnableCloud() + ", serviceContextPathConfigMap=" + this.getServiceContextPathConfigMap() + ")";
    }
}

