/*
 * Decompiled with CFR 0.152.
 */
package com.fenchtose.tooltip;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.fenchtose.tooltip.AnimationUtils;
import com.fenchtose.tooltip.TooltipAnimation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"ViewConstructor"})
public class Tooltip
extends ViewGroup {
    private static final String TAG = "Tooltip";
    public static final int NO_AUTO_CANCEL = 0;
    private boolean debug = false;
    private View contentView;
    private View anchorView;
    private int[] anchorLocation = new int[2];
    private int[] holderLocation = new int[2];
    private int position;
    private boolean isCancelable = true;
    private boolean autoAdjust = true;
    private int padding;
    private Listener builderListener;
    private Listener listener;
    private Tip tip;
    private Paint tipPaint;
    private Path tipPath;
    private boolean showTip = false;
    private Point anchorPoint = new Point();
    private int[] tooltipSize = new int[2];
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    private TooltipAnimation animation;
    private boolean animate;
    private boolean isDismissed = false;
    private boolean isDismissAnimationInProgress = false;

    private Tooltip(@NonNull Context context, @NonNull View content, @NonNull View anchorView, @NonNull Listener builderListener) {
        super(context);
        this.init(content, anchorView, builderListener);
    }

    private void init(@NonNull View contentView, @NonNull View anchorView, @NonNull Listener builderListener) {
        this.contentView = contentView;
        this.anchorView = anchorView;
        this.builderListener = builderListener;
        this.tipPaint = new Paint(1);
        this.tipPaint.setColor(-1);
        this.tipPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.tipPath = new Path();
        ViewGroup.LayoutParams params = contentView.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-2, -2);
        }
        this.addView(contentView, params);
        this.setCancelable(this.isCancelable);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        View child = this.getChildAt(0);
        this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        if (this.debug) {
            Log.i((String)TAG, (String)("child measured width: " + child.getMeasuredWidth()));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.debug) {
            Log.i((String)TAG, (String)("l: " + l + ", t: " + t + ", r: " + r + ", b: " + b));
        }
        View child = this.getChildAt(0);
        this.anchorView.getLocationInWindow(this.anchorLocation);
        this.getLocationInWindow(this.holderLocation);
        int dx = this.anchorLocation[0] - this.holderLocation[0];
        int dy = this.anchorLocation[1] - this.holderLocation[1];
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int left = dx;
        int top = dy;
        if (this.debug) {
            Log.d((String)TAG, (String)("child w: " + w + " h: " + h));
            Log.d((String)TAG, (String)("left: " + left + ", top: " + top));
        }
        this.tipPath.reset();
        int px = -1;
        int py = -1;
        switch (this.position) {
            case 0: {
                int diff = (this.anchorView.getHeight() - h) / 2;
                left -= w + this.padding + (this.showTip ? this.tip.getHeight() : 0);
                top += diff;
                if (!this.showTip) break;
                px = left + w + this.tip.getHeight();
                py = top + h / 2;
                this.tipPath.moveTo((float)px, (float)py);
                this.tipPath.lineTo((float)(px - this.tip.getHeight()), (float)(py + this.tip.getWidth() / 2));
                this.tipPath.lineTo((float)(px - this.tip.getHeight()), (float)(py - this.tip.getWidth() / 2));
                this.tipPath.lineTo((float)px, (float)py);
                break;
            }
            case 2: {
                int diff = (this.anchorView.getHeight() - h) / 2;
                left += this.anchorView.getWidth() + this.padding + (this.showTip ? this.tip.getHeight() : 0);
                top += diff;
                if (!this.showTip) break;
                px = left - this.tip.getHeight();
                py = top + h / 2;
                this.tipPath.moveTo((float)px, (float)py);
                this.tipPath.lineTo((float)(px + this.tip.getHeight()), (float)(py + this.tip.getWidth() / 2));
                this.tipPath.lineTo((float)(px + this.tip.getHeight()), (float)(py - this.tip.getWidth() / 2));
                this.tipPath.lineTo((float)px, (float)py);
                break;
            }
            case 1: {
                int diff = (this.anchorView.getWidth() - w) / 2;
                left += diff;
                top -= h + this.padding + (this.showTip ? this.tip.getHeight() : 0);
                if (!this.showTip) break;
                px = left + w / 2;
                py = top + h + this.tip.getHeight();
                this.tipPath.moveTo((float)px, (float)py);
                this.tipPath.lineTo((float)(px - this.tip.getWidth() / 2), (float)(py - this.tip.getHeight()));
                this.tipPath.lineTo((float)(px + this.tip.getWidth() / 2), (float)(py - this.tip.getHeight()));
                this.tipPath.lineTo((float)px, (float)py);
                break;
            }
            case 3: {
                int diff = (this.anchorView.getWidth() - w) / 2;
                left += diff;
                top += this.anchorView.getHeight() + this.padding + (this.showTip ? this.tip.getHeight() : 0);
                if (this.debug) {
                    Log.d((String)TAG, (String)("tip top: " + top));
                }
                if (!this.showTip) break;
                px = left + w / 2;
                py = top - this.tip.getHeight();
                this.tipPath.moveTo((float)px, (float)py);
                this.tipPath.lineTo((float)(px - this.tip.getWidth() / 2), (float)(py + this.tip.getHeight()));
                this.tipPath.lineTo((float)(px + this.tip.getWidth() / 2), (float)(py + this.tip.getHeight()));
                this.tipPath.lineTo((float)px, (float)py);
                if (!this.debug) break;
                Log.i((String)TAG, (String)("px: " + px + ", py: " + py));
                break;
            }
        }
        if (this.autoAdjust) {
            switch (this.position) {
                case 1: 
                case 3: {
                    if (left + w > r) {
                        left = r - w - this.padding;
                        break;
                    }
                    if (left >= l) break;
                    left = l + this.padding;
                    break;
                }
                case 0: 
                case 2: {
                    if (top + h > b) {
                        top = b - h - this.padding;
                        break;
                    }
                    if (top >= t) break;
                    top = t + this.padding;
                }
            }
        }
        if (this.debug) {
            Log.i((String)TAG, (String)("child layout: left: " + left + " top: " + top + " right: " + (left + child.getMeasuredWidth()) + " bottom: " + (top + child.getMeasuredHeight())));
        }
        if (px == -1 || py == -1) {
            switch (this.position) {
                case 1: {
                    px = left + child.getMeasuredWidth() / 2;
                    py = top + child.getMeasuredHeight();
                    break;
                }
                case 3: {
                    px = left + child.getMeasuredWidth() / 2;
                    py = top;
                    break;
                }
                case 0: {
                    px = left + child.getMeasuredWidth();
                    py = top + child.getMeasuredHeight();
                    break;
                }
                case 2: {
                    px = left;
                    py = top + child.getMeasuredHeight() / 2;
                }
            }
        }
        this.anchorPoint.set(px, py);
        this.tooltipSize[0] = child.getMeasuredWidth();
        this.tooltipSize[1] = child.getMeasuredHeight();
        child.layout(left, top, left + child.getMeasuredWidth(), top + child.getMeasuredHeight());
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.debug) {
            Log.i((String)TAG, (String)("canvas w: " + canvas.getWidth() + ", h: " + canvas.getHeight()));
        }
        if (this.showTip) {
            canvas.drawPath(this.tipPath, this.tipPaint);
        }
    }

    private void setPosition(int position) {
        this.position = position;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public void setCancelable(boolean isCancelable) {
        this.isCancelable = isCancelable;
        if (isCancelable) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Tooltip.this.dismiss(Tooltip.this.animate);
                }
            });
        } else {
            this.setOnClickListener(null);
        }
    }

    private void setAnimation(@Nullable TooltipAnimation animation) {
        this.animation = animation;
        if (animation == null || animation.getType() == 0) {
            this.animate = false;
            return;
        }
        this.animate = true;
    }

    private void setAutoAdjust(boolean autoAdjust) {
        this.autoAdjust = autoAdjust;
    }

    private void setPadding(int padding) {
        this.padding = padding;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean isShowTip() {
        return this.showTip;
    }

    private void setShowTip(boolean showTip) {
        this.showTip = showTip;
        if (showTip && this.tip == null) {
            throw new NullPointerException("Tip is null");
        }
    }

    private void setTip(@Nullable Tip tip) {
        this.showTip = tip != null;
        this.tip = tip;
        if (tip != null) {
            this.tipPaint.setColor(tip.getColor());
            if (tip.getTipRadius() > 0) {
                this.tipPaint.setStrokeJoin(Paint.Join.ROUND);
                this.tipPaint.setStrokeCap(Paint.Cap.ROUND);
                this.tipPaint.setStrokeWidth((float)tip.getTipRadius());
            }
        }
        if (this.debug) {
            Log.d((String)TAG, (String)("show tip: " + this.showTip));
        }
    }

    public void dismiss() {
        if (this.isDismissed) {
            return;
        }
        this.isDismissed = true;
        this.removeView(this.contentView);
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.removeView((View)this);
        this.builderListener.onDismissed();
        if (this.listener != null) {
            this.listener.onDismissed();
        }
    }

    public void dismiss(boolean animate) {
        if (this.isDismissed) {
            return;
        }
        if (!animate || this.animation == null) {
            this.dismiss();
            return;
        }
        this.animateOut(this.animation);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private Point getAnchorPoint() {
        return this.anchorPoint;
    }

    private int[] getTooltipSize() {
        return this.tooltipSize;
    }

    private void animateIn(@NonNull TooltipAnimation animation) {
        Animator animator;
        Point point = this.getAnchorPoint();
        int[] size = this.getTooltipSize();
        if (this.debug) {
            Log.d((String)TAG, (String)("anchor point: " + point.x + ", " + point.y));
            Log.d((String)TAG, (String)("circular reveal : " + point.y + ", " + point.x));
            Log.d((String)TAG, (String)("size: " + size[0] + ", " + size[1]));
        }
        if ((animator = this.getAnimatorIn(animation, point, size, true)) != null) {
            animator.start();
        }
    }

    @Nullable
    private Animator getAnimatorIn(@NonNull TooltipAnimation animation, @NonNull Point point, @NonNull int[] size, boolean animateIn) {
        float startAlpha = 0.0f;
        float endAlpha = 1.0f;
        float startScale = 0.0f;
        float endScale = 1.0f;
        int startRadius = 0;
        int finalRadius = Math.max(size[0], size[1]);
        if (!animateIn) {
            startAlpha = 1.0f;
            endAlpha = 0.0f;
            startScale = 1.0f;
            endScale = 0.0f;
            startRadius = finalRadius;
            finalRadius = 0;
        }
        switch (animation.getType()) {
            case 1: {
                return AnimationUtils.fade((View)this, startAlpha, endAlpha, animation.getDuration());
            }
            case 2: {
                if (Build.VERSION.SDK_INT < 21) {
                    Log.e((String)TAG, (String)"Reveal is supported on sdk 21 and above");
                    return null;
                }
                return AnimationUtils.reveal((View)this, point.x, point.y, startRadius, finalRadius, animation.getDuration());
            }
            case 3: {
                return this.getScaleAnimator(animation, size, startScale, endScale);
            }
            case 4: {
                Animator scaleAnimator = this.getScaleAnimator(animation, size, startScale, endScale);
                Animator fadeAnimator = AnimationUtils.fade((View)this, startAlpha, endAlpha, animation.getDuration());
                if (scaleAnimator == null) {
                    return fadeAnimator;
                }
                AnimatorSet animatorSet = new AnimatorSet();
                animatorSet.playTogether(new Animator[]{scaleAnimator, fadeAnimator});
                return animatorSet;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    private void animateOut(@NonNull TooltipAnimation animation) {
        Animator animator;
        if (this.isDismissAnimationInProgress) {
            return;
        }
        Point point = this.getAnchorPoint();
        int[] size = this.getTooltipSize();
        if (this.debug) {
            Log.d((String)TAG, (String)("anchor point: " + point.x + ", " + point.y));
            Log.d((String)TAG, (String)("circular reveal : " + point.y + ", " + point.x));
            Log.d((String)TAG, (String)("size: " + size[0] + ", " + size[1]));
        }
        if ((animator = this.getAnimatorIn(animation, point, size, false)) == null) {
            this.dismiss();
            return;
        }
        animator.start();
        this.isDismissAnimationInProgress = true;
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                Tooltip.this.dismiss();
            }

            public void onAnimationCancel(Animator animation) {
                Tooltip.this.dismiss();
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    @Nullable
    private Animator getScaleAnimator(@NonNull TooltipAnimation animation, @NonNull int[] size, float startScale, float endScale) {
        switch (this.position) {
            case 3: {
                return AnimationUtils.scaleY(this.contentView, size[0] / 2, 0, startScale, endScale, animation.getDuration());
            }
            case 1: {
                return AnimationUtils.scaleY(this.contentView, size[0] / 2, size[1], startScale, endScale, animation.getDuration());
            }
            case 2: {
                return AnimationUtils.scaleX(this.contentView, 0, size[1] / 2, startScale, endScale, animation.getDuration());
            }
            case 0: {
                return AnimationUtils.scaleX(this.contentView, size[0], size[1] / 2, startScale, endScale, animation.getDuration());
            }
        }
        return null;
    }

    public static interface Listener {
        public void onDismissed();
    }

    public static class Tip {
        private int width;
        private int height;
        private int color;
        private int tipRadius;
        private static final int DEFAULT_TIP_RADIUS = 0;

        public Tip(int width, int height, int color, int tipRadius) {
            this.width = width;
            this.height = height;
            this.color = color;
            this.tipRadius = tipRadius;
        }

        public Tip(int width, int height, int color) {
            this(width, height, color, 0);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getColor() {
            return this.color;
        }

        public int getTipRadius() {
            return this.tipRadius;
        }
    }

    public static class Builder {
        private Context context;
        private ViewGroup rootView;
        private View contentView;
        private View anchorView;
        private int position = 1;
        private boolean cancelable = true;
        private boolean autoAdjust = true;
        private Tip tip;
        private int padding = 0;
        private int autoCancelTime = 0;
        private Tooltip tooltip;
        private Handler handler;
        private Runnable autoCancelRunnable;
        private Listener myListener;
        private Listener listener;
        private TooltipAnimation animation;
        private boolean animate;
        private boolean debug = false;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.handler = new Handler();
            this.autoCancelRunnable = new Runnable(){

                @Override
                public void run() {
                    if (Builder.this.tooltip != null) {
                        Builder.this.tooltip.dismiss(Builder.this.animate);
                    }
                }
            };
            this.myListener = new Listener(){

                @Override
                public void onDismissed() {
                    Builder.this.handler.removeCallbacks(Builder.this.autoCancelRunnable);
                }
            };
        }

        public Builder content(@NonNull View view) {
            this.contentView = view;
            return this;
        }

        public Builder anchor(@NonNull View view) {
            this.anchorView = view;
            return this;
        }

        public Builder anchor(@NonNull View view, int position) {
            this.anchorView = view;
            this.position = position;
            return this;
        }

        public Builder into(@NonNull ViewGroup viewGroup) {
            this.rootView = viewGroup;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder autoAdjust(boolean autoAdjust) {
            this.autoAdjust = autoAdjust;
            return this;
        }

        public Builder withPadding(int padding) {
            this.padding = padding;
            return this;
        }

        public Builder withListener(@NonNull Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withTip(@NonNull Tip tip) {
            this.tip = tip;
            return this;
        }

        public Builder autoCancel(int timeInMilli) {
            this.autoCancelTime = timeInMilli;
            return this;
        }

        public Builder animate(@NonNull TooltipAnimation animation) {
            this.animation = animation;
            this.animate = true;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Tooltip build() {
            if (this.anchorView == null) {
                throw new NullPointerException("anchor view is null");
            }
            if (this.rootView == null) {
                throw new NullPointerException("Root view is null");
            }
            if (this.contentView == null) {
                throw new NullPointerException("content view is null");
            }
            this.tooltip = new Tooltip(this.context, this.contentView, this.anchorView, this.myListener);
            this.tooltip.setDebug(this.debug);
            this.tooltip.setAnimation(this.animation);
            this.tooltip.setPosition(this.position);
            this.tooltip.setCancelable(this.cancelable);
            this.tooltip.setAutoAdjust(this.autoAdjust);
            this.tooltip.setPadding(this.padding);
            this.tooltip.setListener(this.listener);
            this.tooltip.setTip(this.tip);
            return this.tooltip;
        }

        public Tooltip show() {
            this.tooltip = this.build();
            this.rootView.addView((View)this.tooltip, new ViewGroup.LayoutParams(-1, -1));
            if (this.autoCancelTime > 0) {
                this.handler.postDelayed(this.autoCancelRunnable, (long)this.autoCancelTime);
            }
            if (this.animate && this.animation != null) {
                this.tooltip.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        Builder.this.tooltip.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        Builder.this.tooltip.animateIn(Builder.this.animation);
                        return true;
                    }
                });
            }
            return this.tooltip;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Position {
    }
}

