/*
 * Decompiled with CFR 0.152.
 */
package com.fenchtose.tooltip;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewAnimationUtils;

public class AnimationUtils {
    @NonNull
    public static Animator fade(@NonNull View view, float fromAlpha, float toAlpha, int duration) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{fromAlpha, toAlpha});
        animator.setDuration((long)duration);
        return animator;
    }

    @NonNull
    @TargetApi(value=21)
    public static Animator reveal(@NonNull View view, int cx, int cy, int startRadius, int finalRadius, int duration) {
        Animator animator = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)startRadius, (float)finalRadius);
        animator.setDuration((long)duration);
        return animator;
    }

    @NonNull
    public static Animator scaleY(@NonNull View view, int pivotX, int pivotY, float fromScale, float toScale, int duration) {
        view.setPivotX((float)pivotX);
        view.setPivotY((float)pivotY);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{fromScale, toScale});
        animator.setDuration((long)duration);
        return animator;
    }

    @NonNull
    public static Animator scaleX(@NonNull View view, int pivotX, int pivotY, float fromScale, float toScale, int duration) {
        view.setPivotX((float)pivotX);
        view.setPivotY((float)pivotY);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{fromScale, toScale});
        animator.setDuration((long)duration);
        return animator;
    }
}

