/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.module.scala.deser.EitherDeserializer$ElementDeserializerConfig$;
import com.fasterxml.jackson.module.scala.deser.OptionDeserializer;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public class EitherDeserializer
extends StdDeserializer<Either<Object, Object>>
implements ContextualDeserializer {
    private final JavaType javaType;
    private final DeserializationConfig config;
    private final ElementDeserializerConfig leftDeserializerConfig;
    private final ElementDeserializerConfig rightDeserializerConfig;

    public EitherDeserializer(JavaType javaType, DeserializationConfig config, ElementDeserializerConfig leftDeserializerConfig, ElementDeserializerConfig rightDeserializerConfig) {
        this.javaType = javaType;
        this.config = config;
        this.leftDeserializerConfig = leftDeserializerConfig;
        this.rightDeserializerConfig = rightDeserializerConfig;
        super(Either.class);
    }

    public JsonDeserializer<Either<Object, Object>> createContextual(DeserializationContext ctxt, BeanProperty property) {
        EitherDeserializer eitherDeserializer;
        int n = this.javaType.containedTypeCount();
        if (2 == n) {
            ElementDeserializerConfig leftDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, this.javaType, property);
            ElementDeserializerConfig rightDeserializerConfig = this.deserializerConfigFor$1(ctxt, 1, this.javaType, property);
            eitherDeserializer = new EitherDeserializer(this.javaType, this.config, leftDeserializerConfig, rightDeserializerConfig);
        } else {
            eitherDeserializer = this;
        }
        return eitherDeserializer;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object deserializeValue(JsonToken type, ElementDeserializerConfig config, JsonParser jp, DeserializationContext ctxt) {
        Object object;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)config, (Object)type);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ElementDeserializerConfig elementDeserializerConfig = (ElementDeserializerConfig)tuple2._1();
        JsonToken jsonToken = (JsonToken)tuple2._2();
        if (elementDeserializerConfig != null) {
            ElementDeserializerConfig elementDeserializerConfig2 = EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
            Option<JsonDeserializer<Object>> option = elementDeserializerConfig2._1();
            Option<TypeDeserializer> option2 = elementDeserializerConfig2._2();
            if (option instanceof Some) {
                JsonDeserializer ed = (JsonDeserializer)((Some)option).value();
                JsonToken jsonToken2 = JsonToken.VALUE_NULL;
                JsonToken jsonToken3 = jsonToken;
                if (!(jsonToken2 != null ? !jsonToken2.equals(jsonToken3) : jsonToken3 != null) && ed instanceof OptionDeserializer) {
                    object = None$.MODULE$;
                    return object;
                }
            }
        }
        JsonToken jsonToken4 = JsonToken.VALUE_NULL;
        JsonToken jsonToken5 = jsonToken;
        if (!(jsonToken4 != null ? !jsonToken4.equals(jsonToken5) : jsonToken5 != null)) {
            object = None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return object;
        }
        if (elementDeserializerConfig != null) {
            ElementDeserializerConfig elementDeserializerConfig3 = EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
            Option<JsonDeserializer<Object>> option = elementDeserializerConfig3._1();
            Option<TypeDeserializer> option3 = elementDeserializerConfig3._2();
            if (option instanceof Some) {
                JsonDeserializer jsonDeserializer;
                JsonDeserializer ed = jsonDeserializer = (JsonDeserializer)((Some)option).value();
                if (option3 instanceof Some) {
                    TypeDeserializer td = (TypeDeserializer)((Some)option3).value();
                    object = ed.deserializeWithType(jp, ctxt, td);
                    return object;
                }
                JsonDeserializer ed2 = jsonDeserializer;
                object = ed2.deserialize(jp, ctxt);
                return object;
            }
        }
        object = ctxt.handleUnexpectedToken(this.javaType.getRawClass(), jp);
        return object;
    }

    private Either<Object, Object> deserializeEither(JsonParser jp, DeserializationContext ctxt) {
        Either either;
        JsonToken jsonToken = jp.currentToken();
        JsonToken jsonToken2 = JsonToken.START_OBJECT;
        JsonToken jsonToken3 = jsonToken;
        if (!(jsonToken2 != null ? !jsonToken2.equals(jsonToken3) : jsonToken3 != null)) {
            String key = jp.nextFieldName();
            JsonToken type = jp.nextToken();
            String string = key;
            Left result = "l".equals(string) ? package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt)) : ("left".equals(string) ? package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt)) : ("r".equals(string) ? package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt)) : ("right".equals(string) ? package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt)) : (Either)ctxt.handleUnexpectedToken(this.javaType, jp))));
            jp.nextToken();
            either = result;
        } else {
            JsonToken jsonToken4 = JsonToken.START_ARRAY;
            JsonToken jsonToken5 = jsonToken;
            if (!(jsonToken4 != null ? !jsonToken4.equals(jsonToken5) : jsonToken5 != null)) {
                String key = jp.nextTextValue();
                JsonToken type = jp.nextToken();
                String string = key;
                Left result = "l".equals(string) ? package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt)) : ("left".equals(string) ? package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt)) : ("r".equals(string) ? package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt)) : ("right".equals(string) ? package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt)) : (Either)ctxt.handleUnexpectedToken(this.javaType, jp))));
                jp.nextToken();
                either = result;
            } else {
                either = (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
            }
        }
        return either;
    }

    public Either<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) {
        return this.deserializeEither(jp, ctxt);
    }

    public Either<Object, Object> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) {
        return this.deserializeEither(jp, ctxt);
    }

    private final ElementDeserializerConfig deserializerConfigFor$1(DeserializationContext ctxt$1, int param, JavaType inType, BeanProperty property) {
        JavaType containedType = this.javaType.containedType(param);
        Option paramDeserializer = Option$.MODULE$.apply((Object)ctxt$1.findContextualValueDeserializer(containedType, property));
        Option typeDeserializer = Option$.MODULE$.apply((Object)property).flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)BeanDeserializerFactory.instance.findPropertyTypeDeserializer(ctxt$1.getConfig(), containedType, p.getMember())));
        return EitherDeserializer$ElementDeserializerConfig$.MODULE$.apply((Option<JsonDeserializer<Object>>)paramDeserializer, (Option<TypeDeserializer>)typeDeserializer);
    }

    public static class ElementDeserializerConfig
    implements Product,
    Serializable {
        private final Option deserializer;
        private final Option typeDeserializer;

        public static ElementDeserializerConfig apply(Option<JsonDeserializer<Object>> option, Option<TypeDeserializer> option2) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.apply(option, option2);
        }

        public static ElementDeserializerConfig empty() {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty();
        }

        public static ElementDeserializerConfig fromProduct(Product product) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.fromProduct(product);
        }

        public static ElementDeserializerConfig unapply(ElementDeserializerConfig elementDeserializerConfig) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
        }

        public ElementDeserializerConfig(Option<JsonDeserializer<Object>> deserializer, Option<TypeDeserializer> typeDeserializer) {
            this.deserializer = deserializer;
            this.typeDeserializer = typeDeserializer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ElementDeserializerConfig)) return false;
            ElementDeserializerConfig elementDeserializerConfig = (ElementDeserializerConfig)object;
            Option<JsonDeserializer<Object>> option = this.deserializer();
            Option<JsonDeserializer<Object>> option2 = elementDeserializerConfig.deserializer();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<TypeDeserializer> option3 = this.typeDeserializer();
            Option<TypeDeserializer> option4 = elementDeserializerConfig.typeDeserializer();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!elementDeserializerConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ElementDeserializerConfig;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ElementDeserializerConfig";
        }

        public Object productElement(int n) {
            Option<JsonDeserializer<Object>> option;
            int n2 = n;
            if (0 == n2) {
                option = this._1();
            } else if (1 == n2) {
                option = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "deserializer";
            } else if (1 == n2) {
                string = "typeDeserializer";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Option<JsonDeserializer<Object>> deserializer() {
            return this.deserializer;
        }

        public Option<TypeDeserializer> typeDeserializer() {
            return this.typeDeserializer;
        }

        public ElementDeserializerConfig copy(Option<JsonDeserializer<Object>> deserializer, Option<TypeDeserializer> typeDeserializer) {
            return new ElementDeserializerConfig(deserializer, typeDeserializer);
        }

        public Option<JsonDeserializer<Object>> copy$default$1() {
            return this.deserializer();
        }

        public Option<TypeDeserializer> copy$default$2() {
            return this.typeDeserializer();
        }

        public Option<JsonDeserializer<Object>> _1() {
            return this.deserializer();
        }

        public Option<TypeDeserializer> _2() {
            return this.typeDeserializer();
        }
    }
}

