/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.PackageVersion;
import com.fasterxml.jackson.module.mrbean.TypeBuilder;
import java.lang.reflect.Modifier;

public class AbstractTypeMaterializer
extends AbstractTypeResolver
implements Versioned {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    public static final String DEFAULT_PACKAGE_FOR_GENERATED = "com.fasterxml.jackson.module.mrbean.generated.";
    protected final MyClassLoader _classLoader;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected String _defaultPackage = "com.fasterxml.jackson.module.mrbean.generated.";

    public AbstractTypeMaterializer() {
        this(null);
    }

    public AbstractTypeMaterializer(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this._classLoader = new MyClassLoader(parentClassLoader);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setDefaultPackage(String defPkg) {
        if (!defPkg.endsWith(".")) {
            defPkg = defPkg + ".";
        }
        this._defaultPackage = defPkg;
    }

    public JavaType resolveAbstractType(DeserializationConfig config, JavaType type) {
        if (type.isContainerType() || type.isPrimitive() || type.isEnumType() || type.isReferenceType() || type.isThrowable() || type.hasRawClass(Number.class)) {
            return null;
        }
        Class cls = type.getRawClass();
        if (!Modifier.isPublic(cls.getModifiers())) {
            if (this.isEnabled(Feature.FAIL_ON_NON_PUBLIC_TYPES)) {
                throw new IllegalArgumentException("Can not materialize implementation of " + cls + " since it is not public ");
            }
            return null;
        }
        Class<?> materializedType = type.hasGenericTypes() ? this.materializeGenericType((MapperConfig<?>)config, type) : this.materializeRawType((MapperConfig<?>)config, type);
        return config.constructType(materializedType);
    }

    public Class<?> materializeGenericType(MapperConfig<?> config, JavaType type) {
        Class cls = type.getRawClass();
        String abstractName = this._defaultPackage + "abstract." + cls.getName() + "_TYPE_RESOLVE";
        TypeBuilder tb = new TypeBuilder(type);
        byte[] code = tb.buildAbstractBase(abstractName);
        Class<?> raw = this._classLoader.loadAndResolve(abstractName, code, cls);
        return this.materializeRawType(config, config.getTypeFactory().constructType(raw));
    }

    public Class<?> materializeRawType(MapperConfig<?> config, JavaType type) {
        Class rawType = type.getRawClass();
        String newName = this._defaultPackage + rawType.getName();
        AnnotatedClass ac = AnnotatedClass.construct((JavaType)type, config);
        BeanBuilder builder = BeanBuilder.construct(config, type, ac);
        byte[] bytecode = builder.implement(this.isEnabled(Feature.FAIL_ON_UNMATERIALIZED_METHOD)).build(newName);
        return this._classLoader.loadAndResolve(newName, bytecode, rawType);
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> loadAndResolve(String className, byte[] byteCode, Class<?> targetClass) throws IllegalArgumentException {
            Class<?> impl;
            Class<?> old = this.findLoadedClass(className);
            if (old != null && targetClass.isAssignableFrom(old)) {
                return old;
            }
            try {
                impl = this.defineClass(className, byteCode, 0, byteCode.length);
            }
            catch (LinkageError e) {
                throw new IllegalArgumentException("Failed to load class '" + className + "': " + e.getMessage(), e);
            }
            this.resolveClass(impl);
            return impl;
        }
    }

    public static enum Feature {
        FAIL_ON_UNMATERIALIZED_METHOD(false),
        FAIL_ON_NON_PUBLIC_TYPES(true);

        final boolean _defaultState;

        protected static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

