/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.PackageVersion;
import com.fasterxml.jackson.module.mrbean.TypeBuilder;
import java.lang.reflect.Modifier;

public class AbstractTypeMaterializer
extends AbstractTypeResolver
implements Versioned {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    public static final String DEFAULT_PACKAGE_FOR_GENERATED = "org.codehaus.jackson.generated.";
    protected final MyClassLoader _classLoader;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected String _defaultPackage = "org.codehaus.jackson.generated.";

    public AbstractTypeMaterializer() {
        this(null);
    }

    public AbstractTypeMaterializer(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this._classLoader = new MyClassLoader(parentClassLoader);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setDefaultPackage(String defPkg) {
        if (!defPkg.endsWith(".")) {
            defPkg = defPkg + ".";
        }
        this._defaultPackage = defPkg;
    }

    public JavaType resolveAbstractType(DeserializationConfig config, JavaType type) {
        if (type.isContainerType() || type.isPrimitive() || type.isEnumType() || type.isThrowable()) {
            return null;
        }
        Class cls = type.getRawClass();
        if (cls == Number.class) {
            return null;
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            if (this.isEnabled(Feature.FAIL_ON_NON_PUBLIC_TYPES)) {
                throw new IllegalArgumentException("Can not materialize implementation of " + cls + " since it is not public ");
            }
            return null;
        }
        return config.constructType(this.materializeClass(config, type));
    }

    public Class<?> materializeClass(DeserializationConfig config, JavaType type) {
        Class cls;
        if (type.containedTypeCount() > 0) {
            cls = type.getRawClass();
            String abstractName = this._defaultPackage + "abstract." + cls.getName() + "_TYPE_RESOLVE";
            TypeBuilder tb = new TypeBuilder(type);
            byte[] code = tb.buildAbstractBase(abstractName);
            Class<?> result = this._classLoader.loadAndResolve(abstractName, code, cls);
            type = config.getTypeFactory().constructType(result);
        }
        cls = type.getRawClass();
        String newName = this._defaultPackage + cls.getName();
        BeanBuilder builder = new BeanBuilder(cls, config.getTypeFactory());
        byte[] bytecode = builder.implement(this.isEnabled(Feature.FAIL_ON_UNMATERIALIZED_METHOD)).build(newName);
        return this._classLoader.loadAndResolve(newName, bytecode, cls);
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> loadAndResolve(String className, byte[] byteCode, Class<?> targetClass) throws IllegalArgumentException {
            Class<?> impl;
            Class<?> old = this.findLoadedClass(className);
            if (old != null && targetClass.isAssignableFrom(old)) {
                return old;
            }
            try {
                impl = this.defineClass(className, byteCode, 0, byteCode.length);
            }
            catch (LinkageError e) {
                throw new IllegalArgumentException("Failed to load class '" + className + "': " + e.getMessage(), e);
            }
            this.resolveClass(impl);
            return impl;
        }
    }

    public static enum Feature {
        FAIL_ON_UNMATERIALIZED_METHOD(false),
        FAIL_ON_NON_PUBLIC_TYPES(true);

        final boolean _defaultState;

        protected static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

