/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.mrbean.BeanUtil;
import com.fasterxml.jackson.module.mrbean.POJOProperty;
import com.fasterxml.jackson.module.mrbean.asm.ClassWriter;
import com.fasterxml.jackson.module.mrbean.asm.FieldVisitor;
import com.fasterxml.jackson.module.mrbean.asm.MethodVisitor;
import com.fasterxml.jackson.module.mrbean.asm.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanBuilder {
    protected Map<String, POJOProperty> _beanProperties = new LinkedHashMap<String, POJOProperty>();
    protected LinkedHashMap<String, Method> _unsupportedMethods = new LinkedHashMap();
    protected final JavaType _type;
    protected final AnnotatedClass _typeDefinition;
    protected final TypeFactory _typeFactory;

    public BeanBuilder(JavaType type, AnnotatedClass ac, TypeFactory tf) {
        this._type = type;
        this._typeDefinition = ac;
        this._typeFactory = tf;
    }

    public static BeanBuilder construct(MapperConfig<?> config, JavaType type, AnnotatedClass ac) {
        return new BeanBuilder(type, ac, config.getTypeFactory());
    }

    public BeanBuilder implement(boolean failOnUnrecognized) {
        ArrayList<JavaType> implTypes = new ArrayList<JavaType>();
        implTypes.add(this._type);
        BeanUtil.findSuperTypes(this._type, Object.class, implTypes);
        for (JavaType impl : implTypes) {
            TypeResolutionContext ctxt = this.buildTypeContext(impl);
            for (Method m : impl.getRawClass().getDeclaredMethods()) {
                if (Modifier.isStatic(m.getModifiers())) continue;
                String methodName = m.getName();
                int argCount = m.getParameterTypes().length;
                if (argCount == 0) {
                    if (methodName.startsWith("get")) {
                        if (methodName.length() > 3) {
                            this.addGetter(ctxt, m);
                            continue;
                        }
                    } else if (methodName.startsWith("is") && methodName.length() > 2 && BeanBuilder.returnsBoolean(m)) {
                        this.addGetter(ctxt, m);
                        continue;
                    }
                } else if (argCount == 1 && methodName.startsWith("set") && methodName.length() > 3) {
                    this.addSetter(ctxt, m);
                    continue;
                }
                if (BeanUtil.isConcrete(m) || this._unsupportedMethods.containsKey(methodName) || this.hasConcreteOverride(m, this._type)) continue;
                if (failOnUnrecognized) {
                    throw new IllegalArgumentException("Unrecognized abstract method '" + methodName + "' (not a getter or setter) -- to avoid exception, disable AbstractTypeMaterializer.Feature.FAIL_ON_UNMATERIALIZED_METHOD");
                }
                this._unsupportedMethods.put(methodName, m);
            }
        }
        return this;
    }

    public byte[] build(String className) {
        String superName;
        ClassWriter cw = new ClassWriter(1);
        String internalClass = this.getInternalClassName(className);
        String implName = this.getInternalClassName(this._type.getRawClass().getName());
        if (this._type.isInterface()) {
            superName = "java/lang/Object";
            cw.visit(49, 33, internalClass, null, superName, new String[]{implName});
        } else {
            superName = implName;
            cw.visit(49, 33, internalClass, null, implName, null);
        }
        cw.visitSource(className + ".java", null);
        BeanBuilder.generateDefaultConstructor(cw, superName);
        for (POJOProperty prop : this._beanProperties.values()) {
            TypeDescription type = prop.selectType();
            this.createField(cw, prop, type);
            if (!prop.hasConcreteGetter()) {
                this.createGetter(cw, internalClass, prop, type);
            }
            if (prop.hasConcreteSetter()) continue;
            this.createSetter(cw, internalClass, prop, type);
        }
        for (Method m : this._unsupportedMethods.values()) {
            this.createUnimplementedMethod(cw, internalClass, m);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected boolean hasConcreteOverride(Method m0, JavaType implementedType) {
        String name = m0.getName();
        Class<?>[] argTypes = m0.getParameterTypes();
        for (JavaType curr = implementedType; curr != null && !curr.isJavaLangObject(); curr = curr.getSuperClass()) {
            try {
                Method effectiveMethod = curr.getRawClass().getDeclaredMethod(name, argTypes);
                if (effectiveMethod == null || !BeanUtil.isConcrete(effectiveMethod)) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    protected String getPropertyName(String methodName) {
        int prefixLen = methodName.startsWith("is") ? 2 : 3;
        return this.decap(methodName.substring(prefixLen));
    }

    protected String buildGetterName(String fieldName) {
        return this.cap("get", fieldName);
    }

    protected String buildSetterName(String fieldName) {
        return this.cap("set", fieldName);
    }

    protected String getInternalClassName(String className) {
        return className.replace(".", "/");
    }

    protected void addGetter(TypeResolutionContext ctxt, Method m) {
        POJOProperty prop = this.findProperty(ctxt, this.getPropertyName(m.getName()));
        if (prop.getGetter() == null) {
            prop.setGetter(m);
        }
    }

    protected void addSetter(TypeResolutionContext ctxt, Method m) {
        POJOProperty prop = this.findProperty(ctxt, this.getPropertyName(m.getName()));
        if (prop.getSetter() == null) {
            prop.setSetter(m);
        }
    }

    protected POJOProperty findProperty(TypeResolutionContext ctxt, String propName) {
        POJOProperty prop = this._beanProperties.get(propName);
        if (prop == null) {
            prop = new POJOProperty(ctxt, propName);
            this._beanProperties.put(propName, prop);
        }
        return prop;
    }

    protected static final boolean returnsBoolean(Method m) {
        Class<?> rt = m.getReturnType();
        return rt == Boolean.class || rt == Boolean.TYPE;
    }

    protected static void generateDefaultConstructor(ClassWriter cw, String superName) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void createField(ClassWriter cw, POJOProperty prop, TypeDescription type) {
        String sig = type.hasGenerics() ? type.genericSignature() : null;
        String desc = type.erasedSignature();
        FieldVisitor fv = cw.visitField(4, prop.getFieldName(), desc, sig, null);
        fv.visitEnd();
    }

    protected void createSetter(ClassWriter cw, String internalClassName, POJOProperty prop, TypeDescription propertyType) {
        String methodName;
        String desc;
        Method setter = prop.getSetter();
        if (setter != null) {
            desc = Type.getMethodDescriptor(setter);
            methodName = setter.getName();
        } else {
            desc = "(" + propertyType.erasedSignature() + ")V";
            methodName = this.buildSetterName(prop.getName());
        }
        String sig = propertyType.hasGenerics() ? "(" + propertyType.genericSignature() + ")V" : null;
        MethodVisitor mv = cw.visitMethod(1, methodName, desc, sig, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(propertyType.getLoadOpcode(), 1);
        mv.visitFieldInsn(181, internalClassName, prop.getFieldName(), propertyType.erasedSignature());
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void createGetter(ClassWriter cw, String internalClassName, POJOProperty prop, TypeDescription propertyType) {
        String methodName;
        String desc;
        Method getter = prop.getGetter();
        if (getter != null) {
            desc = Type.getMethodDescriptor(getter);
            methodName = getter.getName();
        } else {
            desc = "()" + propertyType.erasedSignature();
            methodName = this.buildGetterName(prop.getName());
        }
        String sig = propertyType.hasGenerics() ? "()" + propertyType.genericSignature() : null;
        MethodVisitor mv = cw.visitMethod(1, methodName, desc, sig, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalClassName, prop.getFieldName(), propertyType.erasedSignature());
        mv.visitInsn(propertyType.getReturnOpcode());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void createUnimplementedMethod(ClassWriter cw, String internalClassName, Method method) {
        String exceptionName = this.getInternalClassName(UnsupportedOperationException.class.getName());
        String sig = Type.getMethodDescriptor(method);
        String name = method.getName();
        MethodVisitor mv = cw.visitMethod(1, name, sig, null, null);
        mv.visitTypeInsn(187, exceptionName);
        mv.visitInsn(89);
        mv.visitLdcInsn("Unimplemented method '" + name + "' (not a setter/getter, could not materialize)");
        mv.visitMethodInsn(183, exceptionName, "<init>", "(Ljava/lang/String;)V", false);
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected String decap(String name) {
        char c = name.charAt(0);
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(c)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(c);
        return new String(chars);
    }

    protected String cap(String prefix, String name) {
        int plen = prefix.length();
        StringBuilder sb = new StringBuilder(plen + name.length());
        sb.append(prefix);
        sb.append(name);
        sb.setCharAt(plen, Character.toUpperCase(name.charAt(0)));
        return sb.toString();
    }

    protected TypeResolutionContext buildTypeContext(JavaType ctxtType) {
        return new TypeResolutionContext.Basic(this._typeFactory, ctxtType.getBindings());
    }

    static class TypeDescription {
        private final Type _asmType;
        private JavaType _jacksonType;

        public TypeDescription(JavaType type) {
            this._jacksonType = type;
            this._asmType = Type.getType(type.getRawClass());
        }

        public Class<?> getRawClass() {
            return this._jacksonType.getRawClass();
        }

        public String erasedSignature() {
            return this._jacksonType.getErasedSignature();
        }

        public String genericSignature() {
            return this._jacksonType.getGenericSignature();
        }

        public boolean hasGenerics() {
            return this._jacksonType.hasGenericTypes();
        }

        public int getLoadOpcode() {
            return this._asmType.getOpcode(21);
        }

        public int getReturnOpcode() {
            return this._asmType.getOpcode(172);
        }

        public String toString() {
            return this._jacksonType.toString();
        }

        public static TypeDescription moreSpecificType(TypeDescription desc1, TypeDescription desc2) {
            Class<?> c2;
            Class<?> c1 = desc1.getRawClass();
            if (c1.isAssignableFrom(c2 = desc2.getRawClass())) {
                return desc2;
            }
            if (c2.isAssignableFrom(c1)) {
                return desc1;
            }
            return null;
        }
    }
}

