/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.mrbean.BeanUtil;
import com.fasterxml.jackson.module.mrbean.POJOProperty;
import com.fasterxml.jackson.module.mrbean.asm.ClassWriter;
import com.fasterxml.jackson.module.mrbean.asm.FieldVisitor;
import com.fasterxml.jackson.module.mrbean.asm.MethodVisitor;
import com.fasterxml.jackson.module.mrbean.asm.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder {
    protected Map<String, POJOProperty> _beanProperties = new LinkedHashMap<String, POJOProperty>();
    protected LinkedHashMap<String, Method> _unsupportedMethods = new LinkedHashMap();
    protected final Class<?> _implementedType;
    protected final TypeFactory _typeFactory;

    public BeanBuilder(Class<?> implType, TypeFactory tf) {
        this._implementedType = implType;
        this._typeFactory = tf;
    }

    public BeanBuilder implement(boolean failOnUnrecognized) {
        ArrayList implTypes = new ArrayList();
        implTypes.add(this._implementedType);
        BeanUtil.findSuperTypes(this._implementedType, Object.class, implTypes);
        for (Class<?> impl : implTypes) {
            for (Method m : impl.getDeclaredMethods()) {
                String methodName = m.getName();
                int argCount = m.getParameterTypes().length;
                if (argCount == 0) {
                    if (methodName.startsWith("get") || methodName.startsWith("is") && BeanBuilder.returnsBoolean(m)) {
                        this.addGetter(m);
                        continue;
                    }
                } else if (argCount == 1 && methodName.startsWith("set")) {
                    this.addSetter(m);
                    continue;
                }
                if (BeanUtil.isConcrete(m) || this._unsupportedMethods.containsKey(methodName)) continue;
                if (failOnUnrecognized) {
                    throw new IllegalArgumentException("Unrecognized abstract method '" + methodName + "' (not a getter or setter) -- to avoid exception, disable AbstractTypeMaterializer.Feature.FAIL_ON_UNMATERIALIZED_METHOD");
                }
                this._unsupportedMethods.put(methodName, m);
            }
        }
        return this;
    }

    public byte[] build(String className) {
        String superName;
        ClassWriter cw = new ClassWriter(1);
        String internalClass = BeanBuilder.getInternalClassName(className);
        String implName = BeanBuilder.getInternalClassName(this._implementedType.getName());
        if (this._implementedType.isInterface()) {
            superName = "java/lang/Object";
            cw.visit(49, 33, internalClass, null, superName, new String[]{implName});
        } else {
            superName = implName;
            cw.visit(49, 33, internalClass, null, implName, null);
        }
        cw.visitSource(className + ".java", null);
        BeanBuilder.generateDefaultConstructor(cw, superName);
        for (POJOProperty prop : this._beanProperties.values()) {
            TypeDescription type = prop.selectType(this._typeFactory);
            BeanBuilder.createField(cw, prop, type);
            if (!prop.hasConcreteGetter()) {
                BeanBuilder.createGetter(cw, internalClass, prop, type);
            }
            if (prop.hasConcreteSetter()) continue;
            BeanBuilder.createSetter(cw, internalClass, prop, type);
        }
        for (Method m : this._unsupportedMethods.values()) {
            BeanBuilder.createUnimplementedMethod(cw, internalClass, m);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static String getPropertyName(String methodName) {
        int prefixLen = methodName.startsWith("is") ? 2 : 3;
        String body = methodName.substring(prefixLen);
        StringBuilder sb = new StringBuilder(body);
        sb.setCharAt(0, Character.toLowerCase(body.charAt(0)));
        return sb.toString();
    }

    private static String buildGetterName(String fieldName) {
        StringBuilder sb = new StringBuilder(fieldName.length());
        return sb.append("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
    }

    private static String buildSetterName(String fieldName) {
        StringBuilder sb = new StringBuilder(fieldName.length());
        return sb.append("set").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
    }

    private static String getInternalClassName(String className) {
        return className.replace(".", "/");
    }

    private void addGetter(Method m) {
        POJOProperty prop = this.findProperty(BeanBuilder.getPropertyName(m.getName()));
        if (prop.getGetter() == null) {
            prop.setGetter(m);
        }
    }

    private void addSetter(Method m) {
        POJOProperty prop = this.findProperty(BeanBuilder.getPropertyName(m.getName()));
        if (prop.getSetter() == null) {
            prop.setSetter(m);
        }
    }

    private POJOProperty findProperty(String propName) {
        POJOProperty prop = this._beanProperties.get(propName);
        if (prop == null) {
            prop = new POJOProperty(propName, this._implementedType);
            this._beanProperties.put(propName, prop);
        }
        return prop;
    }

    private static final boolean returnsBoolean(Method m) {
        Class<?> rt = m.getReturnType();
        return rt == Boolean.class || rt == Boolean.TYPE;
    }

    protected static void generateDefaultConstructor(ClassWriter cw, String superName) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createField(ClassWriter cw, POJOProperty prop, TypeDescription type) {
        String sig = type.hasGenerics() ? type.genericSignature() : null;
        String desc = type.erasedSignature();
        FieldVisitor fv = cw.visitField(1, prop.getFieldName(), desc, sig, null);
        fv.visitEnd();
    }

    private static void createSetter(ClassWriter cw, String internalClassName, POJOProperty prop, TypeDescription propertyType) {
        String methodName;
        String desc;
        Method setter = prop.getSetter();
        if (setter != null) {
            desc = Type.getMethodDescriptor(setter);
            methodName = setter.getName();
        } else {
            desc = "(" + propertyType.erasedSignature() + ")V";
            methodName = BeanBuilder.buildSetterName(prop.getName());
        }
        String sig = propertyType.hasGenerics() ? "(" + propertyType.genericSignature() + ")V" : null;
        MethodVisitor mv = cw.visitMethod(1, methodName, desc, sig, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(propertyType.getLoadOpcode(), 1);
        mv.visitFieldInsn(181, internalClassName, prop.getFieldName(), propertyType.erasedSignature());
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createGetter(ClassWriter cw, String internalClassName, POJOProperty prop, TypeDescription propertyType) {
        String methodName;
        String desc;
        Method getter = prop.getGetter();
        if (getter != null) {
            desc = Type.getMethodDescriptor(getter);
            methodName = getter.getName();
        } else {
            desc = "()" + propertyType.erasedSignature();
            methodName = BeanBuilder.buildGetterName(prop.getName());
        }
        String sig = propertyType.hasGenerics() ? "()" + propertyType.genericSignature() : null;
        MethodVisitor mv = cw.visitMethod(1, methodName, desc, sig, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalClassName, prop.getFieldName(), propertyType.erasedSignature());
        mv.visitInsn(propertyType.getReturnOpcode());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createUnimplementedMethod(ClassWriter cw, String internalClassName, Method method) {
        String exceptionName = BeanBuilder.getInternalClassName(UnsupportedOperationException.class.getName());
        String sig = Type.getMethodDescriptor(method);
        String name = method.getName();
        MethodVisitor mv = cw.visitMethod(1, name, sig, null, null);
        mv.visitTypeInsn(187, exceptionName);
        mv.visitInsn(89);
        mv.visitLdcInsn("Unimplemented method '" + name + "' (not a setter/getter, could not materialize)");
        mv.visitMethodInsn(183, exceptionName, "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeDescription {
        private final Type _asmType;
        private JavaType _jacksonType;

        public TypeDescription(JavaType type) {
            this._jacksonType = type;
            this._asmType = Type.getType(type.getRawClass());
        }

        public Class<?> getRawClass() {
            return this._jacksonType.getRawClass();
        }

        public String erasedSignature() {
            return this._jacksonType.getErasedSignature();
        }

        public String genericSignature() {
            return this._jacksonType.getGenericSignature();
        }

        public boolean hasGenerics() {
            return this._jacksonType.hasGenericTypes();
        }

        public int getLoadOpcode() {
            return this._asmType.getOpcode(21);
        }

        public int getReturnOpcode() {
            return this._asmType.getOpcode(172);
        }

        public String toString() {
            return this._jacksonType.toString();
        }

        public static TypeDescription moreSpecificType(TypeDescription desc1, TypeDescription desc2) {
            Class<?> c2;
            Class<?> c1 = desc1.getRawClass();
            if (c1.isAssignableFrom(c2 = desc2.getRawClass())) {
                return desc2;
            }
            if (c2.isAssignableFrom(c1)) {
                return desc1;
            }
            return null;
        }
    }
}

