/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.module.kotlin.ConstructorValueCreator;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.MethodValueCreator;
import com.fasterxml.jackson.module.kotlin.ReflectionCache;
import com.fasterxml.jackson.module.kotlin.ValueCreator;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ/\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0011H\u0002J\f\u0010\u0016\u001a\u00020\u0006*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0006*\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0006*\u00020 H\u0002J\f\u0010!\u001a\u00020\u0006*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinValueInstantiator;", "Lcom/fasterxml/jackson/databind/deser/std/StdValueInstantiator;", "src", "cache", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "nullToEmptyCollection", "", "nullToEmptyMap", "nullIsSameAsDefault", "strictNullChecks", "(Lcom/fasterxml/jackson/databind/deser/std/StdValueInstantiator;Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;ZZZZ)V", "createFromObjectWith", "", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "props", "", "Lcom/fasterxml/jackson/databind/deser/SettableBeanProperty;", "buffer", "Lcom/fasterxml/jackson/databind/deser/impl/PropertyValueBuffer;", "(Lcom/fasterxml/jackson/databind/DeserializationContext;[Lcom/fasterxml/jackson/databind/deser/SettableBeanProperty;Lcom/fasterxml/jackson/databind/deser/impl/PropertyValueBuffer;)Ljava/lang/Object;", "hasInjectableValueId", "isGenericTypeVar", "Lkotlin/reflect/KType;", "isPrimitive", "Lkotlin/reflect/KParameter;", "markedNonNullAt", "", "Lkotlin/reflect/KTypeProjection;", "index", "", "requireEmptyValue", "Lcom/fasterxml/jackson/databind/JavaType;", "skipNulls", "jackson-module-kotlin"})
public final class KotlinValueInstantiator
extends StdValueInstantiator {
    @NotNull
    private final ReflectionCache cache;
    private final boolean nullToEmptyCollection;
    private final boolean nullToEmptyMap;
    private final boolean nullIsSameAsDefault;
    private final boolean strictNullChecks;

    public KotlinValueInstantiator(@NotNull StdValueInstantiator src, @NotNull ReflectionCache cache, boolean nullToEmptyCollection, boolean nullToEmptyMap, boolean nullIsSameAsDefault, boolean strictNullChecks) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        super(src);
        this.cache = cache;
        this.nullToEmptyCollection = nullToEmptyCollection;
        this.nullToEmptyMap = nullToEmptyMap;
        this.nullIsSameAsDefault = nullIsSameAsDefault;
        this.strictNullChecks = strictNullChecks;
    }

    private final boolean requireEmptyValue(JavaType $this$requireEmptyValue) {
        return this.nullToEmptyCollection && $this$requireEmptyValue.isCollectionLikeType() || this.nullToEmptyMap && $this$requireEmptyValue.isMapLikeType();
    }

    private final boolean isGenericTypeVar(KType $this$isGenericTypeVar) {
        return ReflectJvmMapping.getJavaType((KType)$this$isGenericTypeVar) instanceof TypeVariable;
    }

    private final boolean markedNonNullAt(List<KTypeProjection> $this$markedNonNullAt, int index) {
        KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.getOrNull($this$markedNonNullAt, (int)index);
        return kTypeProjection != null && (kTypeProjection = kTypeProjection.getType()) != null ? !kTypeProjection.isMarkedNullable() : false;
    }

    private final boolean skipNulls(SettableBeanProperty $this$skipNulls) {
        return this.nullIsSameAsDefault || $this$skipNulls.getMetadata().getValueNulls() == Nulls.SKIP;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object createFromObjectWith(@NotNull DeserializationContext ctxt, @NotNull SettableBeanProperty[] props, @NotNull PropertyValueBuffer buffer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        AnnotatedWithParams annotatedWithParams = this._withArgsCreator;
        Intrinsics.checkNotNullExpressionValue((Object)annotatedWithParams, (String)"_withArgsCreator");
        ValueCreator<?> valueCreator = this.cache.valueCreatorFromJava(annotatedWithParams);
        if (valueCreator == null) {
            return super.createFromObjectWith(ctxt, props, buffer);
        }
        ValueCreator<?> valueCreator2 = valueCreator;
        int propCount = 0;
        int numCallableParameters = 0;
        KParameter[] callableParameters = null;
        Object[] jsonParamValueList = null;
        if (valueCreator2 instanceof MethodValueCreator) {
            Object[] objectArray;
            propCount = props.length + 1;
            numCallableParameters = 1;
            KParameter[] $this$createFromObjectWith_u24lambda_u2d0 = objectArray = new KParameter[propCount];
            boolean bl = false;
            $this$createFromObjectWith_u24lambda_u2d0[0] = ((MethodValueCreator)valueCreator2).getInstanceParameter();
            callableParameters = objectArray;
            Object[] $this$createFromObjectWith_u24lambda_u2d1 = objectArray = new Object[propCount];
            boolean bl2 = false;
            $this$createFromObjectWith_u24lambda_u2d1[0] = ((MethodValueCreator)valueCreator2).getCompanionObjectInstance();
            jsonParamValueList = objectArray;
        } else {
            propCount = props.length;
            numCallableParameters = 0;
            callableParameters = new KParameter[propCount];
            jsonParamValueList = new Object[propCount];
        }
        Iterable $this$forEachIndexed$iv = valueCreator2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object2;
            void paramDef;
            boolean isMissing;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KParameter kParameter = (KParameter)item$iv;
            int idx = n;
            boolean bl = false;
            SettableBeanProperty jsonProp = props[idx];
            boolean bl3 = isMissing = !buffer.hasParameter(jsonProp);
            if (isMissing && paramDef.isOptional()) continue;
            KType paramType = paramDef.getType();
            if (!isMissing || this.isPrimitive((KParameter)paramDef) || this.hasInjectableValueId(jsonProp)) {
                Object tempParamVal = buffer.getParameter(jsonProp);
                if (tempParamVal == null && this.skipNulls(jsonProp) && paramDef.isOptional()) continue;
                object2 = tempParamVal;
            } else if (paramType.isMarkedNullable()) {
                object2 = null;
            } else {
                JsonDeserializer jsonDeserializer = jsonProp.getValueDeserializer();
                object2 = jsonDeserializer != null ? jsonDeserializer.getAbsentValue(ctxt) : null;
            }
            Object paramVal = object2;
            JavaType propType = jsonProp.getType();
            if (paramVal == null) {
                Intrinsics.checkNotNullExpressionValue((Object)propType, (String)"propType");
                if (this.requireEmptyValue(propType)) {
                    paramVal = new NullsAsEmptyProvider(jsonProp.getValueDeserializer()).getNullValue(ctxt);
                } else {
                    boolean isMissingAndRequired;
                    boolean bl4 = isMissingAndRequired = isMissing && jsonProp.isRequired();
                    if (isMissingAndRequired || !paramType.isMarkedNullable() && !this.isGenericTypeVar(paramType)) {
                        MismatchedInputException mismatchedInputException = MismatchedInputException.from((JsonParser)ctxt.getParser(), (JavaType)propType, (String)("Instantiation of " + this.getValueTypeDesc() + " value failed for JSON property " + jsonProp.getName() + " due to missing (therefore NULL) value for creator parameter " + paramDef.getName() + " which is a non-nullable type"));
                        Intrinsics.checkNotNullExpressionValue((Object)mismatchedInputException, (String)"from(\n                  \u2026                        )");
                        JsonMappingException jsonMappingException = (JsonMappingException)mismatchedInputException;
                        Class clazz = this.getValueClass();
                        String string = jsonProp.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonProp.name");
                        JsonMappingException jsonMappingException2 = ExtensionsKt.wrapWithPath(jsonMappingException, (Object)clazz, string);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonMappingException2, (String)"from(\n                  \u2026alueClass, jsonProp.name)");
                        throw (Throwable)jsonMappingException2;
                    }
                }
            } else if (this.strictNullChecks) {
                Object it;
                Object element$iv;
                Iterator<Object> iterator;
                boolean $i$f$any;
                Object[] $this$any$iv;
                List arguments = paramType.getArguments();
                String paramTypeStr = null;
                KType itemType = null;
                if (propType.isCollectionLikeType() && this.markedNonNullAt(arguments, 0)) {
                    boolean bl5;
                    block33: {
                        $this$any$iv = (Collection)paramVal;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                it = element$iv = iterator.next();
                                boolean bl6 = false;
                                if (!(it == null)) continue;
                                bl5 = true;
                                break block33;
                            }
                            bl5 = false;
                        }
                    }
                    if (bl5) {
                        paramTypeStr = "collection";
                        itemType = ((KTypeProjection)arguments.get(0)).getType();
                    }
                }
                if (propType.isMapLikeType() && this.markedNonNullAt(arguments, 1)) {
                    boolean bl7;
                    block34: {
                        $this$any$iv = (Map)paramVal;
                        $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl7 = false;
                        } else {
                            iterator = $this$any$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                it = element$iv = (Map.Entry)iterator.next();
                                boolean bl8 = false;
                                if (!(it.getValue() == null)) continue;
                                bl7 = true;
                                break block34;
                            }
                            bl7 = false;
                        }
                    }
                    if (bl7) {
                        paramTypeStr = "map";
                        itemType = ((KTypeProjection)arguments.get(1)).getType();
                    }
                }
                if (propType.isArrayType() && this.markedNonNullAt(arguments, 0)) {
                    boolean bl9;
                    block35: {
                        $this$any$iv = (Object[])paramVal;
                        $i$f$any = false;
                        int n2 = $this$any$iv.length;
                        for (int i = 0; i < n2; ++i) {
                            Object element$iv2;
                            Object it2 = element$iv2 = $this$any$iv[i];
                            boolean bl10 = false;
                            if (!(it2 == null)) continue;
                            bl9 = true;
                            break block35;
                        }
                        bl9 = false;
                    }
                    if (bl9) {
                        paramTypeStr = "array";
                        itemType = ((KTypeProjection)arguments.get(0)).getType();
                    }
                }
                if (paramTypeStr != null && itemType != null) {
                    MismatchedInputException mismatchedInputException = MismatchedInputException.from((JsonParser)ctxt.getParser(), (JavaType)propType, (String)("Instantiation of " + itemType + ' ' + paramTypeStr + " failed for JSON property " + jsonProp.getName() + " due to null value in a " + paramTypeStr + " that does not allow null values"));
                    Intrinsics.checkNotNullExpressionValue((Object)mismatchedInputException, (String)"from(\n                  \u2026es\"\n                    )");
                    JsonMappingException jsonMappingException = (JsonMappingException)mismatchedInputException;
                    Class clazz = this.getValueClass();
                    String string = jsonProp.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonProp.name");
                    JsonMappingException jsonMappingException3 = ExtensionsKt.wrapWithPath(jsonMappingException, (Object)clazz, string);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonMappingException3, (String)"from(\n                  \u2026alueClass, jsonProp.name)");
                    throw (Throwable)jsonMappingException3;
                }
            }
            jsonParamValueList[numCallableParameters] = paramVal;
            callableParameters[numCallableParameters] = paramDef;
            ++numCallableParameters;
        }
        if (numCallableParameters == jsonParamValueList.length && valueCreator2 instanceof ConstructorValueCreator) {
            object = super.createFromObjectWith(ctxt, jsonParamValueList);
        } else {
            void $this$mapIndexedTo$iv$iv;
            valueCreator2.checkAccessibility(ctxt);
            LinkedHashMap callableParametersByName = new LinkedHashMap();
            KParameter[] $this$mapIndexed$iv = callableParameters;
            boolean $i$f$mapIndexed = false;
            KParameter[] kParameterArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void paramDef;
                int n = index$iv$iv++;
                void isMissing = item$iv$iv;
                int paramType = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (paramDef != null) {
                    void idx;
                    ((Map)callableParametersByName).put(paramDef, jsonParamValueList[idx]);
                }
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            object = valueCreator2.callBy(callableParametersByName);
        }
        return object;
    }

    private final boolean isPrimitive(KParameter $this$isPrimitive) {
        Type javaType = ReflectJvmMapping.getJavaType((KType)$this$isPrimitive.getType());
        return javaType instanceof Class ? ((Class)javaType).isPrimitive() : false;
    }

    private final boolean hasInjectableValueId(SettableBeanProperty $this$hasInjectableValueId) {
        return $this$hasInjectableValueId.getInjectableValueId() != null;
    }
}

