/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.module.kotlin.ConstructorValueCreator;
import com.fasterxml.jackson.module.kotlin.MethodValueCreator;
import com.fasterxml.jackson.module.kotlin.ValueCreator;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0018J+\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00112\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0018\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0014J\u0014\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "Ljava/io/Serializable;", "reflectionCacheSize", "", "(I)V", "javaConstructorIsCreatorAnnotated", "Lcom/fasterxml/jackson/databind/util/LRUMap;", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedConstructor;", "", "javaConstructorToKotlin", "Ljava/lang/reflect/Constructor;", "", "Lkotlin/reflect/KFunction;", "javaExecutableToValueCreator", "Ljava/lang/reflect/Executable;", "Lcom/fasterxml/jackson/module/kotlin/ValueCreator;", "javaMemberIsRequired", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedMember;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "javaMethodToKotlin", "Ljava/lang/reflect/Method;", "checkConstructorIsCreatorAnnotated", "key", "calc", "Lkotlin/Function1;", "(Lcom/fasterxml/jackson/databind/introspect/AnnotatedMember;Lkotlin/jvm/functions/Function1;)Ljava/lang/Boolean;", "kotlinFromJava", "valueCreatorFromJava", "_withArgsCreator", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedWithParams;", "BooleanTriState", "Companion", "jackson-module-kotlin"})
public final class ReflectionCache
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LRUMap<Constructor<Object>, KFunction<Object>> javaConstructorToKotlin;
    @NotNull
    private final LRUMap<Method, KFunction<?>> javaMethodToKotlin;
    @NotNull
    private final LRUMap<Executable, ValueCreator<?>> javaExecutableToValueCreator;
    @NotNull
    private final LRUMap<AnnotatedConstructor, Boolean> javaConstructorIsCreatorAnnotated;
    @NotNull
    private final LRUMap<AnnotatedMember, BooleanTriState> javaMemberIsRequired;
    private static final long serialVersionUID = 1L;

    public ReflectionCache(int reflectionCacheSize) {
        this.javaConstructorToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaMethodToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaExecutableToValueCreator = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaConstructorIsCreatorAnnotated = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaMemberIsRequired = new LRUMap(reflectionCacheSize, reflectionCacheSize);
    }

    @Nullable
    public final KFunction<Object> kotlinFromJava(@NotNull Constructor<Object> key) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        KFunction kFunction2 = (KFunction)this.javaConstructorToKotlin.get(key);
        if (kFunction2 == null) {
            KFunction kFunction3 = ReflectJvmMapping.getKotlinFunction(key);
            if (kFunction3 == null) {
                kFunction = null;
            } else {
                KFunction kFunction4 = kFunction3;
                boolean bl = false;
                boolean bl2 = false;
                KFunction it = kFunction4;
                boolean bl3 = false;
                KFunction kFunction5 = (KFunction)this.javaConstructorToKotlin.putIfAbsent(key, (Object)it);
                kFunction = kFunction5 == null ? it : kFunction5;
            }
        } else {
            kFunction = kFunction2;
        }
        return kFunction;
    }

    @Nullable
    public final KFunction<?> kotlinFromJava(@NotNull Method key) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KFunction kFunction2 = (KFunction)this.javaMethodToKotlin.get((Object)key);
        if (kFunction2 == null) {
            KFunction kFunction3 = ReflectJvmMapping.getKotlinFunction((Method)key);
            if (kFunction3 == null) {
                kFunction = null;
            } else {
                KFunction kFunction4 = kFunction3;
                boolean bl = false;
                boolean bl2 = false;
                KFunction it = kFunction4;
                boolean bl3 = false;
                KFunction kFunction5 = (KFunction)this.javaMethodToKotlin.putIfAbsent((Object)key, (Object)it);
                kFunction = kFunction5 == null ? it : kFunction5;
            }
        } else {
            kFunction = kFunction2;
        }
        return kFunction;
    }

    @Nullable
    public final ValueCreator<?> valueCreatorFromJava(@NotNull AnnotatedWithParams _withArgsCreator) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)_withArgsCreator, (String)"_withArgsCreator");
        AnnotatedWithParams annotatedWithParams = _withArgsCreator;
        if (annotatedWithParams instanceof AnnotatedConstructor) {
            Object object2 = ((AnnotatedConstructor)_withArgsCreator).getAnnotated();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.Constructor<kotlin.Any>");
            }
            Object constructor = object2;
            if ((object2 = (ValueCreator)this.javaExecutableToValueCreator.get(constructor)) == null) {
                KFunction<Object> kFunction = this.kotlinFromJava((Constructor<Object>)constructor);
                if (kFunction == null) {
                    object = null;
                } else {
                    KFunction<Object> kFunction2 = kFunction;
                    boolean bl = false;
                    boolean bl2 = false;
                    KFunction<Object> it = kFunction2;
                    boolean bl3 = false;
                    ConstructorValueCreator<Object> value = new ConstructorValueCreator<Object>(it);
                    ValueCreator valueCreator = (ValueCreator)this.javaExecutableToValueCreator.putIfAbsent(constructor, value);
                    object = valueCreator == null ? (ValueCreator)value : valueCreator;
                }
            } else {
                object = object2;
            }
        } else if (annotatedWithParams instanceof AnnotatedMethod) {
            Method method = ((AnnotatedMethod)_withArgsCreator).getAnnotated();
            ValueCreator valueCreator = (ValueCreator)this.javaExecutableToValueCreator.get((Object)method);
            if (valueCreator == null) {
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                KFunction<?> kFunction = this.kotlinFromJava(method);
                if (kFunction == null) {
                    object = null;
                } else {
                    KFunction<?> kFunction3 = kFunction;
                    boolean bl = false;
                    boolean bl4 = false;
                    KFunction<?> it = kFunction3;
                    boolean bl5 = false;
                    MethodValueCreator<?> value = MethodValueCreator.Companion.of(it);
                    ValueCreator valueCreator2 = (ValueCreator)this.javaExecutableToValueCreator.putIfAbsent((Object)method, value);
                    object = valueCreator2 == null ? (ValueCreator)value : valueCreator2;
                }
            } else {
                object = valueCreator;
            }
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Expected a constructor or method to create a Kotlin object, instead found ", (Object)_withArgsCreator.getAnnotated().getClass().getName()));
        }
        return object;
    }

    public final boolean checkConstructorIsCreatorAnnotated(@NotNull AnnotatedConstructor key, @NotNull Function1<? super AnnotatedConstructor, Boolean> calc) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(calc, (String)"calc");
        Boolean bl2 = (Boolean)this.javaConstructorIsCreatorAnnotated.get((Object)key);
        if (bl2 == null) {
            Object object = calc.invoke((Object)key);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean it = (Boolean)object;
            boolean bl5 = false;
            Boolean bl6 = (Boolean)this.javaConstructorIsCreatorAnnotated.putIfAbsent((Object)key, (Object)it);
            bl = bl6 == null ? it : bl6;
        } else {
            bl = bl2;
        }
        return bl;
    }

    @Nullable
    public final Boolean javaMemberIsRequired(@NotNull AnnotatedMember key, @NotNull Function1<? super AnnotatedMember, Boolean> calc) {
        Boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(calc, (String)"calc");
        Object object = (BooleanTriState)this.javaMemberIsRequired.get((Object)key);
        Boolean bl3 = bl2 = object == null ? null : ((BooleanTriState)object).getValue();
        if (bl2 == null) {
            Boolean bl4;
            object = calc.invoke((Object)key);
            boolean bl5 = false;
            boolean bl6 = false;
            Boolean it = (Boolean)object;
            boolean bl7 = false;
            BooleanTriState booleanTriState = (BooleanTriState)this.javaMemberIsRequired.putIfAbsent((Object)key, (Object)BooleanTriState.Companion.fromBoolean(it));
            bl = booleanTriState == null ? it : ((bl4 = booleanTriState.getValue()) == null ? it : bl4);
        } else {
            bl = bl2;
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$Companion;", "", "()V", "serialVersionUID", "", "jackson-module-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0004\b\t\n\u000bB\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "", "value", "", "(Ljava/lang/Boolean;)V", "getValue", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "Companion", "Empty", "False", "True", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$True;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$False;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Empty;", "jackson-module-kotlin"})
    public static abstract class BooleanTriState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Boolean value;
        @NotNull
        private static final True TRUE = new True();
        @NotNull
        private static final False FALSE = new False();
        @NotNull
        private static final Empty EMPTY = new Empty();

        private BooleanTriState(Boolean value) {
            this.value = value;
        }

        @Nullable
        public final Boolean getValue() {
            return this.value;
        }

        public /* synthetic */ BooleanTriState(Boolean value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$True;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "()V", "jackson-module-kotlin"})
        public static final class True
        extends BooleanTriState {
            public True() {
                super(true, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$False;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "()V", "jackson-module-kotlin"})
        public static final class False
        extends BooleanTriState {
            public False() {
                super(false, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Empty;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "()V", "jackson-module-kotlin"})
        public static final class Empty
        extends BooleanTriState {
            public Empty() {
                super(null, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Companion;", "", "()V", "EMPTY", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Empty;", "FALSE", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$False;", "TRUE", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$True;", "fromBoolean", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "value", "", "(Ljava/lang/Boolean;)Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "jackson-module-kotlin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BooleanTriState fromBoolean(@Nullable Boolean value) {
                BooleanTriState booleanTriState;
                Boolean bl = value;
                if (bl == null) {
                    booleanTriState = EMPTY;
                } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                    booleanTriState = TRUE;
                } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                    booleanTriState = FALSE;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return booleanTriState;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

