/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectSchema
extends ContainerTypeSchema {
    @JsonProperty
    private AdditionalProperties additionalProperties;
    @JsonProperty
    private List<Dependency> dependencies;
    @JsonProperty
    private Map<String, JsonSchema> patternProperties;
    @JsonProperty
    private Map<String, JsonSchema> properties;
    @JsonIgnore
    private final JsonFormatTypes type = JsonFormatTypes.OBJECT;

    public ObjectSchema() {
        this.dependencies = new ArrayList<Dependency>();
        this.patternProperties = new HashMap<String, JsonSchema>();
        this.properties = new HashMap<String, JsonSchema>();
    }

    public boolean addSchemaDependency(String string, JsonSchema jsonSchema) {
        return this.dependencies.add(new SchemaDependency(string, jsonSchema));
    }

    public boolean addSimpleDependency(String string, String string2) {
        return this.dependencies.add(new SimpleDependency(string, string2));
    }

    @Override
    public ObjectSchema asObjectSchema() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)object;
            return this.getAdditionalProperties() == null ? objectSchema.getAdditionalProperties() == null : (this.getAdditionalProperties().equals(objectSchema.getAdditionalProperties()) && this.getDependencies() == null ? objectSchema.getDependencies() == null : (this.getDependencies().equals(objectSchema.getDependencies()) && this.getPatternProperties() == null ? objectSchema.getPatternProperties() == null : (this.getPatternProperties().equals(objectSchema.getPatternProperties()) && this.getProperties() == null ? objectSchema.getProperties() == null : this.getProperties().equals(objectSchema.getProperties()) && super.equals(object))));
        }
        return false;
    }

    public AdditionalProperties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Map<String, JsonSchema> getPatternProperties() {
        return this.patternProperties;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    @Override
    public JsonFormatTypes getType() {
        return this.type;
    }

    @Override
    public boolean isObjectSchema() {
        return true;
    }

    public void putOptionalProperty(String string, JsonSchema jsonSchema) {
        this.properties.put(string, jsonSchema);
    }

    public JsonSchema putPatternProperty(String string, JsonSchema jsonSchema) {
        return this.patternProperties.put(string, jsonSchema);
    }

    public JsonSchema putProperty(String string, JsonSchema jsonSchema) {
        jsonSchema.setRequired(true);
        return this.properties.put(string, jsonSchema);
    }

    public void rejectAdditionalProperties() {
        this.additionalProperties = NoAdditionalProperties.instance;
    }

    public void setAdditionalProperties(AdditionalProperties additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setDependencies(List<Dependency> list) {
        this.dependencies = list;
    }

    public void setPatternProperties(Map<String, JsonSchema> map) {
        this.patternProperties = map;
    }

    public void setProperties(Map<String, JsonSchema> map) {
        this.properties = map;
    }

    public static class SimpleDependency
    extends Dependency {
        @JsonProperty(required=true)
        private String depender;
        @JsonProperty(required=true)
        private String dependsOn;

        public SimpleDependency(String string, String string2) {
            this.depender = string;
            this.dependsOn = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof SchemaDependency) {
                SimpleDependency simpleDependency = (SimpleDependency)object;
                return this.getDepender() == null ? simpleDependency.getDepender() == null : (this.getDepender().equals(simpleDependency.getDepender()) && this.getDependsOn() == null ? simpleDependency.getDependsOn() == null : this.getDependsOn().equals(simpleDependency.getDependsOn()));
            }
            return false;
        }

        public String getDepender() {
            return this.depender;
        }

        public String getDependsOn() {
            return this.dependsOn;
        }
    }

    public static class SchemaDependency
    extends Dependency {
        @JsonProperty(required=true)
        private String depender;
        @JsonProperty(required=true)
        private JsonSchema parentMustMatch;

        public SchemaDependency(String string, JsonSchema jsonSchema) {
            this.depender = string;
            this.parentMustMatch = jsonSchema;
        }

        public boolean equals(Object object) {
            if (object instanceof SchemaDependency) {
                SchemaDependency schemaDependency = (SchemaDependency)object;
                return this.getDepender() == null ? schemaDependency.getDepender() == null : (this.getDepender().equals(schemaDependency.getDepender()) && this.getParentMustMatch() == null ? schemaDependency.getParentMustMatch() == null : this.getParentMustMatch().equals(schemaDependency.getParentMustMatch()));
            }
            return false;
        }

        public String getDepender() {
            return this.depender;
        }

        public JsonSchema getParentMustMatch() {
            return this.parentMustMatch;
        }
    }

    public static class SchemaAdditionalProperties
    extends AdditionalProperties {
        @JsonProperty
        private JsonSchema jsonSchema;

        public boolean equals(Object object) {
            return object instanceof SchemaAdditionalProperties && this.getJsonSchema() == null ? ((SchemaAdditionalProperties)object).getJsonSchema() == null : this.getJsonSchema().equals(((SchemaAdditionalProperties)object).getJsonSchema());
        }

        public JsonSchema getJsonSchema() {
            return this.jsonSchema;
        }

        public SchemaAdditionalProperties(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }
    }

    public static class NoAdditionalProperties
    extends AdditionalProperties {
        public final Boolean schema = false;
        public static final NoAdditionalProperties instance = new NoAdditionalProperties();

        protected NoAdditionalProperties() {
        }

        public boolean equals(Object object) {
            return object instanceof NoAdditionalProperties;
        }

        @JsonValue
        public Boolean value() {
            return this.schema;
        }
    }

    public static abstract class Dependency {
        @JsonCreator
        public Dependency jsonCreator() {
            return null;
        }
    }

    public static abstract class AdditionalProperties {
        @JsonCreator
        public AdditionalProperties jsonCreator() {
            return null;
        }
    }
}

