/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.customProperties;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.ArrayVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;

public class TitleSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    private WrapperFactory wrapperFactory = new WrapperFactory(){

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider serializerProvider) {
            TitleSchemaFactoryWrapper titleSchemaFactoryWrapper = new TitleSchemaFactoryWrapper();
            titleSchemaFactoryWrapper.setProvider(TitleSchemaFactoryWrapper.this.getProvider());
            return titleSchemaFactoryWrapper;
        }
    };

    private void addTitle(JsonSchema jsonSchema, JavaType javaType) {
        if (!jsonSchema.isSimpleTypeSchema()) {
            throw new RuntimeException("given non simple type schema: " + jsonSchema.getType());
        }
        jsonSchema.asSimpleTypeSchema().setTitle(javaType.getGenericSignature());
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType javaType) {
        ObjectVisitor objectVisitor = (ObjectVisitor)super.expectObjectFormat(javaType);
        objectVisitor.setWrapperFactory(this.wrapperFactory);
        this.addTitle(objectVisitor.getSchema(), javaType);
        return objectVisitor;
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType javaType) {
        ArrayVisitor arrayVisitor = (ArrayVisitor)super.expectArrayFormat(javaType);
        arrayVisitor.setWrapperFactory(this.wrapperFactory);
        this.addTitle(arrayVisitor.getSchema(), javaType);
        return arrayVisitor;
    }
}

