/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;

public class ObjectVisitor
extends JsonObjectFormatVisitor.Base
implements JsonSchemaProducer {
    protected final ObjectSchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory = new WrapperFactory();

    public ObjectVisitor(SerializerProvider provider, ObjectSchema schema) {
        this.provider = provider;
        this.schema = schema;
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    public void optionalProperty(BeanProperty writer) throws JsonMappingException {
        this.schema.putOptionalProperty(writer.getName(), this.propertySchema(writer));
    }

    public void optionalProperty(String name) throws JsonMappingException {
        this.schema.putOptionalProperty(name, JsonSchema.minimalForFormat(JsonFormatTypes.ANY));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        this.schema.putOptionalProperty(name, this.propertySchema(handler, propertyTypeHint));
    }

    public void property(BeanProperty writer) throws JsonMappingException {
        this.schema.putProperty(writer.getName(), this.propertySchema(writer));
    }

    public void property(String name) throws JsonMappingException {
        this.schema.putProperty(name, JsonSchema.minimalForFormat(JsonFormatTypes.ANY));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        this.schema.putProperty(name, this.propertySchema(handler, propertyTypeHint));
    }

    protected JsonSchema propertySchema(BeanProperty writer) throws JsonMappingException {
        if (writer == null) {
            throw new IllegalArgumentException("Null writer");
        }
        SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider());
        JsonSerializer<Object> ser = this.getSer(writer);
        if (ser != null) {
            JavaType type = writer.getType();
            if (type == null) {
                throw new IllegalStateException("Missing type for property '" + writer.getName() + "'");
            }
            ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, type);
        }
        return visitor.finalSchema();
    }

    protected JsonSchema propertySchema(JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, propertyTypeHint);
        return visitor.finalSchema();
    }

    protected JsonSerializer<Object> getSer(BeanProperty writer) throws JsonMappingException {
        JsonSerializer ser = null;
        if (writer instanceof BeanPropertyWriter) {
            ser = ((BeanPropertyWriter)writer).getSerializer();
        }
        if (ser == null) {
            ser = this.getProvider().findValueSerializer(writer.getType(), writer);
        }
        return ser;
    }
}

