/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.jakarta;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.AnySchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.NullSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.StringSchema;
import java.util.Arrays;

public class JsonSchemaIdResolver
extends TypeIdResolverBase {
    public String idFromValue(Object value) {
        if (value instanceof JsonSchema) {
            return ((JsonSchema)value).getType().value();
        }
        return null;
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JavaType typeFromId(DatabindContext ctxt, String id) {
        JsonFormatTypes stdType = JsonFormatTypes.forValue((String)id);
        if (stdType != null) {
            switch (stdType) {
                case ARRAY: {
                    return ctxt.constructType(ArraySchema.class);
                }
                case BOOLEAN: {
                    return ctxt.constructType(BooleanSchema.class);
                }
                case INTEGER: {
                    return ctxt.constructType(IntegerSchema.class);
                }
                case NULL: {
                    return ctxt.constructType(NullSchema.class);
                }
                case NUMBER: {
                    return ctxt.constructType(NumberSchema.class);
                }
                case OBJECT: {
                    return ctxt.constructType(ObjectSchema.class);
                }
                case STRING: {
                    return ctxt.constructType(StringSchema.class);
                }
            }
            return ctxt.constructType(AnySchema.class);
        }
        throw new IllegalArgumentException("Can not resolve JsonSchema 'type' id of \"" + id + "\", not recognized as one of standard values: " + Arrays.asList(JsonFormatTypes.values()));
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public void init(JavaType baseType) {
    }

    public String idFromBaseType() {
        return null;
    }
}

