/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.guice;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.inject.Qualifier;

public class GuiceAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public Object findInjectableValueId(AnnotatedMember m) {
        Annotation guiceAnnotation;
        AnnotatedMember guiceMember;
        if (m.getAnnotation(JacksonInject.class) == null && m.getAnnotation(javax.inject.Inject.class) == null && m.getAnnotation(Inject.class) == null) {
            return null;
        }
        if (m instanceof AnnotatedField || m instanceof AnnotatedParameter) {
            guiceMember = m;
            guiceAnnotation = this.findBindingAnnotation(m.annotations());
        } else if (m instanceof AnnotatedMethod) {
            AnnotatedMethod a = (AnnotatedMethod)m;
            if (a.getParameterCount() != 1) {
                return null;
            }
            guiceMember = a.getParameter(0);
            Annotation[] annotations = a.getMember().getParameterAnnotations()[0];
            guiceAnnotation = this.findBindingAnnotation(Arrays.asList(annotations));
        } else {
            return null;
        }
        if (guiceAnnotation == null) {
            return Key.get((Type)guiceMember.getRawType());
        }
        return Key.get((Type)guiceMember.getRawType(), (Annotation)guiceAnnotation);
    }

    private Annotation findBindingAnnotation(Iterable<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(BindingAnnotation.class) && !annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            return annotation;
        }
        return null;
    }
}

