/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.util;

import java.lang.reflect.Method;

public class MyClassLoader
extends ClassLoader {
    protected final boolean _cfgUseParentLoader;

    public MyClassLoader(ClassLoader parent, boolean tryToUseParent) {
        super(parent);
        this._cfgUseParentLoader = tryToUseParent;
    }

    public static boolean canAddClassInPackageOf(Class<?> cls) {
        Package beanPackage = cls.getPackage();
        if (beanPackage != null) {
            if (beanPackage.isSealed()) {
                return false;
            }
            String pname = beanPackage.getName();
            if (pname.startsWith("java.") || pname.startsWith("javax.security.")) {
                return false;
            }
        }
        return true;
    }

    public Class<?> loadAndResolve(String className, byte[] byteCode) throws IllegalArgumentException {
        Class<?> impl;
        ClassLoader cl;
        Class<?> old = this.findLoadedClass(className);
        if (old != null) {
            return old;
        }
        if (this._cfgUseParentLoader && (cl = this.getParent()) != null) {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                return (Class)method.invoke((Object)this.getParent(), className, byteCode, 0, byteCode.length);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            impl = this.defineClass(className, byteCode, 0, byteCode.length);
        }
        catch (LinkageError e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            t.printStackTrace();
            throw new IllegalArgumentException("Failed to load class '" + className + "': " + t.getMessage(), t);
        }
        this.resolveClass(impl);
        return impl;
    }
}

