/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableBooleanFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableBooleanMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableIntFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableIntMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableLongFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableLongMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableObjectFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableObjectMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableStringFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableStringMethodProperty;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class PropertyMutatorCollector
extends DynamicPropertyAccessorBase {
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final List<SettableIntMethodProperty> _intSetters = new LinkedList<SettableIntMethodProperty>();
    private final List<SettableLongMethodProperty> _longSetters = new LinkedList<SettableLongMethodProperty>();
    private final List<SettableBooleanMethodProperty> _booleanSetters = new LinkedList<SettableBooleanMethodProperty>();
    private final List<SettableStringMethodProperty> _stringSetters = new LinkedList<SettableStringMethodProperty>();
    private final List<SettableObjectMethodProperty> _objectSetters = new LinkedList<SettableObjectMethodProperty>();
    private final List<SettableIntFieldProperty> _intFields = new LinkedList<SettableIntFieldProperty>();
    private final List<SettableLongFieldProperty> _longFields = new LinkedList<SettableLongFieldProperty>();
    private final List<SettableBooleanFieldProperty> _booleanFields = new LinkedList<SettableBooleanFieldProperty>();
    private final List<SettableStringFieldProperty> _stringFields = new LinkedList<SettableStringFieldProperty>();
    private final List<SettableObjectFieldProperty> _objectFields = new LinkedList<SettableObjectFieldProperty>();
    private final Class<?> beanClass;
    private final String beanClassName;

    public PropertyMutatorCollector(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanClassName = Type.getInternalName(beanClass);
    }

    public SettableIntMethodProperty addIntSetter(SettableBeanProperty prop) {
        return this._add(this._intSetters, new SettableIntMethodProperty(prop, null, this._intSetters.size()));
    }

    public SettableLongMethodProperty addLongSetter(SettableBeanProperty prop) {
        return this._add(this._longSetters, new SettableLongMethodProperty(prop, null, this._longSetters.size()));
    }

    public SettableBooleanMethodProperty addBooleanSetter(SettableBeanProperty prop) {
        return this._add(this._booleanSetters, new SettableBooleanMethodProperty(prop, null, this._booleanSetters.size()));
    }

    public SettableStringMethodProperty addStringSetter(SettableBeanProperty prop) {
        return this._add(this._stringSetters, new SettableStringMethodProperty(prop, null, this._stringSetters.size()));
    }

    public SettableObjectMethodProperty addObjectSetter(SettableBeanProperty prop) {
        return this._add(this._objectSetters, new SettableObjectMethodProperty(prop, null, this._objectSetters.size()));
    }

    public SettableIntFieldProperty addIntField(SettableBeanProperty prop) {
        return this._add(this._intFields, new SettableIntFieldProperty(prop, null, this._intFields.size()));
    }

    public SettableLongFieldProperty addLongField(SettableBeanProperty prop) {
        return this._add(this._longFields, new SettableLongFieldProperty(prop, null, this._longFields.size()));
    }

    public SettableBooleanFieldProperty addBooleanField(SettableBeanProperty prop) {
        return this._add(this._booleanFields, new SettableBooleanFieldProperty(prop, null, this._booleanFields.size()));
    }

    public SettableStringFieldProperty addStringField(SettableBeanProperty prop) {
        return this._add(this._stringFields, new SettableStringFieldProperty(prop, null, this._stringFields.size()));
    }

    public SettableObjectFieldProperty addObjectField(SettableBeanProperty prop) {
        return this._add(this._objectFields, new SettableObjectFieldProperty(prop, null, this._objectFields.size()));
    }

    public BeanPropertyMutator buildMutator(MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        String srcName = this.beanClass.getName() + "$Access4JacksonDeserializer";
        String generatedClass = PropertyMutatorCollector.internalClassName(srcName);
        Class<?> accessorClass = null;
        try {
            accessorClass = classLoader.loadClass(srcName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (accessorClass == null) {
            accessorClass = this.generateMutatorClass(classLoader, srcName, generatedClass);
        }
        try {
            return (BeanPropertyMutator)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + srcName + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateMutatorClass(MyClassLoader classLoader, String srcName, String generatedClass) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = PropertyMutatorCollector.internalClassName(BeanPropertyMutator.class.getName());
        cw.visit(49, 49, generatedClass, null, superClass, null);
        cw.visitSource(srcName + ".java", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (!this._intFields.isEmpty()) {
            this._addFields(cw, this._intFields, "intField", Type.INT_TYPE, 21);
        }
        if (!this._longFields.isEmpty()) {
            this._addFields(cw, this._longFields, "longField", Type.LONG_TYPE, 22);
        }
        if (!this._booleanFields.isEmpty()) {
            this._addFields(cw, this._booleanFields, "booleanField", Type.BOOLEAN_TYPE, 21);
        }
        if (!this._stringFields.isEmpty()) {
            this._addFields(cw, this._stringFields, "stringField", STRING_TYPE, 25);
        }
        if (!this._objectFields.isEmpty()) {
            this._addFields(cw, this._objectFields, "objectField", OBJECT_TYPE, 25);
        }
        if (!this._intSetters.isEmpty()) {
            this._addSetters(cw, this._intSetters, "intSetter", Type.INT_TYPE, 21);
        }
        if (!this._longSetters.isEmpty()) {
            this._addSetters(cw, this._longSetters, "longSetter", Type.LONG_TYPE, 22);
        }
        if (!this._booleanSetters.isEmpty()) {
            this._addSetters(cw, this._booleanSetters, "booleanSetter", Type.BOOLEAN_TYPE, 21);
        }
        if (!this._stringSetters.isEmpty()) {
            this._addSetters(cw, this._stringSetters, "stringSetter", STRING_TYPE, 25);
        }
        if (!this._objectSetters.isEmpty()) {
            this._addSetters(cw, this._objectSetters, "objectSetter", OBJECT_TYPE, 25);
        }
        cw.visitEnd();
        byte[] byteCode = cw.toByteArray();
        return classLoader.loadAndResolve(srcName, byteCode);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addSetters(ClassWriter cw, List<T> props, String methodName, Type parameterType, int loadValueCode) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "(Ljava/lang/Object;I" + parameterType + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.beanClassName);
        int localVarIndex = 4 + (parameterType.equals(Type.LONG_TYPE) ? 1 : 0);
        mv.visitVarInsn(58, localVarIndex);
        boolean mustCast = parameterType.equals(OBJECT_TYPE);
        if (props.size() <= 4) {
            this._addSettersUsingIf(mv, props, loadValueCode, localVarIndex, mustCast);
        } else {
            this._addSettersUsingSwitch(mv, props, loadValueCode, localVarIndex, mustCast);
        }
        PropertyMutatorCollector.generateException(mv, this.beanClassName, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addFields(ClassWriter cw, List<T> props, String methodName, Type parameterType, int loadValueCode) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "(Ljava/lang/Object;I" + parameterType + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.beanClassName);
        int localVarIndex = 4 + (parameterType.equals(Type.LONG_TYPE) ? 1 : 0);
        mv.visitVarInsn(58, localVarIndex);
        boolean mustCast = parameterType.equals(OBJECT_TYPE);
        if (props.size() < 4) {
            this._addFieldsUsingIf(mv, props, loadValueCode, localVarIndex, mustCast);
        } else {
            this._addFieldsUsingSwitch(mv, props, loadValueCode, localVarIndex, mustCast);
        }
        PropertyMutatorCollector.generateException(mv, this.beanClassName, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addSettersUsingIf(MethodVisitor mv, List<T> props, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, beanIndex);
        mv.visitVarInsn(loadValueCode, 3);
        Method method = (Method)((OptimizedSettableBeanProperty)((Object)props.get(0))).getMember().getMember();
        Type type = Type.getType(method.getParameterTypes()[0]);
        if (mustCast) {
            mv.visitTypeInsn(192, type.getInternalName());
        }
        Type returnType = Type.getType(method.getReturnType());
        mv.visitMethodInsn(182, this.beanClassName, method.getName(), "(" + type + ")" + returnType, method.getDeclaringClass().isInterface());
        mv.visitInsn(177);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(ALL_INT_CONSTS[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            method = (Method)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember().getMember();
            type = Type.getType(method.getParameterTypes()[0]);
            returnType = Type.getType(method.getReturnType());
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitMethodInsn(182, this.beanClassName, method.getName(), "(" + type + ")" + returnType, method.getDeclaringClass().isInterface());
            mv.visitInsn(177);
        }
        mv.visitLabel(next);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addSettersUsingSwitch(MethodVisitor mv, List<T> props, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            Method method = (Method)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember().getMember();
            Type type = Type.getType(method.getParameterTypes()[0]);
            Type returnType = Type.getType(method.getReturnType());
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitMethodInsn(182, this.beanClassName, method.getName(), "(" + type + ")" + returnType, method.getDeclaringClass().isInterface());
            mv.visitInsn(177);
        }
        mv.visitLabel(defaultLabel);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addFieldsUsingIf(MethodVisitor mv, List<T> props, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, beanIndex);
        mv.visitVarInsn(loadValueCode, 3);
        AnnotatedField field = (AnnotatedField)((OptimizedSettableBeanProperty)((Object)props.get(0))).getMember();
        Type type = Type.getType(field.getRawType());
        if (mustCast) {
            mv.visitTypeInsn(192, type.getInternalName());
        }
        mv.visitFieldInsn(181, this.beanClassName, field.getName(), type.getDescriptor());
        mv.visitInsn(177);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(ALL_INT_CONSTS[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            field = (AnnotatedField)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember();
            type = Type.getType(field.getRawType());
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitFieldInsn(181, this.beanClassName, field.getName(), type.getDescriptor());
            mv.visitInsn(177);
        }
        mv.visitLabel(next);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addFieldsUsingSwitch(MethodVisitor mv, List<T> props, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            AnnotatedField field = (AnnotatedField)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember();
            Type type = Type.getType(field.getRawType());
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitFieldInsn(181, this.beanClassName, field.getName(), type.getDescriptor());
            mv.visitInsn(177);
        }
        mv.visitLabel(defaultLabel);
    }
}

