/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final BeanPropertyAccessor _propertyAccessor;
    protected final int _propertyIndex;
    private final BeanPropertyWriter fallbackWriter;
    private boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter);
        this.fallbackWriter = this.unwrapFallbackWriter(beanPropertyWriter);
        this._serializer = jsonSerializer;
        this._propertyAccessor = beanPropertyAccessor;
        this._propertyIndex = n;
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter beanPropertyWriter) {
        while (beanPropertyWriter instanceof OptimizedBeanPropertyWriter) {
            beanPropertyWriter = ((OptimizedBeanPropertyWriter)beanPropertyWriter).fallbackWriter;
        }
        return beanPropertyWriter;
    }

    public abstract T withAccessor(BeanPropertyAccessor var1);

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    public final void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            this.unsafeSerializeAsField(object, jsonGenerator, serializerProvider);
        }
        catch (IllegalAccessError illegalAccessError) {
            System.err.format("Disabling Afterburner for %s due to access error%n", object.getClass());
            illegalAccessError.printStackTrace();
            this.broken = true;
            this.fallbackWriter.serializeAsField(object, jsonGenerator, serializerProvider);
        }
        catch (SecurityException securityException) {
            System.err.format("Disabling Afterburner for %s due to access error%n", object.getClass());
            securityException.printStackTrace();
            this.broken = true;
            this.fallbackWriter.serializeAsField(object, jsonGenerator, serializerProvider);
        }
    }

    public abstract void unsafeSerializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;
}

