/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import java.io.IOException;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty {
    protected final SettableBeanProperty _originalSettable;
    protected final BeanPropertyMutator _propertyMutator;
    protected final int _propertyIndex;

    public OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._originalSettable = src;
        this._propertyMutator = mutator;
        this._propertyIndex = index;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, JsonDeserializer<?> deser) {
        super(src, deser);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._propertyIndex = src._propertyIndex;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, String name) {
        super(src, name);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._propertyIndex = src._propertyIndex;
    }

    public abstract T withMutator(BeanPropertyMutator var1);

    public abstract T withValueDeserializer(JsonDeserializer<?> var1);

    public <A extends Annotation> A getAnnotation(Class<A> ann) {
        return (A)this._originalSettable.getAnnotation(ann);
    }

    public AnnotatedMember getMember() {
        return this._originalSettable.getMember();
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public abstract void set(Object var1, Object var2) throws IOException;

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._originalSettable.setAndReturn(instance, value);
    }

    protected final int _deserializeInt(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return jp.getIntValue();
        }
        return jp.getValueAsInt();
    }

    protected final long _deserializeLong(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return jp.getLongValue();
        }
        return jp.getValueAsLong();
    }

    protected final String _deserializeString(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            return jp.getText();
        }
        return this._convertToString(jp, ctxt, curr);
    }

    protected final String _convertToString(JsonParser jp, DeserializationContext ctxt, JsonToken curr) throws IOException, JsonProcessingException {
        if (curr == JsonToken.VALUE_NULL) {
            return null;
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = jp.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        if (curr.isScalarValue()) {
            return jp.getText();
        }
        throw ctxt.mappingException(String.class);
    }
}

