/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.codehaus.jackson.Base64Variants;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.introspect.AnnotatedMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty {
    protected final SettableBeanProperty _originalSettable;
    protected final BeanPropertyMutator _propertyMutator;
    protected final int _propertyIndex;

    public OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._originalSettable = src;
        this._propertyMutator = mutator;
        this._propertyIndex = index;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, JsonDeserializer<Object> deser) {
        super(src, deser);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._propertyIndex = src._propertyIndex;
    }

    public abstract T withMutator(BeanPropertyMutator var1);

    public abstract T withValueDeserializer(JsonDeserializer<Object> var1);

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public <A extends Annotation> A getAnnotation(Class<A> ann) {
        return (A)this._originalSettable.getAnnotation(ann);
    }

    public AnnotatedMember getMember() {
        return this._originalSettable.getMember();
    }

    public abstract void set(Object var1, Object var2) throws IOException;

    protected final String _convertToString(JsonParser jp, DeserializationContext ctxt, JsonToken curr) throws IOException, JsonProcessingException {
        if (curr == JsonToken.VALUE_NULL) {
            return null;
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = jp.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        if (curr.isScalarValue()) {
            return jp.getText();
        }
        throw ctxt.mappingException(String.class);
    }
}

