/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.AnyReader;
import com.fasterxml.jackson.jr.ob.impl.ArrayReader;
import com.fasterxml.jackson.jr.ob.impl.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.impl.CollectionReader;
import com.fasterxml.jackson.jr.ob.impl.MapBuilder;
import com.fasterxml.jackson.jr.ob.impl.TypeDetector;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JSONReader
extends ValueReader {
    protected final int _features;
    protected final boolean _arraysAsLists;
    protected final TreeCodec _treeCodec;
    protected final TypeDetector _typeDetector;
    protected final MapBuilder _mapBuilder;
    protected final CollectionBuilder _collectionBuilder;
    protected final JsonParser _parser;

    public JSONReader(int n, TypeDetector typeDetector, TreeCodec treeCodec, CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        this._features = n;
        this._typeDetector = typeDetector;
        this._treeCodec = treeCodec;
        this._collectionBuilder = collectionBuilder;
        this._mapBuilder = mapBuilder;
        this._arraysAsLists = JSON.Feature.READ_JSON_ARRAYS_AS_JAVA_ARRAYS.isDisabled(n);
        this._parser = null;
    }

    protected JSONReader(JSONReader jSONReader, JsonParser jsonParser) {
        int n;
        this._features = n = jSONReader._features;
        this._typeDetector = jSONReader._typeDetector.perOperationInstance(n);
        this._treeCodec = jSONReader._treeCodec;
        this._collectionBuilder = jSONReader._collectionBuilder.newBuilder(n);
        this._mapBuilder = jSONReader._mapBuilder.newBuilder(n);
        this._arraysAsLists = jSONReader._arraysAsLists;
        this._parser = jsonParser;
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final JSONReader withFeatures(int n) {
        if (this._features == n) {
            return this;
        }
        return this._with(n, this._typeDetector, this._treeCodec, this._collectionBuilder, this._mapBuilder);
    }

    public final JSONReader with(MapBuilder mapBuilder) {
        if (this._mapBuilder == mapBuilder) {
            return this;
        }
        return this._with(this._features, this._typeDetector, this._treeCodec, this._collectionBuilder, mapBuilder);
    }

    public final JSONReader with(CollectionBuilder collectionBuilder) {
        if (this._collectionBuilder == collectionBuilder) {
            return this;
        }
        return this._with(this._features, this._typeDetector, this._treeCodec, collectionBuilder, this._mapBuilder);
    }

    protected JSONReader _with(int n, TypeDetector typeDetector, TreeCodec treeCodec, CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override _with(...)");
        }
        return new JSONReader(n, typeDetector, treeCodec, collectionBuilder, mapBuilder);
    }

    public JSONReader perOperationInstance(JsonParser jsonParser) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONReader(this, jsonParser);
    }

    public final Object readValue() throws IOException {
        return AnyReader.std.read(this, this._parser);
    }

    public Map<Object, Object> readMap() throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_OBJECT) {
            throw JSONObjectException.from(this._parser, "Can not read a Map: expect to see START_OBJECT ('{'), instead got: " + this._tokenDesc(this._parser));
        }
        return AnyReader.std.readFromObject(this, this._parser, this._mapBuilder);
    }

    public List<Object> readList() throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc(this._parser));
        }
        return (List)AnyReader.std.readCollectionFromArray(this, this._parser, this._collectionBuilder);
    }

    public Object[] readArray() throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc(this._parser));
        }
        return AnyReader.std.readArrayFromArray(this, this._parser, this._collectionBuilder);
    }

    public <T> T readBean(Class<T> clazz) throws IOException {
        ValueReader valueReader = this._typeDetector.findReader(clazz);
        return (T)valueReader.read(this, this._parser);
    }

    public <T> T[] readArrayOf(Class<T> clazz) throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc(this._parser));
        }
        return (Object[])new ArrayReader(clazz, this._typeDetector.findReader(clazz)).read(this, this._parser);
    }

    public <T> List<T> readListOf(Class<T> clazz) throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc(this._parser));
        }
        return (List)new CollectionReader(List.class, this._typeDetector.findReader(clazz)).read(this, this._parser);
    }

    protected TreeCodec _treeCodec() throws JSONObjectException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No TreeCodec specified: can not bind JSON into TreeNode types");
        }
        return this._treeCodec;
    }

    protected MapBuilder _mapBuilder(Class<?> clazz) {
        return clazz == null ? this._mapBuilder : this._mapBuilder.newBuilder(clazz);
    }

    protected CollectionBuilder _collectionBuilder(Class<?> clazz) {
        return clazz == null ? this._collectionBuilder : this._collectionBuilder.newBuilder(clazz);
    }
}

