/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.BeanDefinition;
import com.fasterxml.jackson.jr.ob.impl.BeanProperty;
import com.fasterxml.jackson.jr.ob.impl.TypeDetector;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JSONWriter {
    protected final int _features;
    protected final TypeDetector _typeDetector;
    protected final TreeCodec _treeCodec;
    protected final boolean _requireSetter;
    protected final JsonGenerator _generator;

    public JSONWriter(int n, TypeDetector typeDetector, TreeCodec treeCodec) {
        this._features = n;
        this._typeDetector = typeDetector;
        this._treeCodec = treeCodec;
        this._generator = null;
        this._requireSetter = JSON.Feature.WRITE_READONLY_BEAN_PROPERTIES.isDisabled(n);
    }

    protected JSONWriter(JSONWriter jSONWriter, JsonGenerator jsonGenerator) {
        this._features = jSONWriter._features;
        this._typeDetector = jSONWriter._typeDetector.perOperationInstance(this._features);
        this._treeCodec = jSONWriter._treeCodec;
        this._generator = jsonGenerator;
        this._requireSetter = JSON.Feature.WRITE_READONLY_BEAN_PROPERTIES.isDisabled(this._features);
    }

    public final JSONWriter withFeatures(int n) {
        if (this._features == n) {
            return this;
        }
        return this._with(n, this._typeDetector, this._treeCodec);
    }

    public final JSONWriter with(TypeDetector typeDetector) {
        if (this._typeDetector == typeDetector) {
            return this;
        }
        return this._with(this._features, typeDetector, this._treeCodec);
    }

    public final JSONWriter with(TreeCodec treeCodec) {
        if (this._treeCodec == treeCodec) {
            return this;
        }
        return this._with(this._features, this._typeDetector, treeCodec);
    }

    protected JSONWriter _with(int n, TypeDetector typeDetector, TreeCodec treeCodec) {
        if (this.getClass() != JSONWriter.class) {
            throw new IllegalStateException("Sub-classes MUST override _with(...)");
        }
        return new JSONWriter(n, typeDetector, treeCodec);
    }

    public JSONWriter perOperationInstance(JsonGenerator jsonGenerator) {
        if (this.getClass() != JSONWriter.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONWriter(this, jsonGenerator);
    }

    public final void writeValue(Object object) throws IOException, JsonProcessingException {
        if (object == null) {
            this.writeNullValue();
            return;
        }
        this._writeValue(object, this._typeDetector.findFullType(object.getClass()));
    }

    public void writeField(String string, Object object) throws IOException, JsonProcessingException {
        if (object == null) {
            if (JSON.Feature.WRITE_NULL_PROPERTIES.isEnabled(this._features)) {
                this.writeNullField(string);
            }
            return;
        }
        int n = this._typeDetector.findFullType(object.getClass());
        switch (n) {
            case 1: {
                this.writeMapField(string, (Map)object);
                return;
            }
            case 2: {
                this.writeListField(string, (List)object);
                return;
            }
            case 3: {
                this.writeCollectionField(string, (Collection)object);
                return;
            }
            case 4: {
                this.writeObjectArrayField(string, (Object[])object);
                return;
            }
            case 5: {
                this.writeIntArrayField(string, (int[])object);
                return;
            }
            case 6: {
                this.writeLongArrayField(string, (long[])object);
                return;
            }
            case 7: {
                this.writeBooleanArrayField(string, (boolean[])object);
                return;
            }
            case 8: {
                this.writeTreeNodeField(string, (TreeNode)object);
                return;
            }
            case 9: {
                this.writeStringField(string, (String)object);
                return;
            }
            case 11: {
                this.writeStringField(string, new String((char[])object));
                return;
            }
            case 10: {
                this.writeStringField(string, ((CharSequence)object).toString());
                return;
            }
            case 12: {
                this.writeBinaryField(string, (byte[])object);
                return;
            }
            case 20: {
                this.writeBigDecimalField(string, (BigDecimal)object);
                return;
            }
            case 19: {
                this.writeBigIntegerField(string, (BigInteger)object);
                return;
            }
            case 17: 
            case 18: {
                this.writeDoubleField(string, ((Number)object).doubleValue());
                return;
            }
            case 13: 
            case 14: 
            case 15: {
                this.writeIntField(string, ((Number)object).intValue());
                return;
            }
            case 16: {
                this.writeLongField(string, ((Number)object).longValue());
                return;
            }
            case 21: {
                this.writeBooleanField(string, (Boolean)object);
                return;
            }
            case 22: {
                this.writeStringField(string, String.valueOf(object));
                return;
            }
            case 25: {
                object = ((Calendar)object).getTime();
            }
            case 24: {
                this.writeDateField(string, (Date)object);
                return;
            }
            case 23: {
                this.writeEnumField(string, (Enum)object);
                return;
            }
            case 26: {
                this.writeStringLikeField(string, ((Class)object).getName(), n);
                return;
            }
            case 27: {
                this.writeStringLikeField(string, ((File)object).getAbsolutePath(), n);
                return;
            }
            case 28: 
            case 29: 
            case 30: {
                this.writeStringLikeValue(object.toString(), n);
            }
            case 31: {
                this.writeIterableField(string, (Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownField(string, object);
                return;
            }
        }
        if (n < 0) {
            BeanDefinition beanDefinition = this._typeDetector.getBeanDefinition(n);
            if (beanDefinition == null) {
                throw new IllegalStateException("Internal error: missing BeanDefinition for id " + n + " (class " + object.getClass().getName() + ")");
            }
            this._generator.writeFieldName(string);
            this.writeBeanValue(beanDefinition, object);
        }
        throw new IllegalStateException("Unsupported type: " + n);
    }

    protected void _writeValue(Object object, int n) throws IOException {
        switch (n) {
            case 1: {
                this.writeMapValue((Map)object);
                return;
            }
            case 2: {
                this.writeListValue((List)object);
                return;
            }
            case 3: {
                this.writeCollectionValue((Collection)object);
                return;
            }
            case 4: {
                this.writeObjectArrayValue((Object[])object);
                return;
            }
            case 5: {
                this.writeIntArrayValue((int[])object);
                return;
            }
            case 6: {
                this.writeLongArrayValue((long[])object);
                return;
            }
            case 7: {
                this.writeBooleanArrayValue((boolean[])object);
                return;
            }
            case 8: {
                this.writeTreeNodeValue((TreeNode)object);
                return;
            }
            case 9: {
                this.writeStringValue((String)object);
                return;
            }
            case 11: {
                this.writeStringValue(new String((char[])object));
                return;
            }
            case 10: {
                this.writeStringValue(((CharSequence)object).toString());
                return;
            }
            case 12: {
                this.writeBinaryValue((byte[])object);
                return;
            }
            case 17: 
            case 18: {
                this.writeDoubleValue(((Number)object).doubleValue());
                return;
            }
            case 13: 
            case 14: 
            case 15: {
                this.writeIntValue(((Number)object).intValue());
                return;
            }
            case 16: {
                this.writeLongValue(((Number)object).longValue());
                return;
            }
            case 20: {
                this.writeBigDecimalValue((BigDecimal)object);
                return;
            }
            case 19: {
                this.writeBigIntegerValue((BigInteger)object);
                return;
            }
            case 21: {
                this.writeBooleanValue((Boolean)object);
                return;
            }
            case 22: {
                this.writeStringValue(String.valueOf(object));
                return;
            }
            case 25: {
                object = ((Calendar)object).getTime();
            }
            case 24: {
                this.writeDateValue((Date)object);
                return;
            }
            case 23: {
                this.writeEnumValue((Enum)object);
                return;
            }
            case 26: {
                this.writeStringLikeValue(((Class)object).getName(), n);
                return;
            }
            case 27: {
                this.writeStringLikeValue(((File)object).getAbsolutePath(), n);
                return;
            }
            case 28: 
            case 29: 
            case 30: {
                this.writeStringLikeValue(object.toString(), n);
                return;
            }
            case 31: {
                this.writeIterableValue((Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownValue(object);
                return;
            }
        }
        if (n < 0) {
            BeanDefinition beanDefinition = this._typeDetector.getBeanDefinition(n);
            if (beanDefinition == null) {
                throw new IllegalStateException("Internal error: missing BeanDefinition for id " + n + " (class " + object.getClass().getName() + ")");
            }
            this.writeBeanValue(beanDefinition, object);
            return;
        }
        throw new IllegalStateException("Unsupported type: " + n + " (class " + object.getClass().getName() + ")");
    }

    protected void writeCollectionValue(Collection<?> collection) throws IOException {
        this._generator.writeStartArray();
        for (Object obj : collection) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeCollectionField(String string, Collection<?> collection) throws IOException {
        this._generator.writeFieldName(string);
        this.writeCollectionValue(collection);
    }

    protected void writeIterableValue(Iterable<?> iterable) throws IOException {
        this._generator.writeStartArray();
        for (Object obj : iterable) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeIterableField(String string, Iterable<?> iterable) throws IOException {
        this._generator.writeFieldName(string);
        this.writeIterableValue(iterable);
    }

    protected void writeListValue(List<?> list) throws IOException {
        this._generator.writeStartArray();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.writeValue(list.get(i));
        }
        this._generator.writeEndArray();
    }

    protected void writeListField(String string, List<?> list) throws IOException {
        this._generator.writeFieldName(string);
        this.writeListValue(list);
    }

    protected void writeMapValue(Map<?, ?> map) throws IOException {
        this._generator.writeStartObject();
        if (!map.isEmpty()) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.writeField(this.keyToString(entry.getKey()), entry.getValue());
            }
        }
        this._generator.writeEndObject();
    }

    protected void writeMapField(String string, Map<?, ?> map) throws IOException {
        this._generator.writeFieldName(string);
        this.writeMapValue(map);
    }

    protected void writeObjectArrayValue(Object[] objectArray) throws IOException {
        this._generator.writeStartArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.writeValue(objectArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeObjectArrayField(String string, Object[] objectArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeObjectArrayValue(objectArray);
    }

    protected void writeIntArrayValue(int[] nArray) throws IOException {
        this._generator.writeStartArray();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(nArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeIntArrayField(String string, int[] nArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeIntArrayValue(nArray);
    }

    protected void writeLongArrayValue(long[] lArray) throws IOException {
        this._generator.writeStartArray();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(lArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeLongArrayField(String string, long[] lArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeLongArrayValue(lArray);
    }

    protected void writeBooleanArrayValue(boolean[] blArray) throws IOException {
        this._generator.writeStartArray();
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeBoolean(blArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeBooleanArrayField(String string, boolean[] blArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeBooleanArrayValue(blArray);
    }

    protected void writeTreeNodeValue(TreeNode treeNode) throws IOException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No TreeCodec configured: can not serializer TreeNode values");
        }
        this._treeCodec.writeTree(this._generator, treeNode);
    }

    protected void writeTreeNodeField(String string, TreeNode treeNode) throws IOException {
        this._generator.writeFieldName(string);
        this.writeTreeNodeValue(treeNode);
    }

    protected void writeBooleanValue(boolean bl) throws IOException {
        this._generator.writeBoolean(bl);
    }

    protected void writeBooleanField(String string, boolean bl) throws IOException {
        this._generator.writeBooleanField(string, bl);
    }

    protected void writeIntValue(int n) throws IOException {
        this._generator.writeNumber(n);
    }

    protected void writeIntField(String string, int n) throws IOException {
        this._generator.writeNumberField(string, n);
    }

    protected void writeLongValue(long l) throws IOException {
        this._generator.writeNumber(l);
    }

    protected void writeBigIntegerValue(BigInteger bigInteger) throws IOException {
        this._generator.writeNumber(bigInteger);
    }

    protected void writeBigIntegerField(String string, BigInteger bigInteger) throws IOException {
        this._generator.writeFieldName(string);
        this.writeBigIntegerValue(bigInteger);
    }

    protected void writeLongField(String string, long l) throws IOException {
        this._generator.writeNumberField(string, l);
    }

    protected void writeDoubleValue(double d) throws IOException {
        this._generator.writeNumber(d);
    }

    protected void writeDoubleField(String string, double d) throws IOException {
        this._generator.writeNumberField(string, d);
    }

    protected void writeBigDecimalValue(BigDecimal bigDecimal) throws IOException {
        this._generator.writeNumber(bigDecimal);
    }

    protected void writeBigDecimalField(String string, BigDecimal bigDecimal) throws IOException {
        this._generator.writeNumberField(string, bigDecimal);
    }

    protected void writeStringValue(String string) throws IOException {
        this._generator.writeString(string);
    }

    protected void writeStringField(String string, String string2) throws IOException {
        this._generator.writeStringField(string, string2);
    }

    protected void writeStringLikeValue(String string, int n) throws IOException {
        this._generator.writeString(string);
    }

    protected void writeStringLikeField(String string, String string2, int n) throws IOException {
        this._generator.writeStringField(string, string2);
    }

    protected void writeBinaryValue(byte[] byArray) throws IOException {
        this._generator.writeBinary(byArray);
    }

    protected void writeBinaryField(String string, byte[] byArray) throws IOException {
        this._generator.writeBinaryField(string, byArray);
    }

    protected void writeNullValue() throws IOException {
        this._generator.writeNull();
    }

    protected void writeNullField(String string) throws IOException {
        if (JSON.Feature.WRITE_NULL_PROPERTIES.isEnabled(this._features)) {
            this._generator.writeNullField(string);
        }
    }

    protected void writeNullField(SerializedString serializedString) throws IOException {
        if (JSON.Feature.WRITE_NULL_PROPERTIES.isEnabled(this._features)) {
            this._generator.writeFieldName((SerializableString)serializedString);
            this._generator.writeNull();
        }
    }

    protected void writeDateValue(Date date) throws IOException {
        this.writeStringValue(date.toString());
    }

    protected void writeDateField(String string, Date date) throws IOException {
        this.writeStringField(string, date.toString());
    }

    protected void writeEnumValue(Enum<?> enum_) throws IOException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntValue(enum_.ordinal());
        } else {
            this.writeStringValue(enum_.toString());
        }
    }

    protected void writeEnumField(String string, Enum<?> enum_) throws IOException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntField(string, enum_.ordinal());
        } else {
            this.writeStringField(string, enum_.toString());
        }
    }

    protected void writeBeanValue(BeanDefinition beanDefinition, Object object) throws IOException {
        this._generator.writeStartObject();
        for (BeanProperty beanProperty : beanDefinition.properties()) {
            Object object2;
            SerializedString serializedString;
            if (this._requireSetter) {
                serializedString = beanProperty.getNameIfHasSetter();
                if (serializedString == null) {
                    continue;
                }
            } else {
                serializedString = beanProperty.getName();
            }
            if ((object2 = beanProperty.getValueFor(object)) == null) {
                this.writeNullField(serializedString);
                continue;
            }
            int n = beanProperty.getTypeId();
            if (n == 0) {
                n = this._typeDetector.findFullType(object2.getClass());
            }
            this._generator.writeFieldName((SerializableString)serializedString);
            this._writeValue(object2, n);
        }
        this._generator.writeEndObject();
    }

    protected void writeUnknownValue(Object object) throws IOException {
        this._checkUnknown(object);
        this.writeStringValue(object.toString());
    }

    protected void writeUnknownField(String string, Object object) throws IOException {
        this._checkUnknown(object);
        this.writeStringField(string, object.toString());
    }

    protected void _checkUnknown(Object object) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE.isEnabled(this._features)) {
            throw new JSONObjectException("Unrecognized type (" + object.getClass().getName() + "), don't know how to write (disable " + (Object)((Object)JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE) + " to avoid exception)");
        }
    }

    protected String keyToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }
}

