/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.impl.BeanDefinition;
import com.fasterxml.jackson.jr.ob.impl.BeanProperty;
import com.fasterxml.jackson.jr.ob.impl.ClassKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class TypeDetector {
    public static final int SER_UNKNOWN = 0;
    public static final int SER_MAP = 1;
    public static final int SER_LIST = 2;
    public static final int SER_COLLECTION = 3;
    public static final int SER_OBJECT_ARRAY = 4;
    public static final int SER_INT_ARRAY = 5;
    public static final int SER_LONG_ARRAY = 6;
    public static final int SER_BOOLEAN_ARRAY = 7;
    public static final int SER_TREE_NODE = 8;
    public static final int SER_STRING = 9;
    public static final int SER_CHARACTER_SEQUENCE = 10;
    public static final int SER_CHAR_ARRAY = 11;
    public static final int SER_BYTE_ARRAY = 12;
    public static final int SER_NUMBER_BYTE = 13;
    public static final int SER_NUMBER_SHORT = 14;
    public static final int SER_NUMBER_INTEGER = 15;
    public static final int SER_NUMBER_LONG = 16;
    public static final int SER_NUMBER_FLOAT = 17;
    public static final int SER_NUMBER_DOUBLE = 18;
    public static final int SER_NUMBER_BIG_INTEGER = 19;
    public static final int SER_NUMBER_BIG_DECIMAL = 20;
    public static final int SER_BOOLEAN = 21;
    public static final int SER_CHAR = 22;
    public static final int SER_ENUM = 23;
    public static final int SER_DATE = 24;
    public static final int SER_CALENDAR = 25;
    public static final int SER_CLASS = 26;
    public static final int SER_FILE = 27;
    public static final int SER_UUID = 28;
    public static final int SER_URL = 29;
    public static final int SER_URI = 30;
    public static final int SER_ITERABLE = 31;
    protected final ConcurrentHashMap<ClassKey, Integer> _knownSerTypes;
    protected final CopyOnWriteArrayList<BeanDefinition> _knownBeans;
    protected ClassKey _key = new ClassKey();
    protected final boolean _forSerialization;
    protected Class<?> _prevClass;
    protected int _prevType;
    protected int _features;
    protected final BeanProperty[] NO_PROPS = new BeanProperty[0];

    protected TypeDetector(boolean bl, ConcurrentHashMap<ClassKey, Integer> concurrentHashMap, CopyOnWriteArrayList<BeanDefinition> copyOnWriteArrayList, int n) {
        this._forSerialization = bl;
        this._knownSerTypes = concurrentHashMap;
        this._knownBeans = copyOnWriteArrayList;
        this._features = n;
    }

    protected TypeDetector(TypeDetector typeDetector, int n) {
        this._forSerialization = typeDetector._forSerialization;
        this._knownSerTypes = typeDetector._knownSerTypes;
        this._knownBeans = typeDetector._knownBeans;
        this._features = n;
    }

    public static final TypeDetector rootDetector(boolean bl, int n) {
        return new TypeDetector(bl, new ConcurrentHashMap<ClassKey, Integer>(50, 0.75f, 4), new CopyOnWriteArrayList<BeanDefinition>(), n);
    }

    public TypeDetector perOperationInstance(int n) {
        return new TypeDetector(this, n);
    }

    public BeanDefinition getBeanDefinition(int n) {
        if (n < 0) {
            n = -(n + 1);
        }
        return this._knownBeans.get(n);
    }

    public final int findFullType(Class<?> clazz) {
        int n;
        if (clazz == this._prevClass) {
            return this._prevType;
        }
        ClassKey classKey = this._key;
        classKey.reset(clazz);
        Integer n2 = this._knownSerTypes.get(classKey);
        if (n2 == null) {
            n = this._findFull(clazz);
            this._knownSerTypes.put(new ClassKey(clazz), n);
        } else {
            n = n2;
        }
        this._prevType = n;
        this._prevClass = clazz;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _findFull(Class<?> clazz) {
        int n = this._findSimple(clazz);
        if (n == 0 && JSON.Feature.HANDLE_JAVA_BEANS.isEnabled(this._features)) {
            BeanDefinition beanDefinition = this._resolveBean(clazz);
            CopyOnWriteArrayList<BeanDefinition> copyOnWriteArrayList = this._knownBeans;
            synchronized (copyOnWriteArrayList) {
                ClassKey classKey = new ClassKey(clazz);
                Integer n2 = this._knownSerTypes.get(classKey);
                if (n2 != null) {
                    return n2;
                }
                this._knownBeans.add(beanDefinition);
                int n3 = -this._knownBeans.size();
                this._knownSerTypes.put(classKey, n3);
                return n3;
            }
        }
        return n;
    }

    protected int _findSimple(Class<?> clazz) {
        if (clazz == String.class) {
            return 9;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 12;
                }
                if (clazz == char[].class) {
                    return 11;
                }
                if (clazz == int[].class) {
                    return 5;
                }
                if (clazz == long[].class) {
                    return 6;
                }
                if (clazz == boolean[].class) {
                    return 7;
                }
                return 0;
            }
            if (clazz2 == Object.class || this._forSerialization) {
                return 4;
            }
            return 0;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 21;
            }
            if (clazz == Integer.TYPE) {
                return 15;
            }
            if (clazz == Long.TYPE) {
                return 16;
            }
            if (clazz == Byte.TYPE) {
                return 13;
            }
            if (clazz == Short.TYPE) {
                return 14;
            }
            if (clazz == Double.TYPE) {
                return 18;
            }
            if (clazz == Float.TYPE) {
                return 17;
            }
            if (clazz == Character.TYPE) {
                return 22;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 21;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 15;
            }
            if (clazz == Long.class) {
                return 16;
            }
            if (clazz == Byte.class) {
                return 13;
            }
            if (clazz == Short.class) {
                return 14;
            }
            if (clazz == Double.class) {
                return 18;
            }
            if (clazz == Float.class) {
                return 17;
            }
            if (clazz == BigDecimal.class) {
                return 20;
            }
            if (clazz == BigInteger.class) {
                return 19;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 22;
        }
        if (clazz.isEnum()) {
            return 23;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 2;
            }
            return 3;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 25;
        }
        if (clazz == Class.class) {
            return 26;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 24;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 27;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 29;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 30;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 28;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (this._forSerialization && Iterable.class.isAssignableFrom(clazz)) {
            return 31;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected BeanDefinition _resolveBean(Class<?> clazz) {
        void var5_9;
        Object object;
        BeanInfo beanInfo;
        boolean bl = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        try {
            beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException("Failed to introspect BeanInfo for type '" + clazz.getName() + "': " + introspectionException.getMessage(), introspectionException);
        }
        ArrayList<BeanProperty> arrayList = new ArrayList<BeanProperty>();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            if (clazz2 == null) continue;
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            if (method != null) {
                object = method.getName();
                object = object.startsWith("get") ? Introspector.decapitalize(object.substring(3)) : (object.startsWith("is") ? Introspector.decapitalize(object.substring(3)) : Introspector.decapitalize(object));
            } else {
                if (method2 == null) continue;
                object = method2.getName();
                object = object.startsWith("set") ? Introspector.decapitalize(object.substring(3)) : Introspector.decapitalize(object);
            }
            int n = this._findSimple(clazz2);
            if (bl) {
                if (method != null) {
                    method.setAccessible(true);
                }
                if (method2 != null) {
                    method2.setAccessible(true);
                }
            }
            BeanProperty beanProperty = new BeanProperty((String)object, clazz2, n, method, method2);
            arrayList.add(beanProperty);
        }
        if (this._forSerialization) {
            int n = arrayList.size();
            BeanProperty[] beanPropertyArray = n == 0 ? this.NO_PROPS : arrayList.toArray(new BeanProperty[n]);
            return new BeanDefinition(clazz, beanPropertyArray);
        }
        Object var5_8 = null;
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        for (Constructor<?> constructor3 : clazz.getDeclaredConstructors()) {
            object = constructor3.getParameterTypes();
            if (((Class<?>[])object).length == 0) {
                Constructor<?> constructor4 = constructor3;
            } else {
                if (((Class<?>[])object).length != 1) continue;
                Class<?> clazz3 = object[0];
                if (clazz3 == String.class) {
                    constructor = constructor3;
                } else {
                    if (clazz3 != Long.class && clazz3 != Long.TYPE) continue;
                    constructor2 = constructor3;
                }
            }
            if (!bl) continue;
            constructor3.setAccessible(true);
        }
        HashMap<String, BeanProperty> hashMap = new HashMap<String, BeanProperty>();
        for (BeanProperty beanProperty : arrayList) {
            hashMap.put(beanProperty.getName().toString(), beanProperty);
        }
        return new BeanDefinition(clazz, (Map<String, BeanProperty>)hashMap, (Constructor<?>)var5_9, constructor, constructor2);
    }
}

